/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.toolkit.client.ui.security.AccessMask;
import com.filenet.wcm.toolkit.client.ui.security.AccessRight;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMaps;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityMapUtil;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.security.WcmSecurityAccessUtil;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class WcmSummarySecModel
extends AbstractTableModel {
    private static String[][] keys = new String[][]{{"View Properties", WcmSecurityAccessUtil.NAME_VIEWPROPS.toString()}, {"View Content", WcmSecurityAccessUtil.NAME_VIEWCONTENT.toString()}, {"Add to Folder", WcmSecurityAccessUtil.NAME_ADDTOFOLDER.toString()}, {"Modify Properties", WcmSecurityAccessUtil.NAME_MODIFYPROPS.toString()}, {"Modify Content", WcmSecurityAccessUtil.NAME_MODIFYCONTENT.toString()}, {"Promote Version", WcmSecurityAccessUtil.NAME_PROMOTEVERSION.toString()}, {"Full Control", WcmSecurityAccessUtil.NAME_OWNERCTRL.toString()}};
    public ColumnAttribute[] colAttributes;
    private SecurityMaps secMaps;
    private boolean isModified;
    private WcmSecurityMapUtil mapUtil;
    private int objType;

    public WcmSummarySecModel(Session session, Permissions objPerms, Permissions templatePerms, int objType, String userName) throws Exception {
        this.initModel(session, objPerms, templatePerms, objType, userName);
        this.initColumnAttributes();
        this.objType = objType;
    }

    public int getObjectType() {
        return this.objType;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void clearModified() {
        this.isModified = false;
    }

    public Permissions getPermissions() {
        return this.buildPermissions(this.secMaps);
    }

    private Permissions buildPermissions(SecurityMaps secMaps) {
        if (secMaps == null || secMaps.size() == 0) {
            return null;
        }
        Permissions perms = ObjectFactory.getPermissions();
        if (perms != null) {
            for (int i = 0; i < secMaps.size(); ++i) {
                SecurityMap secMap = (SecurityMap)secMaps.get(i);
                int access = secMap.accessMask.allow;
                if (access != 0) {
                    perms.add((Object)ObjectFactory.getPermission((int)access, (int)1, (String)secMap.granteeInfo.name, (int)secMap.granteeInfo.type));
                }
                if ((access = secMap.accessMask.deny) == 0) continue;
                perms.add((Object)ObjectFactory.getPermission((int)access, (int)2, (String)secMap.granteeInfo.name, (int)secMap.granteeInfo.type));
            }
        }
        return perms;
    }

    public int getRowCount() {
        return this.secMaps.size() == 0 ? 0 : this.secMaps.size();
    }

    public int getColumnCount() {
        return this.colAttributes.length == 0 ? 0 : this.colAttributes.length;
    }

    public String getColumnName(int col) {
        return this.colAttributes.length == 0 ? "" : this.colAttributes[col].colName;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column > this.colAttributes.length) {
            return null;
        }
        SecurityMap secMap = (SecurityMap)this.secMaps.get(row);
        String key = this.colAttributes[column].accessKey;
        if (column == 0) {
            return secMap.granteeUI;
        }
        AccessRight right = (AccessRight)secMap.accessRights.get(key);
        if (right != null) {
            if (right.secAccess.isExplicitAllowSet()) {
                return new Boolean(true);
            }
            if (right.secAccess.isExplicitDenySet()) {
                return new Boolean(false);
            }
            if (right.secAccess.isSystemAllowSet()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        return null;
    }

    public SecurityMap getRowData(String lookupKey) {
        int i;
        if (lookupKey != null && (i = this.mapUtil.findItemByName(this.secMaps, lookupKey)) >= 0) {
            SecurityMap secMap = (SecurityMap)this.secMaps.get(i);
            return (SecurityMap)secMap.clone();
        }
        return null;
    }

    public SecurityMap getRowData(int row) {
        return row < 0 || row >= this.getRowCount() ? null : (SecurityMap)((SecurityMap)this.secMaps.get(row)).clone();
    }

    public boolean addRow(SecurityMap secMap) {
        if (secMap != null && this.secMaps != null && this.secMaps.add(secMap)) {
            Collections.sort(this.secMaps, new SecMapComparator());
            this.isModified = true;
            return true;
        }
        return false;
    }

    public boolean removeRow(String granteeName) {
        int i;
        boolean bModified = false;
        if (granteeName != null && this.secMaps != null && (i = this.mapUtil.findItemByName(this.secMaps, granteeName)) >= 0) {
            try {
                SecurityMap secMap = (SecurityMap)this.secMaps.get(i);
                AccessMask accessMask = secMap.accessMask;
                if (accessMask.inheritedAllow > 0 || accessMask.inheritedDeny > 0 || accessMask.secPolicyAllow > 0 || accessMask.secPolicyDeny > 0) {
                    accessMask.allow = 0;
                    accessMask.deny = 0;
                    this.mapUtil.setAccessMask(secMap.accessMask.allow, secMap.accessMask.deny, secMap.accessMask.inheritedAllow, secMap.accessMask.inheritedDeny, secMap.accessMask.secPolicyAllow, secMap.accessMask.secPolicyDeny);
                    secMap.accessRights = this.mapUtil.getAccessRights();
                } else {
                    this.secMaps.remove(i);
                }
                this.isModified = true;
                bModified = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return bModified;
    }

    public boolean updateRow(SecurityMap secMap) {
        int i;
        boolean success = false;
        if (secMap != null && (i = this.mapUtil.findItemByName(this.secMaps, secMap.granteeInfo.name)) >= 0) {
            this.secMaps.remove(i);
            this.secMaps.add(i, secMap);
            this.isModified = true;
            success = true;
        }
        return success;
    }

    public void recomputeSecMap(String key, boolean check, int allowDeny, SecurityMap secMap) {
        this.mapUtil.setAccessMask(secMap.accessMask.allow, secMap.accessMask.deny, secMap.accessMask.inheritedAllow, secMap.accessMask.inheritedDeny, secMap.accessMask.secPolicyAllow, secMap.accessMask.secPolicyDeny);
        this.recomputeAccessRights(key, check, allowDeny, secMap);
    }

    public void recomputeAccessRights(String key, boolean check, int allowDeny, SecurityMap secMap) {
        try {
            AccessRight accessRight = (AccessRight)secMap.accessRights.get(key);
            if (check) {
                if (allowDeny == 1) {
                    this.mapUtil.grantAccess(accessRight.accessMask);
                } else if (allowDeny == 2) {
                    this.mapUtil.denyAccess(accessRight.accessMask);
                }
            } else {
                this.mapUtil.revokeAccess(accessRight.accessMask, allowDeny);
            }
            secMap.accessMask = this.mapUtil.getAccessMask();
            secMap.accessRights = this.mapUtil.getAccessRights();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSystemNotes(AccessRight accessRight) {
        return accessRight.secAccess.systemNote;
    }

    public SecurityMap getDefaultSecMap(String name, String dispname, String distinguishedName, int userType) {
        HashMap accessRights = new HashMap();
        AccessMask accessPerm = null;
        try {
            int allow = this.mapUtil.getDefaultAllowMask();
            int deny = this.mapUtil.getDefaultDenyMask();
            this.mapUtil.setAccessMask(allow, deny, 0, 0, 0, 0);
            accessRights = this.mapUtil.getAccessRights();
            accessPerm = new AccessMask(allow, deny, 0, 0, 0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SecurityMap(name, dispname, distinguishedName, userType, accessRights, accessPerm);
    }

    private void initModel(Session session, Permissions objPerms, Permissions templatePerms, int objType, String userName) throws Exception {
        if (this.mapUtil == null) {
            this.mapUtil = new WcmSecurityMapUtil(objType);
        }
        if (this.secMaps == null) {
            this.secMaps = new SecurityMaps();
        }
        if (this.secMaps != null) {
            this.secMaps = this.mapUtil.initSecurityMap(session, this.secMaps, objPerms, templatePerms, userName);
        }
        if (this.secMaps != null) {
            Collections.sort(this.secMaps, new SecMapComparator());
        }
    }

    private void initColumnAttributes() {
        Dimension dim;
        HashMap accessRights = ((SecurityMap)this.secMaps.get((int)0)).accessRights;
        int size = accessRights.size() + 1;
        if (this.colAttributes == null) {
            this.colAttributes = new ColumnAttribute[size];
        }
        if ((dim = WcmStringUtil.stringToDimension(WcmSecurityResource.secPanelDim)) == null) {
            dim = new Dimension(566, 350);
        }
        int colWidth = dim.width / (size + 11);
        AccessRight right = (AccessRight)accessRights.get("Publish");
        if (right != null) {
            this.colAttributes[size - 1] = new ColumnAttribute("Publish", WcmSecurityAccessUtil.NAME_PUBLISH.toString(), colWidth, 2);
            --size;
        }
        for (int i = 0; i < keys.length; ++i) {
            right = (AccessRight)accessRights.get(keys[i][0]);
            if (right == null) continue;
            this.colAttributes[size - 1] = new ColumnAttribute(keys[i][0], keys[i][1], colWidth, 2);
            --size;
        }
        this.colAttributes[size - 1] = new ColumnAttribute("", WcmSecurityResource.NAME_GRANTEE, colWidth * 3, 2);
    }

    class SecMapComparator
    implements Comparator {
        SecMapComparator() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof SecMapComparator;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof SecurityMap && obj2 instanceof SecurityMap) {
                SecurityMap secMap1 = (SecurityMap)obj1;
                SecurityMap secMap2 = (SecurityMap)obj2;
                return WcmString.compare(secMap1.granteeInfo.name, secMap2.granteeInfo.name);
            }
            return 1;
        }
    }

    class ColumnAttribute {
        public String colName;
        public String accessKey;
        public int colWidth;
        public int colAlignment;

        public ColumnAttribute(String key, String name, int width, int alignment) {
            this.accessKey = key;
            this.colName = name;
            this.colWidth = width;
            this.colAlignment = alignment;
        }
    }
}

