/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.WcmFilteredUsersAndGroupsPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WcmSelectUserGroupDialog
extends JDialog {
    JButton okButton;
    JButton cancelButton;
    JFrame frame;
    WcmFilteredUsersAndGroupsPanel filterUserGroupPanel;
    Session m_session;
    int status = 1;
    WcmSitePrefs m_sitePref = null;
    Window m_parent;

    public WcmSelectUserGroupDialog(Frame parent, Session session, WcmSitePrefs sitePrefs) throws Exception {
        super(parent, true);
        this.m_session = session;
        this.m_sitePref = sitePrefs;
        this.m_parent = parent;
        this.init(parent);
    }

    public WcmSelectUserGroupDialog(Dialog parent, Session session, WcmSitePrefs sitePrefs) throws Exception {
        super(parent, true);
        this.m_session = session;
        this.m_sitePref = sitePrefs;
        this.m_parent = parent;
        this.init(parent);
    }

    public void init(Window parent) throws Exception {
        Dimension dim = WcmStringUtil.stringToDimension(WcmSecurityResource.selectUserGrpDialogDim);
        if (dim == null) {
            dim = new Dimension(600, 350);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        this.setTitle(WcmSecurityResource.addUsersGroupsDlgTitle);
        this.createAndLayoutControls();
        this.setListeners();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmSelectUserGroupDialog.this.setVisible(false);
            }
        });
        this.applyComponentOrientation(parent.getComponentOrientation());
    }

    public int getStatus() {
        return this.status;
    }

    public WcmUserGroupItem[] getSelectItems() {
        if (this.filterUserGroupPanel == null) {
            return null;
        }
        return this.filterUserGroupPanel.getSelectUserGroupItems();
    }

    private void createAndLayoutControls() throws Exception {
        JPanel labelPanel = new JPanel();
        this.filterUserGroupPanel = new WcmFilteredUsersAndGroupsPanel(this.m_parent, this.m_session, this.m_sitePref);
        JPanel buttonPanel = this.createButtonPanel();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)labelPanel, "First");
        cp.add((Component)buttonPanel, "Last");
        cp.add((Component)((Object)this.filterUserGroupPanel), "Center");
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.okButton = new JButton(WcmResourceString.s_ok);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.okMonic));
        p.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.cancelButton = new JButton(WcmResourceString.s_cancel);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.cancelMonic));
        p.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        return p;
    }

    private void setListeners() {
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSelectUserGroupDialog.this.status = 0;
                WcmSelectUserGroupDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSelectUserGroupDialog.this.status = 1;
                WcmSelectUserGroupDialog.this.setVisible(false);
            }
        });
    }
}

