/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.security.WcmFilteredUsersPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WcmSelectUserDialog
extends JDialog
implements WcmDialogComponent {
    JButton okButton;
    JButton cancelButton;
    JFrame frame;
    WcmFilteredUsersPanel filterUserPanel;
    Session m_session;
    int status = 1;
    WcmSitePrefs m_sitePref = null;
    private ComponentOrientation componentOrientation;

    public WcmSelectUserDialog(Frame parent, Session session, WcmSitePrefs sitePref, ComponentOrientation componentOrientation) {
        super(parent, true);
        this.m_session = session;
        this.m_sitePref = sitePref;
        this.componentOrientation = componentOrientation;
        this.init(parent);
    }

    public WcmSelectUserDialog(Dialog parent, Session session, WcmSitePrefs sitePref, ComponentOrientation componentOrientation) {
        super(parent, true);
        this.m_session = session;
        this.m_sitePref = sitePref;
        this.componentOrientation = componentOrientation;
        this.init(parent);
    }

    public void init(Component parent) {
        try {
            Dimension dim = WcmStringUtil.stringToDimension(WcmSecurityResource.selectUserDialogDim);
            if (dim == null) {
                dim = new Dimension(300, 300);
            }
            this.setSize(dim);
            this.setLocationRelativeTo(parent);
            this.setTitle(WcmSecurityResource.selUsersDlgTitle);
            this.createAndLayoutControls();
            this.setListeners();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    WcmSelectUserDialog.this.setVisible(false);
                }
            });
            this.applyComponentOrientation(this.componentOrientation);
        }
        catch (Exception e) {
            System.out.println("Initializing the Select User Dialog exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public int getStatus() {
        return this.status;
    }

    private void createAndLayoutControls() throws Exception {
        JLabel labelPanel = new JLabel(WcmSecurityResource.showUsers);
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 4, 10, 3));
        this.filterUserPanel = new WcmFilteredUsersPanel(this, this.m_session, this.m_sitePref);
        JPanel buttonPanel = this.createButtonPanel();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)labelPanel, "First");
        cp.add((Component)buttonPanel, "Last");
        cp.add((Component)this.filterUserPanel, "Center");
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.okButton = new JButton(WcmResourceString.s_ok);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.okMonic));
        p.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.cancelButton = new JButton(WcmResourceString.s_cancel);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.cancelMonic));
        p.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        return p;
    }

    private void setListeners() {
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSelectUserDialog.this.status = 0;
                WcmSelectUserDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSelectUserDialog.this.status = 1;
                WcmSelectUserDialog.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.show();
        return this.status;
    }

    public Object getData() {
        if (this.filterUserPanel == null) {
            return null;
        }
        return this.filterUserPanel.getSelectedValue();
    }
}

