/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.AccessMask;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.WcmDetailSecDialog;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSelectUserGroupDialog;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WcmSecurityUpdatePanel
extends JPanel
implements ActionListener {
    private JButton addnewButton;
    private JButton removeButton;
    private JButton modifyButton;
    private WcmDetailSecDialog detailSecDialog;
    private Window parent;
    private boolean isReadOnly;
    private WcmSitePrefs m_sitePrefs = null;
    private WcmSelectUserGroupDialog m_selUserGrpDialog;
    private WcmSummarySecModel secModel;
    private SecurityMap secMap;
    private Session m_session;
    private boolean m_showCreatorOwner = false;
    private ImageIcon addnewIcon = WcmImageLoader.createImageIcon("state/Removed16.gif");
    private ImageIcon removeIcon = WcmImageLoader.createImageIcon("state/Removed16.gif");
    private ImageIcon modifyIcon = WcmImageLoader.createImageIcon("state/Modified16.gif");

    public WcmSecurityUpdatePanel(Window parent, Session session, boolean isReadOnly, WcmSummarySecModel secModel) {
        this.parent = parent;
        this.isReadOnly = isReadOnly;
        this.secModel = secModel;
        this.m_session = session;
        this.createComponents();
        this.layoutComponents();
        this.addnewButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
    }

    public void setMap(SecurityMap secMap) {
        this.secMap = secMap;
    }

    public void SetSitePrefs(WcmSitePrefs sitePrefs) {
        this.m_sitePrefs = sitePrefs;
    }

    public void enableButtons() {
        AccessMask accessMask = null;
        if (this.secMap != null) {
            accessMask = this.secMap.accessMask;
        }
        if (accessMask != null) {
            if (accessMask.allow == 0 && accessMask.deny == 0) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        } else if (!this.removeButton.isEnabled()) {
            this.removeButton.setEnabled(true);
        }
        if (!this.modifyButton.isEnabled()) {
            this.modifyButton.setEnabled(true);
        }
    }

    public void disableButtons() {
        if (this.removeButton.isEnabled()) {
            this.removeButton.setEnabled(false);
        }
        if (this.modifyButton.isEnabled()) {
            this.modifyButton.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isReadOnly) {
            this.addnewButton.setEnabled(false);
        } else {
            this.addnewButton.setEnabled(enabled);
        }
    }

    public void setShowCreatorOwner(boolean showFlag) {
        this.m_showCreatorOwner = showFlag;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addnewButton)) {
            WcmUserGroupItem[] selItems;
            try {
                this.m_selUserGrpDialog = this.parent instanceof Dialog ? new WcmSelectUserGroupDialog((Dialog)this.parent, this.m_session, this.m_sitePrefs) : (this.parent instanceof Frame ? new WcmSelectUserGroupDialog((Frame)this.parent, this.m_session, this.m_sitePrefs) : new WcmSelectUserGroupDialog((Frame)null, this.m_session, this.m_sitePrefs));
                this.m_selUserGrpDialog.filterUserGroupPanel.m_itemFilterPanel.setShowCreatorOwner(this.m_showCreatorOwner);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_selUserGrpDialog.setVisible(true);
            if (this.m_selUserGrpDialog.getStatus() == 0 && (selItems = this.m_selUserGrpDialog.getSelectItems()) != null) {
                for (int idx = 0; idx < selItems.length; ++idx) {
                    WcmUserGroupItem selItem = selItems[idx];
                    String name = selItem.getLongName();
                    int itemType = selItem.getType() == 1 ? 2001 : 2000;
                    if (name == null || this.secModel.getRowData(name) != null) continue;
                    this.secMap = this.secModel.getDefaultSecMap(name, selItem.getName(), selItem.getDistinguishedName(), itemType);
                    this.secModel.addRow(this.secMap);
                    this.secModel.fireTableDataChanged();
                }
            }
        } else if (e.getSource().equals(this.modifyButton)) {
            if (this.secMap == null) {
                JOptionPane.showMessageDialog(null, WcmSecurityResource.nullsecmap, "InformationMessage", 1);
            } else {
                SecurityMap cloneSecMap = (SecurityMap)this.secMap.clone();
                try {
                    this.detailSecDialog = this.parent instanceof Dialog ? new WcmDetailSecDialog((Dialog)this.parent, this.isReadOnly, false, this.secMap, this.secModel) : (this.parent instanceof Frame ? new WcmDetailSecDialog((Frame)this.parent, this.isReadOnly, false, this.secMap, this.secModel) : new WcmDetailSecDialog((Frame)null, this.isReadOnly, false, this.secMap, this.secModel));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.detailSecDialog.setVisible(true);
                if (this.detailSecDialog.getStatus() == 0) {
                    this.secModel.updateRow(this.secMap);
                    this.secModel.fireTableDataChanged();
                    this.disableButtons();
                } else {
                    this.secMap = cloneSecMap;
                }
            }
            if (this.parent != null) {
                this.parent.requestFocus();
            }
        } else if (e.getSource().equals(this.removeButton)) {
            this.secModel.removeRow(this.secMap.granteeInfo.name);
            this.secModel.fireTableDataChanged();
            if (this.parent != null) {
                this.parent.requestFocus();
            }
        }
    }

    private void createComponents() {
        this.addnewButton = new JButton(WcmResourceString.s_addnew);
        this.addnewButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.addMonic));
        this.addnewButton.setEnabled(!this.isReadOnly);
        this.removeButton = new JButton(WcmResourceString.s_remove);
        this.removeButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.removeMonic));
        this.removeButton.setEnabled(false);
        this.modifyButton = new JButton(WcmResourceString.s_modify);
        this.modifyButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.modifyMonic));
        this.modifyButton.setEnabled(false);
    }

    private void layoutComponents() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, this.getComponentOrientation().isLeftToRight() ? 22 : 21, 0, new Insets(6, 6, 6, 6), 0, 0));
        p.add((Component)this.addnewButton, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, this.getComponentOrientation().isLeftToRight() ? 22 : 21, 0, new Insets(6, 6, 6, 6), 0, 0));
        p.add((Component)this.removeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 6, 6), 0, 0));
        p.add((Component)this.modifyButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(p);
    }
}

