/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityUpdatePanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecPanel;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class WcmSecurityPanel
extends JPanel {
    private WcmSummarySecPanel summaryPanel;
    private WcmSecurityUpdatePanel updatePanel;
    private WcmSummarySecModel secModel;
    private boolean filterCreator = true;
    private WcmSitePrefs m_sitePrefs = null;

    public WcmSecurityPanel(Window parent, Session session, Permissions objPerms, int objType, boolean isReadOnly) throws Exception {
        if (session == null || objPerms == null || parent == null) {
            throw new WcmException("client.WcmSecurityPanel.IllegalArgumentException", "Invalid input parameters");
        }
        this.init(parent, session, objPerms, null, null, objType, isReadOnly, null);
    }

    public WcmSecurityPanel(Window parent, Session session, Permissions objPerms, List customGroupList, int objType, boolean isReadOnly) throws Exception {
        if (session == null || objPerms == null || parent == null) {
            throw new WcmException("client.WcmSecurityPanel.IllegalArgumentException", "Invalid input parameters");
        }
        this.filterCreator = false;
        this.init(parent, session, objPerms, null, customGroupList, objType, isReadOnly, null);
    }

    public WcmSecurityPanel(Window parent, Session session, Permissions objPerms, int objType, boolean isReadOnly, String userName) throws Exception {
        if (session == null || objPerms == null || parent == null || userName == null) {
            throw new WcmException("client.WcmSecurityPanel.IllegalArgumentException", "Invalid input parameters");
        }
        this.init(parent, session, objPerms, null, null, objType, isReadOnly, userName);
    }

    public WcmSecurityPanel(Window parent, Session session, Permissions objPerms, Permissions templatePerms, int objType, boolean isReadOnly) throws Exception {
        if (session == null || objPerms == null && templatePerms == null || parent == null) {
            throw new WcmException("client.WcmSecurityPanel.IllegalArgumentException", "Invalid input parameters");
        }
        this.init(parent, session, objPerms, templatePerms, null, objType, isReadOnly, null);
    }

    public WcmSecurityPanel(Window parent, Session session, Permissions objPerms, Permissions templatePerms, int objType, boolean isReadOnly, String userName) throws Exception {
        if (session == null || objPerms == null && templatePerms == null || parent == null || userName == null) {
            throw new WcmException("client.WcmSecurityPanel.IllegalArgumentException", "Invalid input parameters");
        }
        this.init(parent, session, objPerms, templatePerms, null, objType, isReadOnly, userName);
    }

    private void init(Window parent, Session session, Permissions objPerms, Permissions templatePerms, List customGroupList, int objType, boolean isReadOnly, String userName) throws Exception {
        Dimension dim = WcmStringUtil.stringToDimension(WcmSecurityResource.secPanelDim);
        if (dim == null) {
            dim = new Dimension(566, 350);
        }
        this.setPreferredSize(dim);
        this.initComponents(parent, session, objPerms, templatePerms, customGroupList, objType, isReadOnly, userName);
        this.summaryPanel.setCommand(this.updatePanel);
        JPanel topPanel = this.createTopPanel();
        JPanel middlePanel = this.createMiddlePanel();
        JPanel bottomPanel = this.createBottomPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "First");
        this.add((Component)middlePanel, "Center");
        this.add((Component)bottomPanel, "Last");
    }

    public void setSitePrefs(WcmSitePrefs sitepref) {
        this.m_sitePrefs = sitepref;
        if (this.updatePanel != null) {
            this.updatePanel.SetSitePrefs(this.m_sitePrefs);
        }
    }

    public void showCreatorOwner() {
        if (this.updatePanel != null) {
            this.updatePanel.setShowCreatorOwner(true);
        }
    }

    public boolean isModified() {
        return this.summaryPanel.isModified();
    }

    public void clearModified() {
        this.summaryPanel.clearModified();
    }

    public Permissions getPermissions() {
        return this.summaryPanel.getPermissions();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        this.summaryPanel.setEnabled(enabled);
        this.updatePanel.setEnabled(enabled);
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    private void initComponents(Window parent, Session session, Permissions objPerms, Permissions templatePerms, List customGroupList, int objType, boolean isReadOnly, String userName) throws Exception {
        this.summaryPanel = new WcmSummarySecPanel(session, objPerms, templatePerms, objType, isReadOnly, userName);
        this.secModel = (WcmSummarySecModel)this.summaryPanel.getTable().getModel();
        this.updatePanel = new WcmSecurityUpdatePanel(parent, session, isReadOnly, this.secModel);
        this.updatePanel.SetSitePrefs(this.m_sitePrefs);
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel(new GridLayout(1, 1));
        return topPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel middlePanel = new JPanel(new GridLayout(1, 1));
        middlePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        middlePanel.add(this.summaryPanel);
        return middlePanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(this.updatePanel);
        return panel;
    }
}

