/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Permission;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.toolkit.client.ui.security.AccessMask;
import com.filenet.wcm.toolkit.client.ui.security.AccessRight;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMaps;
import com.filenet.wcm.toolkit.client.ui.security.SorterUtil;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.security.WcmSecurityAccess;
import com.filenet.wcm.toolkit.util.security.WcmSecurityAccessUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class WcmSecurityMapUtil
extends WcmSecurityAccessUtil {
    public WcmSecurityMapUtil(int objType) throws Exception {
        this.setAccessLevels(objType);
    }

    public SecurityMaps initSecurityMap(Session session, SecurityMaps secMaps, Permissions objPerms, Permissions templatePerms, String userName) throws Exception {
        String prevGrantee = null;
        String curGrantee = null;
        int userType = 0;
        int prevUserType = 0;
        int permissionSource = 1;
        int inheritanceDepth = 0;
        Permission creatorOwnerPermission = null;
        int creatorOwnerUserType = 0;
        if (objPerms != null && templatePerms != null) {
            objPerms.addAll((Collection)templatePerms);
        } else if (objPerms == null && templatePerms != null) {
            objPerms = templatePerms;
        }
        if (secMaps == null || objPerms == null || objPerms.size() == 0) {
            throw new WcmException("client.SecurityMaps.IllegalArgementException", "Parameters not initialized");
        }
        Iterator it = objPerms.iterator();
        if (userName != null && userName.length() > 0) {
            while (it.hasNext()) {
                Permission permission = (Permission)it.next();
                if (permission.getGranteeName().compareTo("#CREATOR-OWNER") != 0) continue;
                creatorOwnerPermission = permission;
                creatorOwnerUserType = permission.getGranteeType();
                permission.setGranteeName(userName);
                permission.setGranteeType(2000);
                break;
            }
        }
        SorterUtil.sort(objPerms);
        this.setAccessMask(0, 0, 0, 0, 0, 0);
        for (Permission permission : objPerms) {
            curGrantee = permission.getGranteeName();
            userType = permission.getGranteeType();
            if (prevGrantee != null && WcmString.compare(curGrantee, prevGrantee) != 0) {
                secMaps = this.addToMap(session, secMaps, prevGrantee, prevUserType, permissionSource, inheritanceDepth);
                this.setAccessMask(0, 0, 0, 0, 0, 0);
            }
            prevGrantee = curGrantee;
            prevUserType = userType;
            int accessType = permission.getAccessType();
            int access = permission.getAccess();
            permissionSource = permission.getPermissionSource();
            inheritanceDepth = permission.getInheritableDepth();
            if (templatePerms != null && templatePerms.size() > 0 && templatePerms.contains((Object)permission)) {
                if (accessType == 1) {
                    this.securityPolicyAllow = access;
                    continue;
                }
                this.securityPolicyDeny = access;
                continue;
            }
            if (permission.isInherited()) {
                if (accessType == 1) {
                    this.inheritedAllow = access;
                    continue;
                }
                this.inheritedDeny = access;
                continue;
            }
            if (permissionSource == 2) {
                if (accessType == 1) {
                    this.securityPolicyAllow = access;
                    continue;
                }
                this.securityPolicyDeny = access;
                continue;
            }
            if (accessType == 1) {
                this.allow = access;
                continue;
            }
            this.deny = access;
        }
        if (prevGrantee != null) {
            secMaps = this.addToMap(session, secMaps, prevGrantee, prevUserType, permissionSource, inheritanceDepth);
            this.setAccessMask(0, 0, 0, 0, 0, 0);
        }
        if (creatorOwnerPermission != null) {
            creatorOwnerPermission.setGranteeName("#CREATOR-OWNER");
            creatorOwnerPermission.setGranteeType(creatorOwnerUserType);
        }
        return secMaps;
    }

    public SecurityMaps addToMap(Session session, SecurityMaps secMaps, String prevGrantee, int userType, int permissionSource, int inheritanceDepth) {
        Group grp;
        HashMap secRights = new HashMap();
        AccessMask accessPerm = null;
        String displayName = prevGrantee;
        String distinguishedName = prevGrantee;
        if (userType == 2000) {
            User user = (User)ObjectFactory.getGrantee((String)prevGrantee, (int)userType, (Session)session);
            if (user != null) {
                try {
                    displayName = user.getPropertyStringValue("DisplayName");
                }
                catch (Exception ex) {
                    displayName = prevGrantee;
                }
                try {
                    distinguishedName = user.getPropertyStringValue("DistinguishedName");
                }
                catch (Exception ex) {
                    distinguishedName = prevGrantee;
                }
            }
        } else if (userType == 2001 && (grp = (Group)ObjectFactory.getGrantee((String)prevGrantee, (int)userType, (Session)session)) != null) {
            try {
                displayName = grp.getPropertyStringValue("DisplayName");
            }
            catch (Exception ex) {
                displayName = prevGrantee;
            }
            try {
                distinguishedName = grp.getPropertyStringValue("DistinguishedName");
            }
            catch (Exception ex) {
                distinguishedName = prevGrantee;
            }
        }
        try {
            secRights = this.getAccessRights();
            accessPerm = new AccessMask(this.allow, this.deny, this.inheritedAllow, this.inheritedDeny, this.securityPolicyAllow, this.securityPolicyDeny);
            secMaps.add(new SecurityMap(prevGrantee, displayName, distinguishedName, userType, secRights, accessPerm, permissionSource, inheritanceDepth));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return secMaps;
    }

    public HashMap getAccessRights() throws Exception {
        if (this.accessLevels.length == 0) {
            throw new RuntimeException("Object access levels not set!");
        }
        HashMap<String, AccessRight> accessRights = new HashMap<String, AccessRight>();
        for (int i = 0; i < this.accessLevels.length; ++i) {
            int accessLevel = this.accessLevels[i];
            String key = this.getAccessKey(accessLevel);
            String accessName = WcmSecurityMapUtil.mapAccessLevelToName(accessLevel);
            WcmSecurityAccess secAccess = WcmSecurityMapUtil.computeAccessRight(this.allow, this.deny, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
            accessRights.put(key, new AccessRight(accessName, accessLevel, secAccess));
        }
        return accessRights;
    }

    public AccessMask getAccessMask() throws Exception {
        return new AccessMask(this.allow, this.deny, this.inheritedAllow, this.inheritedDeny, this.securityPolicyAllow, this.securityPolicyDeny);
    }

    public void setAccessMask(int allow, int deny, int inheritedAllow, int inheritedDeny, int secPolicyAllow, int secPolicyDeny) {
        this.allow = allow;
        this.deny = deny;
        this.inheritedAllow = inheritedAllow;
        this.inheritedDeny = inheritedDeny;
        this.securityPolicyAllow = secPolicyAllow;
        this.securityPolicyDeny = secPolicyDeny;
    }

    public int findItemByName(SecurityMaps maps, String name) {
        if (name != null && maps != null) {
            for (int i = 0; i < maps.size(); ++i) {
                SecurityMap secMap = (SecurityMap)maps.get(i);
                if (WcmString.compare(secMap.granteeInfo.name, name) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    private String getAccessKey(int accessLevel) {
        if (this.accessLevels.length == 0) {
            throw new RuntimeException("Object access levels not set!");
        }
        String accessKey = null;
        accessKey = accessLevel == 986583 || accessLevel == 987127 || accessLevel == 984535 || accessLevel == 983315 ? "Full Control" : (accessLevel == 132567 ? "Promote Version" : (accessLevel == 132563 || accessLevel == 132563 ? "Modify Content" : (accessLevel == 132499 || accessLevel == 135159 || accessLevel == 132499 || accessLevel == 131347 ? "Modify Properties" : (accessLevel == 131201 ? "View Content" : (accessLevel == 131073 ? "View Properties" : (accessLevel == 131121 ? "Add to Folder" : (accessLevel == 134547 ? "Publish" : WcmSecurityResource.NAME_UNKNOWN)))))));
        return accessKey;
    }
}

