/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.Groups;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.Users;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.SecUserRealm;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.ToolTipRenderer;
import com.filenet.wcm.toolkit.client.ui.security.UserGroupKeySelectionManager;
import com.filenet.wcm.toolkit.client.ui.security.WcmDetailSecDialog;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WcmSecurityAddPanel
extends JPanel {
    private JRadioButton userButton;
    private JRadioButton groupButton;
    private ButtonGroup userGroupButton;
    private JComboBox userGroupComboBox;
    private DefaultComboBoxModel userList;
    private DefaultComboBoxModel groupList;
    private boolean filterCreatorOwner;
    private JButton addButton;
    private WcmDetailSecDialog addDialog;
    private ImageIcon addIcon = WcmImageLoader.createImageIcon("state/New16.gif");
    private WcmSummarySecModel secModel;
    private SecurityMap secMap;
    private boolean isReadOnly;
    private Session session;
    private Window parent;

    public WcmSecurityAddPanel(Window parent, Session session, List customGroupList, boolean isReadOnly, WcmSummarySecModel secModel, boolean filterCreator) {
        this.filterCreatorOwner = filterCreator;
        this.init(parent, session, customGroupList, isReadOnly, secModel);
    }

    private void init(Window parent, Session session, List customGroupList, boolean isReadOnly, WcmSummarySecModel secModel) {
        this.session = session;
        this.isReadOnly = isReadOnly;
        this.parent = parent;
        this.secModel = secModel;
        this.createComponents();
        this.layoutComponents();
        this.setListeners();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        if (enabled && !this.isReadOnly) {
            this.userButton.setEnabled(true);
            this.groupButton.setEnabled(true);
        } else {
            this.userButton.setEnabled(false);
            this.groupButton.setEnabled(false);
        }
        if (enabled && (this.userButton.isSelected() || this.groupButton.isSelected())) {
            this.userGroupComboBox.setEnabled(true);
            if (this.groupButton.isSelected()) {
                this.populateGroupList();
            } else if (this.userButton.isSelected()) {
                this.populateUserList();
            }
        } else {
            this.userGroupComboBox.setEnabled(false);
        }
        boolean canEnab = enabled;
        if (canEnab) {
            canEnab = this.canEnableAddButton();
        }
        this.addButton.setEnabled(canEnab);
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    public boolean isComboxPopupVisible() {
        if (this.userGroupComboBox != null) {
            return this.userGroupComboBox.isPopupVisible();
        }
        return false;
    }

    private boolean canEnableAddButton() {
        boolean canEnab = true;
        if (this.userGroupComboBox.getSelectedIndex() > 0) {
            String name = null;
            Object selObj = this.userGroupComboBox.getSelectedItem();
            if (selObj instanceof String) {
                name = (String)selObj;
            } else if (selObj instanceof User) {
                name = ((User)selObj).getName();
            } else if (selObj instanceof Group) {
                name = ((Group)selObj).getName();
            }
            if (name != null) {
                SecurityMap secMap = this.secModel.getRowData(name);
                if (secMap != null) {
                    canEnab = false;
                }
            } else {
                canEnab = false;
            }
        } else {
            canEnab = false;
        }
        return canEnab;
    }

    private void createComponents() {
        this.userButton = new JRadioButton(WcmSecurityResource.USER, false);
        this.userButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.userMonic));
        this.userButton.setActionCommand(WcmSecurityResource.USER);
        this.groupButton = new JRadioButton(WcmSecurityResource.GROUP, false);
        this.groupButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.groupMonic));
        this.groupButton.setActionCommand(WcmSecurityResource.GROUP);
        this.userGroupButton = new ButtonGroup();
        this.userGroupButton.add(this.userButton);
        this.userGroupButton.add(this.groupButton);
        if (this.isReadOnly) {
            this.userButton.setEnabled(false);
            this.groupButton.setEnabled(false);
        } else {
            this.groupButton.setSelected(true);
        }
        this.userGroupComboBox = new JComboBox();
        Dimension dimension = WcmStringUtil.stringToDimension(WcmSecurityResource.userGroupCBDim);
        if (dimension == null) {
            dimension = new Dimension(240, 20);
        }
        this.userGroupComboBox.setPreferredSize(dimension);
        this.userGroupComboBox.setEditable(false);
        if (this.groupButton.isSelected()) {
            this.userGroupComboBox.setEnabled(true);
        } else {
            this.userGroupComboBox.setEnabled(false);
        }
        this.userGroupComboBox.setRenderer(new ToolTipRenderer());
        this.userGroupComboBox.setKeySelectionManager(new UserGroupKeySelectionManager());
        this.addButton = new JButton(WcmResourceString.s_addnew);
        this.addButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.addMonic));
        this.addButton.setEnabled(false);
        if (this.groupButton.isSelected()) {
            this.populateGroupList();
        }
    }

    private void layoutComponents() {
        JPanel granteePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.weightx = 0.0;
        granteePanel.add((Component)this.createRadioPanel(), gbc);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 0, 0, 2);
        gbc.weightx = 1.0;
        granteePanel.add((Component)this.userGroupComboBox, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 11);
        gbc.weightx = 0.0;
        granteePanel.add((Component)this.addButton, gbc);
        this.setLayout(new BorderLayout());
        this.add(granteePanel);
    }

    private JPanel createRadioPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel("           "), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        JLabel userIcon = new JLabel(WcmImageLoader.createImageIcon("type/Users16.gif"));
        p.add((Component)userIcon, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.userButton, new GridBagConstraints(2, 0, 1, 1, 0.25, 1.0, 13, 0, new Insets(0, 2, 0, 0), 0, 0));
        JLabel groupIcon = new JLabel(WcmImageLoader.createImageIcon("type/Groups16.gif"));
        p.add((Component)groupIcon, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        p.add((Component)this.groupButton, new GridBagConstraints(4, 0, 1, 1, 0.25, 1.0, 13, 0, new Insets(0, 2, 0, 0), 0, 0));
        return p;
    }

    private void setListeners() {
        this.userButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSecurityAddPanel.this.addButton.setEnabled(false);
                WcmSecurityAddPanel.this.populateUserList();
                if (WcmSecurityAddPanel.this.userList != null) {
                    if (!WcmSecurityAddPanel.this.userGroupComboBox.isEnabled()) {
                        WcmSecurityAddPanel.this.userGroupComboBox.setEnabled(true);
                    }
                    WcmSecurityAddPanel.this.userGroupComboBox.grabFocus();
                }
            }
        });
        this.groupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WcmSecurityAddPanel.this.addButton.setEnabled(false);
                WcmSecurityAddPanel.this.populateGroupList();
                if (WcmSecurityAddPanel.this.groupList != null) {
                    if (!WcmSecurityAddPanel.this.userGroupComboBox.isEnabled()) {
                        WcmSecurityAddPanel.this.userGroupComboBox.setEnabled(true);
                    }
                    WcmSecurityAddPanel.this.userGroupComboBox.grabFocus();
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SecurityMap secMap = WcmSecurityAddPanel.this.getDefaultSecurityMap();
                if (secMap == null) {
                    JOptionPane.showMessageDialog(WcmSecurityAddPanel.this.parent, WcmSecurityResource.nullusergrp, "InformationMessage", 1);
                } else {
                    try {
                        if (WcmSecurityAddPanel.this.parent instanceof Dialog) {
                            WcmSecurityAddPanel.this.addDialog = new WcmDetailSecDialog((Dialog)WcmSecurityAddPanel.this.parent, WcmSecurityAddPanel.this.isReadOnly, true, secMap, WcmSecurityAddPanel.this.secModel);
                        } else if (WcmSecurityAddPanel.this.parent instanceof Frame) {
                            WcmSecurityAddPanel.this.addDialog = new WcmDetailSecDialog((Frame)WcmSecurityAddPanel.this.parent, WcmSecurityAddPanel.this.isReadOnly, true, secMap, WcmSecurityAddPanel.this.secModel);
                        } else {
                            WcmSecurityAddPanel.this.addDialog = new WcmDetailSecDialog((Frame)null, WcmSecurityAddPanel.this.isReadOnly, true, secMap, WcmSecurityAddPanel.this.secModel);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    WcmSecurityAddPanel.this.addDialog.setVisible(true);
                    if (WcmSecurityAddPanel.this.addDialog.getStatus() == 0) {
                        WcmSecurityAddPanel.this.secModel.addRow(secMap);
                        WcmSecurityAddPanel.this.secModel.fireTableDataChanged();
                        WcmSecurityAddPanel.this.addButton.setEnabled(false);
                    }
                }
                if (WcmSecurityAddPanel.this.parent != null) {
                    WcmSecurityAddPanel.this.parent.requestFocus();
                }
            }
        });
        Component[] cbComponents = this.userGroupComboBox.getComponents();
        FocusAdapter fl = new FocusAdapter(){

            public void focusGained(FocusEvent fevent) {
                if (WcmSecurityAddPanel.this.groupList == null && WcmSecurityAddPanel.this.groupButton.isSelected()) {
                    WcmSecurityAddPanel.this.populateGroupList();
                }
            }
        };
        for (int i = cbComponents.length - 1; i >= 0; --i) {
            if (!(cbComponents[i] instanceof JButton)) continue;
            cbComponents[i].addFocusListener(fl);
            break;
        }
        this.userGroupComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.userGroupComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object selItem;
                JComboBox cb = (JComboBox)e.getSource();
                if (cb.getSelectedIndex() > 0 && (selItem = cb.getSelectedItem()) != null) {
                    boolean canEnab = WcmSecurityAddPanel.this.canEnableAddButton();
                    if (canEnab) {
                        WcmSecurityAddPanel.this.addButton.setEnabled(true);
                    } else {
                        WcmSecurityAddPanel.this.addButton.setEnabled(false);
                        cb.hidePopup();
                        JOptionPane.showMessageDialog(WcmSecurityAddPanel.this.parent, WcmSecurityResource.existingusergrp, "InformationMessage", 1);
                    }
                }
            }
        });
    }

    private boolean getObjStoreGroups() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Toolkit.getDefaultToolkit().sync();
        this.addButton.setEnabled(false);
        Groups groups = null;
        if (this.session != null) {
            try {
                groups = SecUserRealm.getRealmGroups(this.session);
            }
            catch (Exception ex) {
                System.out.println("WcmSecurityAddPanel:getObjStoreGroups:Exception : " + ex.getMessage());
            }
        }
        if (groups == null || groups.size() <= 0) {
            return false;
        }
        PropertyUtil.sortByDispName(groups);
        this.groupList = new DefaultComboBoxModel();
        this.groupList.addElement(" ");
        this.groupList.addElement("#AUTHENTICATED-USERS");
        for (int i = 0; i < groups.size(); ++i) {
            Group grp = (Group)groups.get(i);
            this.groupList.addElement(grp);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private boolean getObjStoreUsers() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Toolkit.getDefaultToolkit().sync();
        this.addButton.setEnabled(false);
        Users users = null;
        if (this.session != null) {
            try {
                users = SecUserRealm.getRealmUsers(this.session);
            }
            catch (Exception ex) {
                System.out.println("WcmSecurityAddPanel:getObjStoreUsers:Exception : " + ex.getMessage());
            }
        }
        if (users == null || users.size() <= 0) {
            return false;
        }
        PropertyUtil.sortByDispName(users);
        this.userList = new DefaultComboBoxModel();
        this.userList.addElement(" ");
        if (!this.filterCreatorOwner) {
            this.userList.addElement("#CREATOR-OWNER");
        }
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (user == null) continue;
            this.userList.addElement(user);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private SecurityMap getDefaultSecurityMap() {
        if (this.userGroupComboBox.getSelectedIndex() > 0) {
            String dispname = null;
            String name = null;
            String distinguishedName = null;
            Object selObj = this.userGroupComboBox.getSelectedItem();
            if (selObj instanceof String) {
                dispname = name = (String)selObj;
                distinguishedName = name;
            } else if (selObj instanceof User) {
                User user = (User)selObj;
                name = user.getName();
                try {
                    dispname = user.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispname = name;
                }
                try {
                    distinguishedName = user.getPropertyStringValue("DistinguishedName");
                }
                catch (PropertyNotFoundException pnfe) {
                    distinguishedName = name;
                }
            } else if (selObj instanceof Group) {
                Group grp = (Group)selObj;
                name = grp.getName();
                try {
                    dispname = grp.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispname = name;
                }
                try {
                    distinguishedName = grp.getPropertyStringValue("DistinguishedName");
                }
                catch (PropertyNotFoundException pnfe) {
                    distinguishedName = name;
                }
            }
            if (name != null && this.secModel.getRowData(name) == null) {
                int userType = this.userButton.isSelected() ? 2000 : 2001;
                return this.secModel.getDefaultSecMap(name, dispname, distinguishedName, userType);
            }
        }
        return null;
    }

    private void populateGroupList() {
        if (this.groupList == null) {
            this.getObjStoreGroups();
        }
        if (this.groupList != null) {
            this.userGroupComboBox.setModel(this.groupList);
        }
    }

    private void populateUserList() {
        if (this.userList == null) {
            this.getObjStoreUsers();
        }
        if (this.userList != null) {
            this.userGroupComboBox.setModel(this.userList);
        }
    }
}

