/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.Groups;
import com.filenet.wcm.api.Realm;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.Users;
import com.filenet.wcm.apps.client.util.api.VerboseRealm;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.SecUserRealm;
import com.filenet.wcm.toolkit.client.ui.security.VRealmComboToolTipRenderer;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class WcmItemFilterPanel
extends JPanel
implements ActionListener,
DocumentListener,
KeyListener {
    public static final int DEFAULT_BUFFER_SIZE = 500;
    public static final String ACMD_NEW_SEARCH = "NewSearch";
    private EventListenerList m_listenerList = null;
    private int m_bufferSize = -1;
    private JComboBox m_realmCombo = null;
    private JTextField m_realmTextField = null;
    private VerboseRealm m_defUserVerRealm = null;
    private JTextField m_filterTextField = null;
    private JButton m_searchButton = null;
    private WcmSitePrefs m_sitePref = null;
    private Session m_session = null;
    private boolean m_isResultSetMoreThanLimit = false;
    private boolean m_showCreatorOwner = false;

    public WcmItemFilterPanel() {
        this(null, null);
    }

    public WcmItemFilterPanel(WcmSitePrefs sitePref, Session session) {
        this.m_sitePref = sitePref;
        this.m_session = session;
        this.m_listenerList = new EventListenerList();
        this.init();
    }

    public void SetSitePrefs(WcmSitePrefs sitePref) {
        this.m_sitePref = sitePref;
    }

    public void SetSession(Session session) {
        this.m_session = session;
    }

    public boolean isMoreThanLimit() {
        return this.m_isResultSetMoreThanLimit;
    }

    public void setShowCreatorOwner(boolean showFlag) {
        this.m_showCreatorOwner = showFlag;
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public WcmUserGroupItem[] getUserItems(Session session) throws Exception {
        if (session == null) {
            return null;
        }
        String strInput = this.m_filterTextField.getText();
        String strText = this.RemoveLeadingSpace(strInput);
        if (strText.length() == 0) {
            return null;
        }
        String strCreatorOwner = "#CREATOR-OWNER";
        String strUppText = strText.toUpperCase();
        boolean bSearchCreatorOwner = strCreatorOwner.startsWith(strUppText);
        boolean bCreatorOwnerFound = false;
        int nPrefSize = this.getBufferSize();
        Users users = SecUserRealm.findUsers(this.getCurrentRealm(), strText, 2, nPrefSize + 1);
        int nSize = users.size();
        if (nSize == nPrefSize + 1) {
            --nSize;
            this.m_isResultSetMoreThanLimit = true;
        } else {
            this.m_isResultSetMoreThanLimit = false;
        }
        WcmUserGroupItem[] userGrps = new WcmUserGroupItem[nSize];
        for (int idx = 0; idx < nSize; ++idx) {
            User user = (User)users.get(idx);
            if (user == null) continue;
            String userName = user.getName();
            if (bSearchCreatorOwner && userName.compareToIgnoreCase("#CREATOR-OWNER") == 0) {
                bCreatorOwnerFound = true;
            }
            userGrps[idx] = new WcmUserGroupItem(user);
        }
        if (bSearchCreatorOwner && !bCreatorOwnerFound && this.m_showCreatorOwner) {
            WcmUserGroupItem[] userGrpsIncludeCreatorOwner = new WcmUserGroupItem[nSize + 1];
            if (nSize > 0) {
                System.arraycopy(userGrps, 0, userGrpsIncludeCreatorOwner, 0, nSize);
            }
            userGrpsIncludeCreatorOwner[nSize] = new WcmUserGroupItem("#CREATOR-OWNER", "#CREATOR-OWNER", "#CREATOR-OWNER", "S-1-3-0", 1);
            userGrps = null;
            return userGrpsIncludeCreatorOwner;
        }
        return userGrps;
    }

    public WcmUserGroupItem[] getGroupItems(Session session) throws Exception {
        if (session == null) {
            return null;
        }
        String strInput = this.m_filterTextField.getText();
        String strText = this.RemoveLeadingSpace(strInput);
        if (strText.length() == 0) {
            return null;
        }
        String strAuthUsers = "#AUTHENTICATED-USERS";
        String strUppText = strText.toUpperCase();
        boolean bSearchAuthUsers = strAuthUsers.startsWith(strUppText);
        boolean bAuthUsersFound = false;
        int nPrefSize = this.getBufferSize();
        Groups groups = SecUserRealm.findGroups(this.getCurrentRealm(), strText, 2, nPrefSize + 1);
        int nSize = groups.size();
        if (nSize == nPrefSize + 1) {
            --nSize;
            this.m_isResultSetMoreThanLimit = true;
        } else {
            this.m_isResultSetMoreThanLimit = false;
        }
        WcmUserGroupItem[] userGrps = new WcmUserGroupItem[nSize];
        for (int idx = 0; idx < nSize; ++idx) {
            Group group = (Group)groups.get(idx);
            if (group == null) continue;
            String grpname = group.getName();
            if (bSearchAuthUsers && grpname.compareToIgnoreCase("#AUTHENTICATED-USERS") == 0) {
                bAuthUsersFound = true;
            }
            userGrps[idx] = new WcmUserGroupItem(group);
        }
        if (bSearchAuthUsers && !bAuthUsersFound) {
            WcmUserGroupItem[] userGrpsIncludeAuthUsers = new WcmUserGroupItem[nSize + 1];
            if (nSize > 0) {
                System.arraycopy(userGrps, 0, userGrpsIncludeAuthUsers, 0, nSize);
            }
            userGrpsIncludeAuthUsers[nSize] = new WcmUserGroupItem("#AUTHENTICATED-USERS", "#AUTHENTICATED-USERS", "#AUTHENTICATED-USERS", "S-1-5-11", 1);
            userGrps = null;
            return userGrpsIncludeAuthUsers;
        }
        return userGrps;
    }

    public void clear() {
        if (this.m_filterTextField != null) {
            this.m_filterTextField.setText("");
        }
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_realmCombo != null) {
            this.m_realmCombo.setEnabled(bEnable);
        }
        if (this.m_filterTextField != null && this.m_searchButton != null) {
            this.m_filterTextField.setEnabled(bEnable);
            boolean bHasFilterString = this.m_filterTextField.getDocument().getLength() > 0;
            this.m_searchButton.setEnabled(bHasFilterString && bEnable);
        }
    }

    public void removeReferences() {
        this.m_realmCombo = null;
        this.m_realmTextField = null;
        if (this.m_filterTextField != null) {
            this.m_filterTextField.getDocument().removeDocumentListener(this);
            this.m_filterTextField.removeKeyListener(this);
            this.m_filterTextField = null;
        }
        if (this.m_searchButton != null) {
            this.m_searchButton.removeActionListener(this);
            this.m_searchButton = null;
        }
        this.m_listenerList = null;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_searchButton)) {
            this.fireActionEvent(ACMD_NEW_SEARCH);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_filterTextField.getDocument()) {
            this.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_filterTextField.getDocument()) {
            this.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.fireActionEvent(ACMD_NEW_SEARCH);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    private void init() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 18;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 3, 3);
            VerboseRealm[] verRealms = SecUserRealm.getVerboseRealms(this.m_session);
            if (verRealms != null && verRealms.length > 0) {
                this.add((Component)new JLabel(WcmResourceString.s_selectIn), gbCons);
                ++gbCons.gridx;
                gbCons.gridwidth = 0;
                gbCons.fill = 2;
                gbCons.weightx = 1.0;
                if (verRealms.length == 1) {
                    this.m_defUserVerRealm = verRealms[0];
                    this.m_realmTextField = new JTextField(verRealms[0].getDispName());
                    this.m_realmTextField.setCaretPosition(0);
                    this.m_realmTextField.setEditable(false);
                    this.m_realmTextField.setToolTipText(verRealms[0].toString());
                    this.add((Component)this.m_realmTextField, gbCons);
                } else {
                    this.m_realmCombo = new JComboBox<VerboseRealm>(verRealms);
                    this.m_realmCombo.setRenderer(new VRealmComboToolTipRenderer());
                    this.add((Component)this.m_realmCombo, gbCons);
                    VerboseRealm defUserRealm = SecUserRealm.getCurrentUserVerboseRealm(this.m_session);
                    for (int idx = 0; idx < verRealms.length; ++idx) {
                        if (!verRealms[idx].isEqual(defUserRealm)) continue;
                        this.m_defUserVerRealm = verRealms[idx];
                        break;
                    }
                    if (this.m_defUserVerRealm != null) {
                        this.m_realmCombo.setSelectedItem(this.m_defUserVerRealm);
                    }
                }
                ++gbCons.gridy;
            }
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            JLabel label = new JLabel(VWResource.s_startsWith);
            label.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 5));
            this.add((Component)label, gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 1.0;
            gbCons.fill = 2;
            this.m_filterTextField = new JTextField();
            this.m_filterTextField.addKeyListener(this);
            this.m_filterTextField.getDocument().addDocumentListener(this);
            this.add((Component)this.m_filterTextField, gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.fill = 0;
            this.m_searchButton = new JButton(WcmImageLoader.createImageIcon("action/search.gif"));
            this.m_searchButton.addActionListener(this);
            this.m_searchButton.setToolTipText(VWResource.s_search);
            this.m_searchButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_searchButton.setEnabled(false);
            this.add((Component)this.m_searchButton, gbCons);
        }
        catch (Exception ex) {
            System.out.println("Initializing the Filter Panel exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void fireActionEvent(String actionCommand) {
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    private String RemoveLeadingSpace(String strSrc) {
        StringBuffer sb = new StringBuffer(strSrc);
        int i = 0;
        for (i = 0; i < sb.length() && sb.charAt(i) == ' '; ++i) {
        }
        if (i == sb.length()) {
            return "";
        }
        String retStr = sb.substring(i);
        return retStr;
    }

    private Realm getCurrentRealm() {
        VerboseRealm currentVerRealm = null;
        currentVerRealm = this.m_realmCombo == null ? this.m_defUserVerRealm : (VerboseRealm)this.m_realmCombo.getSelectedItem();
        if (currentVerRealm == null) {
            return null;
        }
        return currentVerRealm.getRealm();
    }

    public int getBufferSize() {
        block5: {
            try {
                if (this.m_bufferSize == -1) {
                    if (this.m_sitePref != null) {
                        this.m_bufferSize = this.m_sitePref.getGranteeMaximumFilterSize();
                        if (this.m_bufferSize <= 0) {
                            this.m_bufferSize = 500;
                        }
                        return this.m_bufferSize;
                    }
                    break block5;
                }
                return this.m_bufferSize;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 500;
    }
}

