/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.security.WcmItemFilterPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupListCellRenderer;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WcmFilteredUsersPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ACMD_SELECTION_CHANGED = "SelectionChanged";
    private Session m_Session = null;
    private EventListenerList m_listenerList = null;
    private WcmItemFilterPanel m_itemFilterPanel = null;
    private JList m_resultsList = null;
    private Window m_parent;
    private WcmSitePrefs m_sitePref = null;

    public WcmFilteredUsersPanel(Window parent, Session session, WcmSitePrefs sitePref) {
        this.m_Session = session;
        this.m_parent = parent;
        this.m_sitePref = sitePref;
        this.m_listenerList = new EventListenerList();
        this.init();
    }

    public WcmFilteredUsersPanel(Window parent, Session session) {
        this(parent, session, null);
    }

    public void SetSitePrefs(WcmSitePrefs sitePref) {
        this.m_sitePref = sitePref;
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public String getItemAt(int nIndex) {
        if (this.m_resultsList != null && this.getItemCount() > nIndex) {
            return (String)this.m_resultsList.getModel().getElementAt(nIndex);
        }
        return null;
    }

    public int getItemCount() {
        if (this.m_resultsList != null) {
            return this.m_resultsList.getModel().getSize();
        }
        return -1;
    }

    public int getSelectedIndex() {
        if (this.m_resultsList != null && this.getItemCount() > 0) {
            return this.m_resultsList.getSelectedIndex();
        }
        return -1;
    }

    public void setSelectedIndex(int nIndex) {
        if (this.m_resultsList != null && this.getItemCount() > nIndex) {
            this.m_resultsList.setSelectedIndex(nIndex);
        }
    }

    public Object getSelectedValue() {
        Object value;
        if (this.m_resultsList != null && (value = this.m_resultsList.getSelectedValue()) != null && value instanceof WcmUserGroupItem) {
            return value;
        }
        return null;
    }

    public void setSelectedValue(String recipient) {
        if (this.m_resultsList != null && recipient != null) {
            boolean bFound = false;
            if (this.getItemCount() > 0) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    String name = this.getItemAt(i);
                    if (VWStringUtils.compare((String)name, (String)recipient) != 0) continue;
                    this.setSelectedIndex(i);
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                DefaultListModel listModel = (DefaultListModel)this.m_resultsList.getModel();
                listModel.addElement(recipient);
                this.m_resultsList.setSelectedValue(recipient, true);
            }
        }
    }

    public boolean hasValidSelection() {
        return this.getSelectedIndex() != -1;
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.setEnabled(bEnable);
        }
        if (this.m_resultsList != null) {
            this.m_resultsList.setEnabled(bEnable);
        }
    }

    public void removeReferences() {
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.removeActionListener(this);
            this.m_itemFilterPanel.removeReferences();
            this.m_itemFilterPanel = null;
        }
        if (this.m_resultsList != null) {
            this.m_resultsList.removeListSelectionListener(this);
            this.m_resultsList = null;
        }
        this.m_Session = null;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_itemFilterPanel)) {
                WcmUserGroupItem[] users = this.m_itemFilterPanel.getUserItems(this.m_Session);
                if (this.m_itemFilterPanel.isMoreThanLimit()) {
                    int nblockSz = this.m_itemFilterPanel.getBufferSize();
                    JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.moreUsersFound.toString(new Integer(nblockSz)), WcmSecurityResource.selUsersDlgMsgTitle, 1);
                } else if (users == null || users.length == 0) {
                    JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.noUsersFound, WcmSecurityResource.selUsersDlgMsgTitle, 1);
                }
                this.updateUsers(users);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_resultsList)) {
            this.fireActionEvent(ACMD_SELECTION_CHANGED);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.insets = new Insets(4, 4, 4, 4);
        gbCons.ipadx = 0;
        gbCons.ipady = 0;
        this.m_itemFilterPanel = new WcmItemFilterPanel(this.m_sitePref, this.m_Session);
        this.m_itemFilterPanel.addActionListener(this);
        this.add((Component)this.m_itemFilterPanel, gbCons);
        ++gbCons.gridy;
        gbCons.weighty = 1.0;
        gbCons.fill = 1;
        this.m_resultsList = new JList(new DefaultListModel());
        this.m_resultsList.setSelectionMode(0);
        this.m_resultsList.addListSelectionListener(this);
        this.m_resultsList.setCellRenderer(new WcmUserGroupListCellRenderer());
        this.add((Component)new JScrollPane(this.m_resultsList), gbCons);
    }

    private void updateUsers(WcmUserGroupItem[] users) {
        DefaultListModel<WcmUserGroupItem> listModel = new DefaultListModel<WcmUserGroupItem>();
        try {
            if (users != null && users.length > 0) {
                for (int i = 0; i < users.length; ++i) {
                    listModel.addElement(users[i]);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parent, ex.getLocalizedMessage());
        }
        this.m_resultsList.setModel(listModel);
    }

    private void fireActionEvent(String actionCommand) {
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

