/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.security.WcmItemFilterPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupListCellRenderer;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

public class WcmFilteredUsersAndGroupsPanel
extends VWAddRemovePanel
implements ActionListener {
    protected JRadioButton m_groupsRadioButton;
    protected JRadioButton m_usersRadioButton;
    protected Session m_session;
    protected int m_nType = 0;
    protected WcmItemFilterPanel m_itemFilterPanel;
    protected WcmSitePrefs m_sitePref = null;
    protected Window m_parent;

    public WcmFilteredUsersAndGroupsPanel(Window parent, Session session, WcmSitePrefs sitePref) {
        super(10);
        this.enableSorting(1536);
        this.setItemName(VWResource.s_users);
        this.m_parent = parent;
        this.m_session = session;
        this.m_sitePref = sitePref;
        this.LayoutComponents();
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.SetSitePrefs(this.m_sitePref);
        }
        this.setListCellRenderer(new WcmUserGroupListCellRenderer());
        this.initializeLists(null, null);
    }

    public WcmFilteredUsersAndGroupsPanel(Window parent, Session session) {
        this(parent, session, null);
    }

    public void SetSitePrefs(WcmSitePrefs sitePref) {
        this.m_sitePref = sitePref;
    }

    public void removeReferences() {
        if (this.m_groupsRadioButton != null) {
            this.m_groupsRadioButton.removeActionListener(this);
            this.m_groupsRadioButton = null;
        }
        if (this.m_usersRadioButton != null) {
            this.m_usersRadioButton.removeActionListener(this);
            this.m_usersRadioButton = null;
        }
        this.m_session = null;
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.removeActionListener(this);
            this.m_itemFilterPanel = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_groupsRadioButton)) {
                if (this.m_nType != 1 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 1;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_usersRadioButton)) {
                if (this.m_nType != 0 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 0;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_itemFilterPanel)) {
                if (this.m_nType == 0) {
                    WcmUserGroupItem[] items = this.m_itemFilterPanel.getUserItems(this.m_session);
                    if (this.m_itemFilterPanel.isMoreThanLimit()) {
                        int nblockSz = this.m_itemFilterPanel.getBufferSize();
                        JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.moreUsersFound.toString(new Integer(nblockSz)), WcmSecurityResource.addUsersGroupsDlgMsgTitle, 1);
                    } else if (items == null || items.length == 0) {
                        JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.noUsersFound, WcmSecurityResource.addUsersGroupsDlgMsgTitle, 1);
                    }
                    this.updateAvailableList(items);
                } else if (this.m_nType == 1) {
                    WcmUserGroupItem[] items = this.m_itemFilterPanel.getGroupItems(this.m_session);
                    if (this.m_itemFilterPanel.isMoreThanLimit()) {
                        int nblockSz = this.m_itemFilterPanel.getBufferSize();
                        JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.moreGroupsFound.toString(new Integer(nblockSz)), WcmSecurityResource.addUsersGroupsDlgMsgTitle, 1);
                    } else if (items == null || items.length == 0) {
                        JOptionPane.showMessageDialog(this.m_parent, WcmSecurityResource.noGroupsFound, WcmSecurityResource.addUsersGroupsDlgMsgTitle, 1);
                    }
                    this.updateAvailableList(items);
                }
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void addControls() {
    }

    private void LayoutComponents() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 3;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            this.add(this.getHeaderPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.5;
            this.add(this.m_availableLabel, gbCons);
            ++gbCons.gridy;
            this.m_itemFilterPanel = new WcmItemFilterPanel(null, this.m_session);
            this.m_itemFilterPanel.addActionListener(this);
            this.m_itemFilterPanel.requestFocus();
            this.add(this.m_itemFilterPanel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener((ListSelectionListener)((Object)this));
            this.m_availableList.addMouseListener((MouseListener)new VWMouseAdapter((IVWMouseActionListener)this));
            this.add(new JScrollPane(this.m_availableList), gbCons);
            gbCons.anchor = 10;
            gbCons.gridx = 2;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            this.add(this.createAddRemoveButtonPanel(), gbCons);
            gbCons.gridx = 3;
            gbCons.gridy = 1;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            this.add(this.m_selectedLabel, gbCons);
            ++gbCons.gridy;
            gbCons.gridheight = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener((ListSelectionListener)((Object)this));
            this.m_selectedList.addMouseListener((MouseListener)new VWMouseAdapter((IVWMouseActionListener)this));
            this.add(new JScrollPane(this.m_selectedList), gbCons);
        }
        catch (Exception ex) {
            System.out.println("Error occurred in WcmFilteredUsersAndGroupsPanel::addControls(): " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected JPanel getHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 3, 0, 2);
        headerPanel.add((Component)new JLabel(VWResource.s_showAvailableColon), gbCons);
        ++gbCons.gridx;
        gbCons.insets = new Insets(0, 3, 0, 0);
        this.m_usersRadioButton = new JRadioButton(VWResource.s_Users);
        this.m_usersRadioButton.setSelected(true);
        this.m_usersRadioButton.addActionListener(this);
        ButtonGroup filterGroup = new ButtonGroup();
        filterGroup.add(this.m_usersRadioButton);
        headerPanel.add((Component)this.m_usersRadioButton, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        this.m_groupsRadioButton = new JRadioButton(VWResource.s_Groups);
        this.m_groupsRadioButton.addActionListener(this);
        filterGroup.add(this.m_groupsRadioButton);
        headerPanel.add((Component)this.m_groupsRadioButton, gbCons);
        return headerPanel;
    }

    public WcmUserGroupItem[] getSelectUserGroupItems() {
        try {
            Object[] selItems = this.getSelectedItems();
            if (selItems != null && selItems.length > 0) {
                WcmUserGroupItem[] items = new WcmUserGroupItem[selItems.length];
                for (int nIndex = 0; nIndex < selItems.length; ++nIndex) {
                    WcmUserGroupItem item;
                    WcmUserGroupItem selItem = (WcmUserGroupItem)selItems[nIndex];
                    items[nIndex] = item = (WcmUserGroupItem)selItem.clone();
                }
                return items;
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred in WcmFilteredUsersAndGroupsPanel::getSelectUserGroupItems(): " + ex.getMessage());
            ex.printStackTrace();
        }
        return null;
    }

    protected void updateAvailableList(WcmUserGroupItem[] userGroupItems) {
        try {
            this.initializeLists(userGroupItems, this.getSelectedItems());
        }
        catch (Exception ex) {
            System.out.println("Error occurred in WcmFilteredUsersAndGroupsPanel::updateAvailableList(): " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            Vector<Object> returnSet = new Vector<Object>();
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof WcmUserGroupItem)) continue;
                returnSet.add(items[i]);
            }
            return returnSet.toArray();
        }
        catch (Exception ex) {
            System.out.println("Error occurred in WcmFilteredUsersAndGroupsPanel::onRemoveItemsAction(): " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }
}

