/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.WcmDetailSecModel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class WcmDetailSecPanel
extends JPanel
implements MouseListener {
    private WcmTable table;
    private WcmDetailSecModel tblModel;
    private JLabel granteeLabel;
    private SecurityMap secMap;
    private Object[][] multiLineHeader;

    public WcmDetailSecPanel(SecurityMap secMap, WcmSummarySecModel secModel) throws Exception {
        this.secMap = secMap;
        this.granteeLabel = new JLabel();
        this.granteeLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.tblModel = new WcmDetailSecModel(secMap, secModel);
        this.table = new WcmTable(this.tblModel);
        this.table.addMouseListener(this);
        this.table.addKeyListener(new TabKeyListener());
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.initColumnAttributes();
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        JScrollPane sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.granteeLabel, "First");
        this.add((Component)sp, "Center");
    }

    private void initColumnWidth() {
        if (this.table != null) {
            int count = this.tblModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn tblColumn = this.table.getColumnModel().getColumn(i);
                if (tblColumn == null) continue;
                tblColumn.setPreferredWidth(WcmDetailSecModel.colAttributes[i].colWidth);
            }
        }
    }

    private void initColumnAttributes() {
        if (this.table != null) {
            this.initMultiLineHeader();
            this.table.getTableHeader().setReorderingAllowed(false);
            int count = this.tblModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn tblColumn = this.table.getColumnModel().getColumn(i);
                if (tblColumn == null) continue;
                tblColumn.setHeaderRenderer(new WcmSummarySecPanel.HeaderRenderer());
                tblColumn.setHeaderValue(this.multiLineHeader[i]);
                tblColumn.setMinWidth(WcmDetailSecModel.colAttributes[i].colWidth);
                tblColumn.setPreferredWidth(WcmDetailSecModel.colAttributes[i].colWidth);
                tblColumn.setWidth(WcmDetailSecModel.colAttributes[i].colWidth);
                String name = WcmDetailSecModel.colAttributes[i].colName;
                if (name == WcmSecurityResource.COLNAME_SYSTEMALLOW || name == WcmSecurityResource.COLNAME_SYSTEMDENY) {
                    tblColumn.setCellRenderer(new WcmSummarySecPanel.CheckRenderer());
                    continue;
                }
                if (name == WcmSecurityResource.COLNAME_ALLOW || name == WcmSecurityResource.COLNAME_DENY) continue;
                tblColumn.setCellRenderer(new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setComponentOrientation(table.getComponentOrientation());
                        return this;
                    }
                });
            }
        }
    }

    private void initMultiLineHeader() {
        if (this.table != null) {
            int count = this.tblModel.getColumnCount();
            int maxLine = 5;
            if (this.multiLineHeader == null) {
                this.multiLineHeader = new Object[count][maxLine];
            }
            for (int i = 0; i < count; ++i) {
                String colName = this.tblModel.getColumnName(i);
                StringTokenizer st = new StringTokenizer(colName);
                for (int j = 0; j < maxLine && st.hasMoreTokens(); ++j) {
                    this.multiLineHeader[i][j] = st.nextToken();
                }
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        this.table.updateUI();
        this.table.removeMouseListener(this);
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public boolean hasNewDenies() {
        return this.tblModel.hasNewDenies();
    }

    private void moveToNewColumn(boolean forward) {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (forward) {
            if (row == -1) {
                row = 0;
                column = 1;
            } else {
                ++column;
            }
            if (column >= this.table.getColumnCount() - 1) {
                column = 1;
                if (++row >= this.table.getRowCount()) {
                    row = 0;
                }
            }
        } else {
            if (row == -1) {
                row = 0;
                column = 1;
            } else {
                --column;
            }
            if (column <= 0) {
                column = this.table.getColumnCount() - 2;
                if (--row < 0) {
                    row = this.table.getRowCount() - 1;
                }
            }
        }
        ListSelectionModel rowSelection = this.table.getSelectionModel();
        ListSelectionModel colSelection = this.table.getColumnModel().getSelectionModel();
        rowSelection.setSelectionInterval(row, row);
        colSelection.setSelectionInterval(column, column);
    }

    private void moveToNewRow(boolean forward) {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (forward) {
            if (row == -1) {
                row = 0;
                column = 1;
            } else {
                ++row;
            }
            if (row >= this.table.getRowCount()) {
                row = 0;
                if (++column >= this.table.getColumnCount() - 1) {
                    column = 1;
                }
            }
        } else {
            if (row == -1) {
                row = 0;
                column = 1;
            } else {
                --row;
            }
            if (row <= -1) {
                row = this.table.getRowCount() - 1;
                if (--column < 1) {
                    column = this.table.getColumnCount() - 2;
                }
            }
        }
        ListSelectionModel rowSelection = this.table.getSelectionModel();
        ListSelectionModel colSelection = this.table.getColumnModel().getSelectionModel();
        rowSelection.setSelectionInterval(row, row);
        colSelection.setSelectionInterval(column, column);
    }

    private class TabKeyListener
    extends KeyAdapter {
        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            block6: {
                block11: {
                    int keyCode;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        block4: {
                                            keyCode = evt.getKeyCode();
                                            if (keyCode == 9 && evt.isShiftDown()) break block4;
                                            if (keyCode != 37) break block5;
                                        }
                                        WcmDetailSecPanel.this.moveToNewColumn(false);
                                        evt.consume();
                                        break block6;
                                    }
                                    if (keyCode == 9) break block7;
                                    if (keyCode != 39) break block8;
                                }
                                WcmDetailSecPanel.this.moveToNewColumn(true);
                                evt.consume();
                                break block6;
                            }
                            if (keyCode != 10 || !evt.isShiftDown()) break block9;
                            WcmDetailSecPanel.this.moveToNewRow(false);
                            evt.consume();
                            break block6;
                        }
                        if (keyCode != 10) break block10;
                        WcmDetailSecPanel.this.moveToNewRow(true);
                        evt.consume();
                        break block6;
                    }
                    if (keyCode == 38) break block11;
                    if (keyCode != 40) break block6;
                }
                if (WcmDetailSecPanel.this.table.getSelectedRow() <= -1) {
                    evt.consume();
                }
            }
        }
    }
}

