/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.toolkit.client.ui.security.AccessRight;
import com.filenet.wcm.toolkit.client.ui.security.ColumnAttribute;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.util.WcmException;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class WcmDetailSecModel
extends AbstractTableModel {
    public static final int COL_PERMISSION = 0;
    public static final int COL_ALLOW = 1;
    public static final int COL_SYSTEMALLOW = 2;
    public static final int COL_DENY = 3;
    public static final int COL_SYSTEMDENY = 4;
    public static final int COL_SYSTEMNOTES = 5;
    public static ColumnAttribute[] colAttributes;
    private String[] rowKey;
    private static String[] keys;
    private SecurityMap secMap;
    private SecurityMap origSecMap;
    private WcmSummarySecModel secModel;
    private boolean isReadOnly;

    public WcmDetailSecModel(SecurityMap secMap, WcmSummarySecModel secModel) throws Exception {
        if (secMap == null || secModel == null) {
            throw new WcmException("client.WcmDetailSecModel.IllegalArgumentException", "Invalid input parameters");
        }
        this.secMap = secMap;
        this.origSecMap = (SecurityMap)secMap.clone();
        this.secModel = secModel;
        this.initColumnAttributes();
        this.initRowKey();
    }

    public void setEditable(boolean editable) {
        this.isReadOnly = editable;
    }

    public int getRowCount() {
        return this.secMap == null ? 0 : this.secMap.accessRights.size();
    }

    public int getColumnCount() {
        return colAttributes == null ? 0 : colAttributes.length;
    }

    public String getColumnName(int col) {
        return colAttributes == null ? "" : WcmDetailSecModel.colAttributes[col].colName;
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        if (this.isReadOnly) {
            return false;
        }
        if (this.getColumnName(col) == WcmSecurityResource.COLNAME_SYSTEMALLOW || this.getColumnName(col) == WcmSecurityResource.COLNAME_SYSTEMDENY) {
            return false;
        }
        AccessRight access = (AccessRight)this.secMap.accessRights.get(this.rowKey[row]);
        return access != null && (col == 1 || col == 3);
    }

    public void setValueAt(Object value, int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return;
        }
        String key = this.rowKey[row];
        AccessRight access = (AccessRight)this.secMap.accessRights.get(key);
        if (access != null && value != null) {
            boolean check = (Boolean)value;
            switch (column) {
                case 1: {
                    this.secModel.recomputeSecMap(key, check, 1, this.secMap);
                    break;
                }
                case 3: {
                    this.secModel.recomputeSecMap(key, check, 2, this.secMap);
                }
            }
            this.fireTableDataChanged();
        }
    }

    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        String key = this.rowKey[row];
        AccessRight access = (AccessRight)this.secMap.accessRights.get(key);
        if (access != null) {
            switch (column) {
                case 0: {
                    return access.accessName;
                }
                case 1: {
                    return access.secAccess.isExplicitAllowSet() ? new Boolean(true) : new Boolean(false);
                }
                case 2: {
                    return access.secAccess.isSystemAllowSet() ? new Boolean(true) : new Boolean(false);
                }
                case 3: {
                    return access.secAccess.isExplicitDenySet() ? new Boolean(true) : new Boolean(false);
                }
                case 4: {
                    return access.secAccess.isSystemDenySet() ? new Boolean(true) : new Boolean(false);
                }
                case 5: {
                    return access.secAccess.systemNote;
                }
            }
        }
        return null;
    }

    public boolean hasNewDenies() {
        int rows = this.getRowCount();
        for (int row = 0; row < rows; ++row) {
            String key = this.rowKey[row];
            AccessRight newAccess = (AccessRight)this.secMap.accessRights.get(key);
            AccessRight oldAccess = (AccessRight)this.origSecMap.accessRights.get(key);
            if (newAccess.secAccess.explicitRight != 2 || oldAccess.secAccess.explicitRight == 2) continue;
            return true;
        }
        return false;
    }

    private void initColumnAttributes() {
        String[] colNames = new String[]{WcmSecurityResource.COLNAME_ACCESS, WcmSecurityResource.COLNAME_ALLOW, WcmSecurityResource.COLNAME_SYSTEMALLOW, WcmSecurityResource.COLNAME_DENY, WcmSecurityResource.COLNAME_SYSTEMDENY, WcmSecurityResource.COLNAME_SYSTEMNOTES};
        int[] colWidth = new int[]{100, 40, 50, 40, 50, 200};
        if (colAttributes == null) {
            colAttributes = new ColumnAttribute[colNames.length];
        }
        for (int i = 0; i < colNames.length; ++i) {
            WcmDetailSecModel.colAttributes[i] = new ColumnAttribute(colNames[i], colWidth[i], 2);
        }
    }

    private void initRowKey() throws Exception {
        HashMap accessRights = this.secMap.accessRights;
        if (accessRights != null && accessRights.size() > 0) {
            AccessRight right;
            int size = accessRights.size() - 1;
            if (this.rowKey == null) {
                this.rowKey = new String[size + 1];
            }
            if ((right = (AccessRight)accessRights.get("Publish")) != null) {
                this.rowKey[size] = "Publish";
                --size;
            }
            for (int i = 0; i < keys.length; ++i) {
                right = (AccessRight)accessRights.get(keys[i]);
                if (right == null) continue;
                this.rowKey[size] = keys[i];
                --size;
            }
        } else {
            throw new WcmException("client.WcmDetailSecModel.initRowKey", "Failed to initialized lookup key");
        }
    }

    static {
        keys = new String[]{"View Properties", "View Content", "Add to Folder", "Modify Properties", "Modify Content", "Promote Version", "Full Control"};
    }
}

