/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.WcmDetailSecPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class WcmDetailSecDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    static int status = 1;
    JFrame frame;
    boolean isReadOnly;
    SecurityMap secMap;
    WcmSummarySecModel secModel;
    WcmDetailSecPanel secPanel;

    public WcmDetailSecDialog(Frame parent, boolean isReadOnly, boolean isNew, SecurityMap secMap, WcmSummarySecModel secModel) throws Exception {
        super(parent, true);
        this.init(parent, isReadOnly, isNew, secMap, secModel);
    }

    public WcmDetailSecDialog(Dialog parent, boolean isReadOnly, boolean isNew, SecurityMap secMap, WcmSummarySecModel secModel) throws Exception {
        super(parent, true);
        this.init(parent, isReadOnly, isNew, secMap, secModel);
    }

    public void init(Window parent, boolean isReadOnly, boolean isNew, SecurityMap secMap, WcmSummarySecModel secModel) throws Exception {
        this.isReadOnly = isReadOnly;
        this.secMap = secMap;
        this.secModel = secModel;
        Dimension dim = WcmStringUtil.stringToDimension(WcmSecurityResource.detailSecDialogDim);
        if (dim == null) {
            dim = new Dimension(500, 320);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        if (isNew) {
            this.setTitle(WcmSecurityResource.addUserDiagTitle);
        } else {
            this.setTitle(WcmSecurityResource.updateUserDiagTitle);
        }
        this.createAndLayoutControls(isNew);
        this.setListeners();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmDetailSecDialog.this.setVisible(false);
            }
        });
        this.applyComponentOrientation(parent.getComponentOrientation());
    }

    public int getStatus() {
        return status;
    }

    private void createAndLayoutControls(boolean isNew) throws Exception {
        String titleStr = null;
        titleStr = isNew ? (this.secMap.granteeInfo.type == 2000 ? WcmSecurityResource.addUserTitle : WcmSecurityResource.addGroupTitle) : (this.secMap.granteeInfo.type == 2000 ? WcmSecurityResource.updateUserTitle : WcmSecurityResource.updateGroupTitle);
        titleStr = titleStr + this.secMap.granteeUI.name;
        String DistinguishNameStr = WcmSecurityResource.DISTINGUISHED_NAME + this.secMap.granteeInfo.name;
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        labelPanel.add(new JLabel(titleStr));
        labelPanel.add(new JLabel(DistinguishNameStr));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(20, 1, 4, 1));
        JPanel permsPanel = this.createMiddlePanel();
        JPanel buttonPanel = this.createButtonPanel();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)labelPanel, "First");
        cp.add((Component)buttonPanel, "Last");
        cp.add((Component)permsPanel, "Center");
    }

    private JPanel createMiddlePanel() throws Exception {
        JPanel detailPanel = new JPanel(new GridBagLayout());
        this.secPanel = new WcmDetailSecPanel(this.secMap, this.secModel);
        detailPanel.add((Component)this.secPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int objType = this.secModel.getObjectType();
        if (objType == 1 || objType == -100 || objType == -101) {
            JComponent instrText = WcmDetailSecDialog.createInstructionsText(WcmSecurityResource.majorInstr);
            instrText.setBackground(this.getBackground());
            detailPanel.add((Component)instrText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 20, 2, new Insets(0, 0, 12, 0), 0, 0));
        }
        return detailPanel;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.okButton = new JButton(WcmResourceString.s_ok);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.okMonic));
        p.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.cancelButton = new JButton(WcmResourceString.s_cancel);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmSecurityResource.cancelMonic));
        p.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        return p;
    }

    private void setListeners() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                status = 1;
                WcmDetailSecDialog.this.setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.okButton) {
            if (this.secPanel.hasNewDenies()) {
                int ret = JOptionPane.showConfirmDialog(this, WcmSecurityResource.DENYPERMWARNING, "Warning Message", 2);
                if (ret == 0) {
                    status = 0;
                    this.setVisible(false);
                }
            } else {
                status = 0;
                this.setVisible(false);
            }
        }
    }

    private static JComponent createInstructionsText(String text) {
        String fontName = WcmResourceString.s_secDlgInstFont;
        Integer fontSize = null;
        JTextPane introBody = new JTextPane();
        try {
            fontSize = new Integer(WcmResourceString.s_secDlgInstFontSize);
        }
        catch (Exception e) {
            fontSize = new Integer(12);
        }
        if (fontName != null && fontName.length() != 0 && fontSize != null) {
            introBody.setFont(new Font(fontName, 0, fontSize));
        } else {
            introBody.setFont(new Font("Arial", 0, 12));
        }
        introBody.setOpaque(true);
        introBody.disable();
        SimpleAttributeSet plainBlackText = new SimpleAttributeSet();
        StyleConstants.setForeground(plainBlackText, Color.black);
        StyleConstants.setBold(plainBlackText, false);
        Document introDoc = introBody.getDocument();
        try {
            introDoc.insertString(introDoc.getLength(), text, plainBlackText);
        }
        catch (Exception ex) {
            System.out.println("createInstructionsText exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        return introBody;
    }
}

