/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.User;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

class ToolTipRenderer
extends DefaultListCellRenderer {
    ToolTipRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        String szDispName = this.getDisplayName(value);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            if (-1 < index) {
                String str;
                if (value instanceof User) {
                    User userObj = (User)value;
                    list.setToolTipText(userObj.getName());
                } else if (value instanceof Group) {
                    Group groupObj = (Group)value;
                    list.setToolTipText(groupObj.getName());
                } else if (value instanceof String && (str = (String)value) != null) {
                    str = str.trim();
                    list.setToolTipText(str);
                }
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        this.setText(value == null ? " " : szDispName);
        return this;
    }

    private String getDisplayName(Object value) {
        String retString = "";
        if (value instanceof String) {
            retString = (String)value;
        } else if (value instanceof User) {
            User user = (User)value;
            try {
                retString = user.getPropertyStringValue("DisplayName");
            }
            catch (PropertyNotFoundException pnfe) {
                retString = " (" + user.getName() + ")";
            }
        } else if (value instanceof Group) {
            Group grp = (Group)value;
            try {
                retString = grp.getPropertyStringValue("DisplayName");
            }
            catch (PropertyNotFoundException pnfe) {
                retString = " (" + grp.getName() + ")";
            }
        }
        return retString;
    }
}

