/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.security.AccessMask;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class SecurityMap
implements Cloneable {
    public GranteeInfo granteeInfo;
    public GranteeUI granteeUI;
    public HashMap accessRights;
    public AccessMask accessMask;
    public int permissionSource;
    public int inheritanceDepth;

    public Object clone() {
        SecurityMap obj = null;
        try {
            obj = (SecurityMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("SecurityMap can't be clone");
        }
        return obj;
    }

    public SecurityMap(String name, String dispname, String distinguishedName, int type, HashMap rights, AccessMask mask) {
        this(name, dispname, distinguishedName, type, rights, mask, 1, 0);
    }

    public SecurityMap(String name, String dispname, int type, HashMap rights, AccessMask mask) {
        this(name, dispname, name, type, rights, mask);
    }

    public SecurityMap(String name, String dispName, String distinguishedName, int type, HashMap rights, AccessMask mask, int permSrc, int inheritDepth) {
        if (rights.size() == 0 && mask == null && (type != 2000 || type != 2001)) {
            throw new IllegalArgumentException();
        }
        this.accessRights = rights;
        this.accessMask = mask;
        this.permissionSource = permSrc;
        this.inheritanceDepth = inheritDepth;
        String displayName = dispName;
        if (!(this.permissionSource != 1 && this.permissionSource != 0 || this.inheritanceDepth != 1 && this.inheritanceDepth != -1)) {
            displayName = displayName + WcmResourceString.s_ForInheritance;
        }
        this.granteeInfo = new GranteeInfo(name, distinguishedName, type);
        if (type == 2000) {
            this.granteeUI = new GranteeUI(displayName, new String("type/Users16.gif"));
        } else if (type == 2001) {
            this.granteeUI = new GranteeUI(displayName, new String("type/Groups16.gif"));
        }
    }

    public SecurityMap(String name, String dispName, int type, HashMap rights, AccessMask mask, int permSrc, int inheritDepth) {
        this(name, dispName, name, type, rights, mask, permSrc, inheritDepth);
    }

    public static class GranteeUI {
        public String name = null;
        private ImageIcon icon = null;
        private String iconRef;

        public GranteeUI(String name, String iconRef) {
            this.name = name;
            this.iconRef = iconRef;
        }

        public ImageIcon getIcon() {
            if (this.icon == null) {
                this.icon = WcmImageLoader.createImageIcon(this.iconRef);
            }
            return this.icon;
        }
    }

    public static class GranteeInfo {
        public String name;
        public String distinguishedName;
        public int type;

        public GranteeInfo(String name, int type) {
            this.name = name;
            this.type = type;
            this.distinguishedName = name;
        }

        public GranteeInfo(String name, String distinguishedname, int type) {
            this.name = name;
            this.type = type;
            this.distinguishedName = distinguishedname != null && distinguishedname.length() > 0 ? distinguishedname : name;
        }
    }
}

