/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.Groups;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Realm;
import com.filenet.wcm.api.Realms;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.Users;
import com.filenet.wcm.apps.client.util.api.VerboseRealm;
import java.util.Iterator;

public class SecUserRealm {
    private static Realms m_realms = null;
    private static Realm m_userRealm = null;
    private static Groups groups;
    private static Users users;
    private static boolean bSupportSingleCharSortedUserSearch;
    private static boolean bSupportSingleCharSortedGroupSearch;

    public static Users getRealmUsers(Session session) {
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        if (m_userRealm != null && session != null) {
            users = m_userRealm.findUsers("", 0, 0, 1, 1000);
            SecUserRealm.freeRealms();
        }
        return users;
    }

    public static Groups getRealmGroups(Session session) {
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        if (m_userRealm != null && session != null) {
            groups = m_userRealm.findGroups("", 0, 0, 1, 1000);
            SecUserRealm.freeRealms();
        }
        return groups;
    }

    private static void getCurrentUserRealm(Session session) {
        EntireNetwork enetwork;
        if (session != null && (enetwork = ObjectFactory.getEntireNetwork((Session)session)) != null) {
            m_userRealm = enetwork.getUserRealm();
        }
    }

    public static Realms getRealms(Session session) {
        EntireNetwork enetwork;
        if (session != null && (enetwork = ObjectFactory.getEntireNetwork((Session)session)) != null) {
            m_realms = enetwork.getRealms();
        }
        return m_realms;
    }

    public static VerboseRealm[] getVerboseRealms(Session session) {
        VerboseRealm[] verRealms = null;
        if (m_realms == null) {
            SecUserRealm.getRealms(session);
        }
        if (m_realms != null) {
            int nSize = m_realms.size();
            verRealms = new VerboseRealm[nSize];
            Iterator it = m_realms.iterator();
            int idx = 0;
            while (it.hasNext()) {
                verRealms[idx] = new VerboseRealm((Realm)it.next());
                ++idx;
            }
        }
        return verRealms;
    }

    public static VerboseRealm getCurrentUserVerboseRealm(Session session) {
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        return new VerboseRealm(m_userRealm);
    }

    private static void freeRealms() {
        if (groups != null && users != null) {
            m_userRealm = null;
        }
    }

    public static Users findUsers(Session session, String filterString, int nFilterType, int nBlockSize) {
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        if (m_userRealm != null) {
            SecUserRealm.findUsers(m_userRealm, filterString, nFilterType, nBlockSize);
        }
        return users;
    }

    public static Users findUsers(Realm theRealm, String filterString, int nFilterType, int nBlockSize) {
        block3: {
            if (theRealm != null) {
                try {
                    users = !bSupportSingleCharSortedUserSearch && filterString.length() == 1 ? theRealm.findUsers(filterString, nFilterType, 2, 0, nBlockSize) : theRealm.findUsers(filterString, nFilterType, 2, 1, nBlockSize);
                }
                catch (Exception e) {
                    users = theRealm.findUsers(filterString, nFilterType, 2, 0, nBlockSize);
                    if (filterString.length() != 1) break block3;
                    bSupportSingleCharSortedUserSearch = false;
                }
            }
        }
        return users;
    }

    public static User findUserByShortName(Session session, String userShortName) {
        Users tempUsers = null;
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        if (m_userRealm != null && session != null) {
            try {
                tempUsers = m_userRealm.findUsers(userShortName, 2, 1, 1, 64);
            }
            catch (Exception e) {
                tempUsers = m_userRealm.findUsers(userShortName, 2, 1, 0, 64);
            }
            if (tempUsers != null) {
                for (int idx = 0; idx < tempUsers.size(); ++idx) {
                    try {
                        User aUser = (User)tempUsers.get(idx);
                        String aShortName = aUser.getPropertyStringValue("ShortName");
                        if (aShortName.compareTo(userShortName) == 0) {
                            return aUser;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static Groups findGroups(Session session, String filterString, int nFilterType, int nBlockSize) {
        if (m_userRealm == null) {
            SecUserRealm.getCurrentUserRealm(session);
        }
        if (m_userRealm != null && session != null) {
            SecUserRealm.findGroups(m_userRealm, filterString, nFilterType, nBlockSize);
        }
        return groups;
    }

    public static Groups findGroups(Realm theRealm, String filterString, int nFilterType, int nBlockSize) {
        block3: {
            if (theRealm != null) {
                try {
                    groups = !bSupportSingleCharSortedGroupSearch && filterString.length() == 1 ? theRealm.findGroups(filterString, nFilterType, 2, 0, nBlockSize) : theRealm.findGroups(filterString, nFilterType, 2, 1, nBlockSize);
                }
                catch (Exception e) {
                    groups = theRealm.findGroups(filterString, nFilterType, 2, 0, nBlockSize);
                    if (filterString.length() != 1) break block3;
                    bSupportSingleCharSortedGroupSearch = false;
                }
            }
        }
        return groups;
    }

    static {
        bSupportSingleCharSortedUserSearch = true;
        bSupportSingleCharSortedGroupSearch = true;
    }
}

