/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgVersionListDialog;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import javax.swing.AbstractListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class WcmDlgVersionListModel
extends AbstractListModel
implements TableModel {
    private static final int NUM_OBJECTSTORE_COLUMNS = 1;
    private WcmDlgItem[] m_itemCache;
    private int m_nItemCount = 0;
    private EventListenerList m_tblListenerList;
    private WcmDlgItemImpl m_dlgItem;
    private int[] m_filterTypes;
    private WcmDlgVersionListDialog m_parent;

    public WcmDlgVersionListModel(WcmDlgVersionListDialog parent, WcmDlgItemImpl dlgItem) {
        this.m_parent = parent;
        this.m_dlgItem = dlgItem;
        this.m_tblListenerList = new EventListenerList();
        try {
            this.rescan();
        }
        catch (WcmException ex) {
            WcmErrorUtil.showErrorMessage(this.m_parent, ex.getMessage(), this.m_parent.getTitle());
        }
    }

    public void getContents(WcmDlgItemImpl item) throws WcmException {
        WcmDlgItem[] itemCache = null;
        try {
            this.invalidateCache();
            if (item == null) {
                return;
            }
            itemCache = item.list(this.m_filterTypes);
            if (itemCache != null) {
                this.m_itemCache = itemCache;
            }
            this.m_nItemCount = this.m_itemCache != null ? this.m_itemCache.length : 0;
        }
        catch (WcmException ex) {
            throw ex;
        }
        finally {
            this.updateUI();
        }
    }

    public void rescan() throws WcmException {
        this.getContents(this.m_dlgItem);
    }

    public void updateUI() {
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        this.fireContentsChanged(this, 0, this.m_nItemCount - 1);
    }

    public int getSize() {
        return this.m_nItemCount;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public int indexOf(Object obj) {
        if (obj == null) {
            for (int i = 0; i < this.m_nItemCount; ++i) {
                if (this.m_itemCache[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.m_nItemCount; ++i) {
                if (!obj.equals(this.m_itemCache[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getElementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.m_nItemCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.m_itemCache != null) {
            return this.m_itemCache[index];
        }
        return null;
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_tblListenerList.add(TableModelListener.class, l);
    }

    public Class getColumnClass(int nColumnIndex) {
        if (this.m_dlgItem == null) {
            return null;
        }
        if (nColumnIndex == 0) {
            return WcmDlgItemImpl.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        if (this.m_dlgItem == null) {
            return 0;
        }
        if (this.m_dlgItem.isRoot()) {
            return 1;
        }
        int colNum = 1;
        try {
            colNum += ((WcmDlgItemImpl)this.m_dlgItem.getObjectStore()).getVersionsNames().length;
        }
        catch (Exception ex) {
            System.out.println("WcmDlgVersionListModel.getColumnCount Exception " + ex.getMessage());
            colNum += 5;
        }
        return colNum;
    }

    public String getColumnName(int nColumnIndex) {
        if (this.m_dlgItem == null) {
            return null;
        }
        if (nColumnIndex == 0) {
            return WcmResourceString.s_name;
        }
        String colName = "Column" + nColumnIndex;
        try {
            colName = ((WcmDlgItemImpl)this.m_dlgItem.getObjectStore()).getVersionsNames()[nColumnIndex - 1];
        }
        catch (Exception ex) {
            System.out.println("WcmDlgVersionListModel.getColumnName Exception " + ex.getMessage());
        }
        return colName;
    }

    public int getRowCount() {
        return this.getSize();
    }

    public Object getValueAt(int nRow, int nCol) {
        if (this.m_itemCache == null || nRow >= this.m_nItemCount) {
            return null;
        }
        WcmDlgItemImpl item = (WcmDlgItemImpl)this.m_itemCache[nRow];
        if (nCol == 0) {
            return item;
        }
        String propVal = item.getVersionsValues()[nCol - 1];
        return propVal;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_tblListenerList.remove(TableModelListener.class, l);
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    private void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_tblListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    private void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    private void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    private void invalidateCache() {
        this.m_itemCache = null;
        this.m_nItemCount = 0;
    }
}

