/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.WcmItemProperty;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgPropertiesDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgVersionContentsPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WcmDlgVersionListDialog
extends JDialog
implements ActionListener {
    protected JLabel m_itemName = new JLabel();
    protected JLabel m_className = new JLabel();
    protected JButton m_closeButton = new JButton(WcmResourceString.s_close);
    protected JButton m_propertiesButton;
    protected WcmDlgVersionContentsPanel m_contentsPane;
    protected int m_retStatus;
    protected WcmDlgItemImpl m_dlgItem;
    protected Document m_dlgDoc;
    protected ClassDescription m_docClassObj;
    protected String m_docClassName;

    public WcmDlgVersionListDialog(Frame parent, Document doc) throws WcmException {
        super(parent, true);
        this.m_dlgDoc = doc;
        this.m_dlgItem = new WcmDlgItemImpl((ReadableMetadataObject)doc, 4);
        this.checkPermissions();
        this.initLayout(parent);
    }

    public WcmDlgVersionListDialog(Dialog parent, Document doc) throws WcmException {
        super(parent, true);
        this.m_dlgDoc = doc;
        this.m_dlgItem = new WcmDlgItemImpl((ReadableMetadataObject)doc, 4);
        this.checkPermissions();
        this.initLayout(parent);
    }

    private void checkPermissions() throws WcmException {
        int asMask = this.m_dlgDoc.getAccessMask();
        if ((asMask & 1) == 0) {
            throw new WcmException("client.WcmDlgVersionListDialog.InsufficientAccessRight", "Insufficient Access Right.");
        }
    }

    private void initLayout(Container parent) throws WcmException {
        try {
            this.setTitle(WcmResourceString.s_versionList);
            Dimension dim = WcmStringUtil.stringToDimension(WcmResourceString.s_propertiesDialogDim);
            if (dim == null) {
                dim = new Dimension(600, 400);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.getToolBarPanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 10, 5, 20), 0, 0));
            this.m_contentsPane = new WcmDlgVersionContentsPanel(this, this.m_dlgItem);
            this.getContentPane().add((Component)this.m_contentsPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 0, 10), 0, 0));
            this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 10, 0, 10), 0, 0));
        }
        catch (Exception ex) {
            System.out.println("WcmDlgVersionListDialog Exception " + ex.getMessage());
            if (this.m_dlgItem == null) {
                System.out.println(" No selected dialog item.");
            }
            throw new WcmException("client.WcmDlgVersionListDialog.FailedInitDialog", "Failed to initialize dialog. Exception {0}.", (Object)ex.getMessage());
        }
    }

    private JPanel getToolBarPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel toolButtonPanel = new JPanel();
        toolButtonPanel.setLayout(new BorderLayout(10, 10));
        this.m_propertiesButton = WcmImageLoader.createIconButton("action/Properties16.gif", WcmResourceString.s_properties);
        this.m_propertiesButton.setEnabled(false);
        this.m_propertiesButton.setAlignmentX(0.0f);
        this.m_propertiesButton.setAlignmentY(0.5f);
        this.m_propertiesButton.addActionListener(this);
        toolButtonPanel.add((Component)this.m_propertiesButton, "Center");
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new GridBagLayout());
        topLeftPanel.add((Component)new JLabel(WcmResourceString.s_nameColon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 0, 5), 0, 0));
        String str = "";
        if (this.m_dlgItem == null) {
            this.m_itemName.setText("No Item Provided");
        } else {
            str = this.m_dlgItem.getLabel();
            this.m_itemName.setText(str);
        }
        this.m_itemName.setForeground(Color.black);
        topLeftPanel.add((Component)this.m_itemName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        topPanel.add((Component)topLeftPanel, "Center");
        topPanel.add((Component)toolButtonPanel, "East");
        return topPanel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.m_closeButton = new JButton(WcmResourceString.s_close);
        this.m_closeButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.cancelMonic));
        this.m_closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_closeButton);
        buttonPanel.add(this.m_closeButton);
        return buttonPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        this.m_retStatus = -1;
        if (obj == this.m_propertiesButton) {
            this.showProperties();
        } else if (obj == this.m_closeButton) {
            try {
                this.m_retStatus = 1;
                this.setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getStatus() {
        return this.m_retStatus;
    }

    protected void setupClassInfo() throws WcmException {
        this.m_docClassObj = this.m_dlgItem.getClassDescription();
        try {
            this.m_docClassName = this.m_docClassObj == null ? "No Class found!" : WcmItemProperty.getClassDescDisplayName(this.m_docClassObj);
        }
        catch (Exception ex) {
            System.out.println("setupClassInfo got Exception " + ex.getMessage());
        }
    }

    public int showDialog(Container parent) throws WcmException {
        this.show();
        SwingUtilities.updateComponentTreeUI(this);
        return this.m_retStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showProperties() {
        WcmDlgItemImpl item = this.m_contentsPane.getSelectedItem();
        ReadableMetadataObject BSObj = item.getWcmObject();
        int docMask = 0;
        if (BSObj instanceof Document) {
            docMask = ((Document)BSObj).getAccessMask();
        } else if (BSObj instanceof Folder) {
            docMask = ((Folder)BSObj).getAccessMask();
        } else {
            System.out.println("Internal Error.  Show Properties allowed on Document/Folder only!");
            return;
        }
        if ((docMask & 1) == 0) {
            WcmErrorUtil.showErrorMessage(this, WcmResourceString.s_actionDeniedOnAccessRight.toString(item.getUserName()) + WcmResourceString.s_viewProperties + " " + WcmResourceString.s_privilegeRequired, this.getTitle());
            return;
        }
        this.setWaitCursor();
        int returnVal = -1;
        WcmDlgPropertiesDialog props = null;
        try {
            props = new WcmDlgPropertiesDialog((Dialog)this, (WcmDlgItem)item);
            this.restoreCursor();
            returnVal = props.showDialog(this);
            if (returnVal == 0 && !props.isModified()) return;
        }
        catch (WcmException ex) {
            this.restoreCursor();
            System.out.println("WcmDlgVersionListDialog got exception " + ex.getMessage());
        }
    }

    public void restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void enablePropertiesButton() {
        this.m_propertiesButton.setEnabled(true);
    }

    public void setNameText(String nameText) {
        this.m_itemName.setText(nameText);
    }
}

