/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemRenderer;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgVersionListDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgVersionListModel;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class WcmDlgVersionContentsPanel
extends JPanel
implements ListSelectionListener,
IVWMouseActionListener,
TableModelListener {
    private WcmDlgVersionListModel m_versionListModel;
    private VWTable m_contentsTable;
    private WcmDlgItemImpl m_dlgItem;
    private WcmDlgVersionListDialog m_parent;
    private WcmDlgItemImpl m_selectedItem;

    public WcmDlgVersionContentsPanel(WcmDlgVersionListDialog parent, WcmDlgItemImpl dlgItem) throws WcmException {
        this.m_parent = parent;
        this.m_dlgItem = dlgItem;
        this.initLayout();
    }

    public void clearSelection() {
        if (this.m_contentsTable != null) {
            this.m_contentsTable.clearSelection();
        }
    }

    public void displayContents(WcmDlgItemImpl item) throws WcmException {
        if (this.m_versionListModel != null) {
            this.m_versionListModel.getContents(item);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int nRowIndex = -1;
        WcmDlgItemImpl item = null;
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource() == this.m_contentsTable.getSelectionModel() && (nRowIndex = this.m_contentsTable.getSelectedRow()) >= 0) {
            item = (WcmDlgItemImpl)this.m_contentsTable.getModel().getValueAt(nRowIndex, 0);
            item.getParent().setLastSelectedRow(nRowIndex);
            this.m_parent.enablePropertiesButton();
            this.m_parent.setNameText(item.getLabel());
            this.m_selectedItem = item;
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        WcmDlgItemImpl item = null;
        if (event.getSource() == this.m_contentsTable) {
            int nRowIndex = this.m_contentsTable.rowAtPoint(event.getPoint());
            if (nRowIndex < 0) {
                return;
            }
            item = (WcmDlgItemImpl)this.m_contentsTable.getModel().getValueAt(nRowIndex, 0);
            if (item == null) {
                return;
            }
            this.m_parent.enablePropertiesButton();
            this.m_selectedItem = item;
        }
    }

    public void createPopup(MouseEvent event) {
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 0: {
                if (event.getFirstRow() != 0) break;
                this.m_contentsTable.sizeColumnsToFit(-1);
            }
        }
    }

    private void initLayout() {
        WcmDlgItemRenderer itemRenderer = null;
        VWMouseAdapter mouseListener = null;
        try {
            this.setLayout(new BorderLayout(10, 10));
            itemRenderer = new WcmDlgItemRenderer();
            this.m_versionListModel = new WcmDlgVersionListModel(this.m_parent, this.m_dlgItem);
            this.m_versionListModel.addTableModelListener(this);
            mouseListener = new VWMouseAdapter((IVWMouseActionListener)this);
            this.m_contentsTable = new VWTable((TableModel)this.m_versionListModel);
            this.m_contentsTable.setShowGrid(false);
            this.m_contentsTable.addKeyListener((KeyListener)new TabKeyListener());
            this.m_contentsTable.getSelectionModel().addListSelectionListener(this);
            this.m_contentsTable.getSelectionModel().setSelectionMode(0);
            this.m_contentsTable.setDefaultRenderer(WcmDlgItemImpl.class, (TableCellRenderer)itemRenderer);
            this.m_contentsTable.setColumnSelectionAllowed(false);
            this.m_contentsTable.addMouseListener((MouseListener)mouseListener);
            this.add((Component)new JScrollPane((Component)this.m_contentsTable), "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRowSelection(int nIndex) {
        this.m_contentsTable.clearSelection();
        if (nIndex >= 0 && nIndex < this.m_contentsTable.getRowCount()) {
            this.m_contentsTable.setRowSelectionInterval(nIndex, nIndex);
        }
    }

    public int getRowSelection() {
        return this.m_contentsTable.getSelectedRow();
    }

    public WcmDlgItemImpl getSelectedItem() {
        return this.m_selectedItem;
    }

    private void moveToNewRow(boolean forward) {
        int row = this.m_contentsTable.getSelectedRow();
        int column = this.m_contentsTable.getSelectedColumn();
        if (column == -1) {
            column = 0;
        }
        if (forward) {
            if (++row == this.m_contentsTable.getRowCount()) {
                row = 0;
            }
        } else if (--row < 0) {
            row = this.m_contentsTable.getRowCount() - 1;
        }
        ListSelectionModel rowSelection = this.m_contentsTable.getSelectionModel();
        ListSelectionModel colSelection = this.m_contentsTable.getColumnModel().getSelectionModel();
        rowSelection.setSelectionInterval(row, row);
        colSelection.setSelectionInterval(column, column);
    }

    private class TabKeyListener
    extends KeyAdapter {
        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 9) {
                if (evt.isShiftDown()) {
                    WcmDlgVersionContentsPanel.this.moveToNewRow(false);
                } else {
                    WcmDlgVersionContentsPanel.this.moveToNewRow(true);
                }
                evt.consume();
            }
        }
    }
}

