/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.BaseObjects;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.api.util.Name;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddFolderWizard;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgBrowsePanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemChooserDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgPropertiesDialog;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class WcmDlgSelectionPanel
extends JPanel {
    private WcmDlgBrowsePanel m_browsePanel;
    private WcmDlgItemChooserDialog m_itemChooserDialog;
    private WcmDlgItemImpl m_currentDirectory;
    private WcmDlgItemImpl m_selectedItem;
    private int m_nExitResult = -1;
    private int m_nFileMode = 0;

    public WcmDlgSelectionPanel(WcmDlgItemChooserDialog itemChooserDialog, WcmDlgItemImpl initialDirectory) {
        this.m_itemChooserDialog = itemChooserDialog;
        this.m_currentDirectory = initialDirectory;
        this.initLayout();
    }

    public Container getParentContainer() {
        return this.m_itemChooserDialog.getParentContainer();
    }

    public void changeToParentDirectory() {
        if (this.m_currentDirectory != null) {
            this.setCurrentDirectory(this.m_currentDirectory.getParent());
        }
    }

    public WcmDlgItemImpl getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public int getExitResult() {
        return this.m_nExitResult;
    }

    public WcmDlgItemChooserDialog getItemChooserDialog() {
        return this.m_itemChooserDialog;
    }

    public WcmDlgItemImpl getInitialDirectory(WcmDlgItemImpl initialDirectory) throws WcmException {
        WcmDlgItemImpl newInitialDirectory = null;
        if (initialDirectory == null) {
            newInitialDirectory = this.m_currentDirectory.getRoot();
        } else {
            WcmDlgItemImpl prev = null;
            while (!initialDirectory.isDirectory() && prev != initialDirectory && !initialDirectory.isRoot()) {
                prev = initialDirectory;
                initialDirectory = initialDirectory.getParent();
            }
            newInitialDirectory = initialDirectory;
        }
        return newInitialDirectory;
    }

    public int getMode() {
        return this.m_nFileMode;
    }

    public WcmDlgItemImpl getSelectedItem() {
        return this.m_selectedItem;
    }

    public void onOthers() {
        this.setSelectedItem(null);
        this.m_nExitResult = 2;
        this.m_itemChooserDialog.setVisible(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onApprove() {
        block26: {
            Folder fdr;
            int docMask;
            WcmDlgItemImpl item;
            block27: {
                this.m_nExitResult = 0;
                item = this.getSelectedItem();
                if (item == null) {
                    return;
                }
                this.m_itemChooserDialog.setWaitCursor();
                this.m_itemChooserDialog.setEnabled(false);
                if (item.getItemType() != 4) break block27;
                switch (this.m_itemChooserDialog.getBrowseMode()) {
                    case 2: {
                        try {
                            if (this.m_browsePanel != null) {
                                this.m_nFileMode = this.m_browsePanel.getMode();
                                this.setVersionChoice(item);
                            }
                            ReadableMetadataObject obj = item.getWcmObject();
                            if (this.m_nFileMode == 1) {
                                Document curObj;
                                if (!item.isAssumeCheckout() && !this.hasCheckinRight((Document)obj, item)) {
                                    this.m_itemChooserDialog.restoreCursor();
                                    return;
                                }
                                Document checkoutObj = null;
                                if (item.isAssumeCheckout()) {
                                    if (!(obj instanceof Document)) throw new WcmException("client.WcmDlgSelectionPanel.InvalidWcmObject", "Invalid ReadableMetadataObject in WcmDlgItemImpl");
                                    curObj = (Document)item.getWcmObject();
                                    checkoutObj = curObj.getReservation();
                                } else if (obj instanceof VersionSeries) {
                                    checkoutObj = ((VersionSeries)obj).checkout();
                                } else {
                                    if (!(obj instanceof Document)) throw new WcmException("client.WcmDlgSelectionPanel.InvalidWcmObject", "Invalid ReadableMetadataObject in WcmDlgItemImpl");
                                    try {
                                        item.getVersionSeries().refresh();
                                    }
                                    catch (ClassCastException c) {
                                        // empty catch block
                                    }
                                    curObj = item.getVersionSeries().getCurrentVersion();
                                    checkoutObj = curObj.checkout();
                                }
                                if (!this.hasCheckinRight(checkoutObj, item)) {
                                    checkoutObj.cancelCheckout();
                                    this.m_itemChooserDialog.restoreCursor();
                                    return;
                                }
                                curObj = item.getVersionSeries().getCurrentVersion();
                                try {
                                    curObj.refresh();
                                }
                                catch (ClassCastException c) {
                                    // empty catch block
                                }
                                this.m_selectedItem = new WcmDlgItemImpl((ReadableMetadataObject)curObj, 4, item.getParent());
                                item.getParent().setDirty();
                                item.getParent().list(this.m_itemChooserDialog.getFilterTypes());
                                break;
                            }
                            if (this.m_nFileMode == 2 && !this.hasViewContentRight((Document)obj, item)) {
                                this.m_itemChooserDialog.restoreCursor();
                                return;
                            }
                            break block26;
                        }
                        catch (Exception ex) {
                            this.m_itemChooserDialog.setEnabled(true);
                            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_failAction.toString(ex.getMessage()), this.m_itemChooserDialog.getTitle());
                            this.m_itemChooserDialog.restoreCursor();
                            this.m_browsePanel.refreshContents(this.m_itemChooserDialog, false);
                            return;
                        }
                    }
                    case 4: {
                        try {
                            ReadableMetadataObject obj = item.getWcmObject();
                            if (obj instanceof VersionSeries) {
                                ((VersionSeries)obj).delete();
                            } else {
                                if (!(obj instanceof Document)) throw new WcmException("client.WcmDlgSelectionPanel.InvalidWcmObject", "Invalid ReadableMetadataObject in WcmDlgItemImpl");
                                ((Document)obj).delete();
                            }
                            item.getParent().setDirty();
                            item.getParent().list(this.m_itemChooserDialog.getFilterTypes());
                            break;
                        }
                        catch (Exception ex) {
                            this.m_itemChooserDialog.setEnabled(true);
                            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_failAction.toString(ex.getMessage()), this.m_itemChooserDialog.getTitle());
                            this.m_itemChooserDialog.restoreCursor();
                            return;
                        }
                    }
                    default: {
                        if (this.m_browsePanel != null) {
                            this.setVersionChoice(item);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block26;
            }
            if (item.getItemType() == 3 && this.m_itemChooserDialog.getBrowseMode() == 3 && ((docMask = (fdr = (Folder)item.getWcmObject()).getAccessMask()) & 0x10) == 0) {
                this.m_itemChooserDialog.setEnabled(true);
                WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_noRightAddToFolder.toString(item.getUserName(), (Object)item.getLabel()) + WcmResourceString.s_addToFolder + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
                this.m_itemChooserDialog.restoreCursor();
                return;
            }
        }
        this.m_itemChooserDialog.restoreCursor();
        this.m_itemChooserDialog.setVisible(false);
    }

    public void onCancel() {
        this.setSelectedItem(null);
        this.m_nExitResult = 1;
        this.m_itemChooserDialog.setVisible(false);
    }

    public void setCurrentDirectory(WcmDlgItemImpl currentDirectory) {
        WcmDlgItemImpl newDirectory = null;
        WcmDlgItemImpl oldDirectory = this.m_currentDirectory;
        try {
            newDirectory = this.getInitialDirectory(currentDirectory);
            if (this.m_currentDirectory != newDirectory || newDirectory.isDirty()) {
                this.m_currentDirectory = newDirectory;
                if (this.m_browsePanel != null) {
                    this.m_browsePanel.setCurrentDirectory(newDirectory);
                }
            }
        }
        catch (WcmException ex) {
            int boType = newDirectory.getWcmObject().getObjectType();
            String objName = newDirectory.getLabel() + "(" + Name.objectTypeAsName((int)boType) + ")";
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_itemNotAvailable.toString(objName, (Object)ex.getMessage()), this.m_itemChooserDialog.getTitle());
            if (boType == 4) {
                newDirectory.setObjectStoreIsDown();
            }
            try {
                this.m_browsePanel.setCurrentDirectory(oldDirectory);
            }
            catch (WcmException ex2) {
                WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), ex.getMessage(), this.m_itemChooserDialog.getTitle());
            }
        }
    }

    public boolean setSelectedItem(WcmDlgItemImpl selectedItem) {
        boolean bResult = true;
        this.m_selectedItem = selectedItem;
        if (this.m_browsePanel != null) {
            this.m_browsePanel.setSelectedItem(this.m_selectedItem);
        }
        return bResult;
    }

    public void setPreSelectedItem(WcmDlgItemImpl currentDirectory) throws WcmException {
        if (this.m_browsePanel != null) {
            this.m_browsePanel.setCurrentDirectory(this.m_currentDirectory);
        }
    }

    public int getViewMode() {
        if (this.m_browsePanel == null) {
            return 0;
        }
        return this.m_browsePanel.getViewMode();
    }

    public JButton getDefaultButton() {
        return this.m_browsePanel.getDefaultButton();
    }

    private void initLayout() {
        try {
            this.setLayout(new BorderLayout(10, 10));
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_browsePanel = new WcmDlgBrowsePanel(this);
            this.add((Component)this.m_browsePanel, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showProperties() {
        WcmDlgItemImpl item = this.getSelectedItem();
        ReadableMetadataObject BSObj = item.getWcmObject();
        int docMask = 0;
        if (BSObj instanceof Document) {
            docMask = ((Document)BSObj).getAccessMask();
        } else if (BSObj instanceof CustomObject) {
            docMask = ((CustomObject)BSObj).getAccessMask();
        } else if (BSObj instanceof Folder) {
            docMask = ((Folder)BSObj).getAccessMask();
        } else {
            System.out.println("Internal Error.  Show Properties allowed on Document/Folder only!");
            return;
        }
        if ((docMask & 1) == 0) {
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_actionDeniedOnAccessRight.toString(item.getUserName()) + WcmResourceString.s_viewProperties + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
            return;
        }
        this.m_itemChooserDialog.setWaitCursor();
        int returnVal = -1;
        try {
            this.m_selectedItem.getWcmObject().refresh();
        }
        catch (ClassCastException c) {
            // empty catch block
        }
        WcmDlgPropertiesDialog props = null;
        try {
            props = new WcmDlgPropertiesDialog((Dialog)((Object)this.m_itemChooserDialog), (WcmDlgItem)this.m_selectedItem);
            returnVal = props.showDialog((Container)((Object)this.m_itemChooserDialog));
            if (returnVal == 0 && props.isModified()) {
                this.m_browsePanel.refreshContents(this.m_itemChooserDialog, false);
            }
        }
        catch (WcmException ex) {
            System.out.println("WcmDlgPropertiesDialog got exception " + ex.getMessage());
        }
        this.m_itemChooserDialog.restoreCursor();
    }

    public boolean deleteItem() {
        Object curGrantee = null;
        boolean userType = false;
        WcmDlgItemImpl item = this.getSelectedItem();
        if (item == null) {
            return false;
        }
        ReadableMetadataObject BSObj = item.getWcmObject();
        int docMask = 0;
        if (BSObj instanceof Document) {
            docMask = ((Document)BSObj).getAccessMask();
        } else if (BSObj instanceof CustomObject) {
            docMask = ((CustomObject)BSObj).getAccessMask();
        } else if (BSObj instanceof Folder) {
            BaseObjects objs = ((Folder)BSObj).getContainees(new int[]{2});
            if (objs != null && objs.size() > 0) {
                WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_deleteReferencedFolder, this.m_itemChooserDialog.getTitle());
                return false;
            }
            docMask = ((Folder)BSObj).getAccessMask();
        } else {
            System.out.println("Internal Error.  Delete allowed on Document/CustomObject/Folder only!");
            return false;
        }
        if ((docMask & 0x10000) == 0) {
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_actionDeniedOnAccessRight.toString(item.getUserName()) + WcmResourceString.s_fullControl + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
            return false;
        }
        Object[] options = new Object[]{WcmResourceString.s_yes, WcmResourceString.s_no};
        int ret = JOptionPane.showOptionDialog((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_confirmDeleteStmt.toString(item.getLabel()), WcmResourceString.s_confirmDelete, 0, 3, null, options, options[1]);
        if (ret == 1) {
            return false;
        }
        this.m_itemChooserDialog.setWaitCursor();
        try {
            if (BSObj instanceof Document) {
                ((Document)BSObj).delete();
            } else if (BSObj instanceof Folder) {
                ((Folder)BSObj).delete();
            } else if (BSObj instanceof CustomObject) {
                ((CustomObject)BSObj).delete();
            } else {
                throw new WcmException("client.WcmDlgSelectionPanel.InvalidWcmObject", "Invalid ReadableMetadataObject in WcmDlgItemImpl");
            }
            WcmDlgItemImpl dir = item.getParent();
            dir.clearContents();
            dir.setLastSelectedRow(-1);
            this.setCurrentDirectory(dir);
        }
        catch (Exception ex) {
            System.out.println("Got exception during delete() " + ex.getMessage());
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_failAction.toString(ex.getMessage()), this.m_itemChooserDialog.getTitle());
            this.m_itemChooserDialog.restoreCursor();
            return false;
        }
        this.m_itemChooserDialog.restoreCursor();
        return true;
    }

    public void addNewFolder() {
        int docMask;
        WcmDlgItemImpl dir = this.getCurrentDirectory();
        ReadableMetadataObject bsObj = dir.getWcmObject();
        if (bsObj instanceof ObjectStore) {
            docMask = ((ObjectStore)bsObj).getRootFolder().getAccessMask();
        } else if (bsObj instanceof Folder) {
            docMask = ((Folder)bsObj).getAccessMask();
        } else {
            System.out.println("[Internal Error] Invalid item type");
            return;
        }
        if ((docMask & 0x200) == 0) {
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_actionDeniedOnAccessRight.toString(dir.getUserName()) + WcmResourceString.s_modifyProperties + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
            return;
        }
        try {
            Properties props = ObjectFactory.getProperties();
            WcmDlgAddFolderWizard addFolderDialog = new WcmDlgAddFolderWizard((Dialog)((Object)this.m_itemChooserDialog), dir, new WcmDlgClassDescItem("{01A3A8CA-7AEC-11D1-A31B-0020AF9FBB1C}", dir), props);
            addFolderDialog.setTitle(WcmResourceString.s_addFolderWizard);
            this.m_itemChooserDialog.setWaitCursor();
            int returnVal = addFolderDialog.showDialog(this);
            this.m_itemChooserDialog.restoreCursor();
            if (returnVal == 0) {
                Folder createdFolder = addFolderDialog.getCreatedFolder();
                WcmDlgItemImpl folderItem = new WcmDlgItemImpl((ReadableMetadataObject)createdFolder, 3, dir);
                dir.appendChild(folderItem, this.m_itemChooserDialog.getFilterTypes());
                dir.setLastSelectedRow(dir.getContaineeCount() - 1);
                if (this.m_browsePanel != null) {
                    this.m_browsePanel.setCurrentDirectory(dir);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Got exception during addNewFolder() " + ex.getMessage());
            this.m_itemChooserDialog.restoreCursor();
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_failAction.toString(ex.getMessage()), this.m_itemChooserDialog.getTitle());
        }
    }

    private void setVersionChoice(WcmDlgItemImpl item) {
        if (item.isVersionItem()) {
            item.setVersionChoice(3);
        } else {
            item.setVersionChoice(this.m_browsePanel.getVersionChoice());
        }
    }

    private boolean hasCheckinRight(Document obj, WcmDlgItemImpl item) {
        int asMask = obj.getAccessMask();
        if ((asMask & 4) == 0) {
            this.m_itemChooserDialog.setEnabled(true);
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_noRightCheckout.toString(item.getUserName(), (Object)item.getLabel()) + WcmResourceString.s_promoteVersion + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
            return false;
        }
        return true;
    }

    private boolean hasViewContentRight(Document obj, WcmDlgItemImpl item) {
        int asMask = obj.getAccessMask();
        if ((asMask & 0x80) == 0) {
            this.m_itemChooserDialog.setEnabled(true);
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDialog), WcmResourceString.s_noRightOpen.toString(item.getUserName(), (Object)item.getLabel()) + WcmResourceString.s_viewContent + " " + WcmResourceString.s_privilegeRequired, this.m_itemChooserDialog.getTitle());
            return false;
        }
        return true;
    }
}

