/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Permission;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.ReadableSecurityObject;
import com.filenet.wcm.api.SecurityPolicy;
import com.filenet.wcm.api.SecurityTemplate;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import java.util.Collection;
import java.util.Iterator;

public class WcmDlgSecurityHelper {
    private ClassDescription m_classDescription;
    private Permissions m_perms;
    private Permissions m_templatePerms;
    private boolean m_isEditable;
    private boolean m_isModified;

    public WcmDlgSecurityHelper(ClassDescription cd) {
        this.m_classDescription = cd;
        this.m_perms = cd.getDefaultPermissions();
        this.m_isEditable = true;
        try {
            PropertyDescriptions pds = cd.getPropertyDescriptions(true);
            PropertyDescription pd = (PropertyDescription)pds.findByProperty("SymbolicName", 1, "SecurityPolicy");
            if (pd != null) {
                SecurityPolicy sp = (SecurityPolicy)pd.getPropertyValue("PropertyDefaultObject");
                this.applySecurityPolicy(sp);
            }
        }
        catch (PropertyNotFoundException ex1) {
            System.out.println(" No security policy found on " + cd.getName());
            System.out.println(" WcmDlgSecurityHelper got exception: " + ex1.getMessage());
        }
        catch (Exception ex2) {
            System.out.println(" WcmDlgSecurityHelper got exception: " + ex2.getMessage());
            ex2.printStackTrace();
        }
    }

    public WcmDlgSecurityHelper(ReadableSecurityObject doc, boolean bWriteACL) {
        this.m_perms = doc.getPermissions("Permissions");
        this.m_isEditable = true;
        if (!bWriteACL) {
            return;
        }
        try {
            SecurityPolicy sp = (SecurityPolicy)doc.getPropertyValue("SecurityPolicy");
            this.applySecurityPolicy(sp);
        }
        catch (PropertyNotFoundException ex1) {
            System.out.println(" No security policy found on " + doc.getName());
            System.out.println(" WcmDlgSecurityHelper got exception: " + ex1.getMessage());
        }
        catch (Exception ex2) {
            System.out.println(" WcmDlgSecurityHelper got exception: " + ex2.getMessage());
            ex2.printStackTrace();
        }
    }

    public Permissions getObjectPermissions() {
        return this.m_perms;
    }

    public Permissions getTemplatePermissions() {
        return this.m_templatePerms;
    }

    public boolean isEditable() {
        return this.m_isEditable;
    }

    public boolean isModified() {
        return this.m_isModified;
    }

    private void applySecurityPolicy(SecurityPolicy sp) throws PropertyNotFoundException, Exception {
        if (sp == null) {
            return;
        }
        int asMask = sp.getUserAccess().asMask();
        if ((asMask & 1) == 0) {
            this.m_isEditable = false;
        } else {
            Values vls = (Values)sp.getPropertyValue("SecurityTemplates");
            boolean preserveDP = sp.getPropertyBooleanValue("PreserveDirectPermissions");
            SecurityTemplate template = null;
            Iterator iter = vls.iterator();
            while (iter.hasNext() && !(template = (SecurityTemplate)((Value)iter.next()).getValue()).getApplyStateId().equalsIgnoreCase("{95AD7AED-DFA0-4459-AE95-2CA2FC041602}")) {
            }
            if (template != null && template.getIsEnabled()) {
                if (!preserveDP) {
                    this.m_perms.removeAll((Collection)this.m_perms);
                    this.m_templatePerms = template.getPermissions();
                    this.m_isEditable = false;
                } else {
                    Permission perm = null;
                    Iterator iter2 = this.m_perms.iterator();
                    while (iter2.hasNext()) {
                        perm = (Permission)iter2.next();
                        if (perm.getPermissionSource() != 2) continue;
                        iter2.remove();
                    }
                    this.m_templatePerms = template.getPermissions();
                }
            }
        }
    }
}

