/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.util.Name;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.WcmItemProperty;
import com.filenet.wcm.toolkit.client.ui.WcmPropertiesGridPanel;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class WcmDlgPropertiesDialog
extends VWModalDialog
implements ActionListener {
    protected JTabbedPane m_tabbedPanel = new JTabbedPane();
    protected WcmSecurityPanel m_securityPane;
    protected JLabel m_itemName1 = new JLabel();
    protected JLabel m_itemName2 = new JLabel();
    protected JLabel m_className1 = new JLabel();
    protected JLabel m_className2 = new JLabel();
    protected JButton m_OKButton = new JButton(WcmResourceString.s_ok);
    protected JButton m_cancelButton = new JButton(WcmResourceString.s_cancel);
    protected boolean m_bFrameSizeAdjusted = false;
    protected int m_retStatus;
    protected boolean m_bDirty = false;
    protected WcmDlgItemImpl m_dlgItem;
    protected ReadableMetadataObject m_dlgObject;
    protected WcmPropertiesGridPanel m_propertiesPanelA;
    protected WcmPropertiesGridPanel m_propertiesPanelB;
    protected ClassDescriptions m_docClassObjs;
    protected ClassDescription m_docClassObj;
    protected String m_selDocClassName;
    protected Properties m_properties;
    protected JComboBox m_stateComboBox;
    protected boolean m_bSecurityReadOnly;
    protected boolean m_bSecurityHide;
    protected boolean m_bPropsReadOnly;
    protected boolean m_bLifecycleReadOnly;
    protected WcmLCStateItem m_selLCStateItem;

    public WcmDlgPropertiesDialog(Frame parent, BaseObject obj) throws WcmException {
        super(parent);
        if (!(obj instanceof ReadableMetadataObject)) {
            throw new WcmException("client.WcmDlgPropertiesDialog.InvalidItemType", "Invalid Item Type.");
        }
        this.m_dlgObject = (ReadableMetadataObject)obj;
        this.m_dlgItem = new WcmDlgItemImpl(this.m_dlgObject);
        this.setupClassInfo();
        this.initReadOnly();
        this.initLayout(parent);
    }

    public WcmDlgPropertiesDialog(Dialog parent, BaseObject obj) throws WcmException {
        super(parent);
        if (!(obj instanceof ReadableMetadataObject)) {
            throw new WcmException("client.WcmDlgPropertiesDialog.InvalidItemType", "Invalid Item Type.");
        }
        this.m_dlgObject = (ReadableMetadataObject)obj;
        this.m_dlgItem = new WcmDlgItemImpl(this.m_dlgObject);
        this.setupClassInfo();
        this.initReadOnly();
        this.initLayout(parent);
    }

    public WcmDlgPropertiesDialog(Frame parent, WcmDlgItem item) throws WcmException {
        super(parent);
        this.m_dlgItem = (WcmDlgItemImpl)item;
        this.m_dlgObject = item.getWcmObject();
        this.setupClassInfo();
        this.initReadOnly();
        this.initLayout(parent);
    }

    public WcmDlgPropertiesDialog(Dialog parent, WcmDlgItem item) throws WcmException {
        super(parent);
        this.m_dlgItem = (WcmDlgItemImpl)item;
        this.m_dlgObject = item.getWcmObject();
        this.setupClassInfo();
        this.initReadOnly();
        this.initLayout(parent);
    }

    private void initReadOnly() {
        int asMask = 0;
        switch (this.m_dlgItem.getItemType()) {
            case 3: {
                asMask = ((Folder)this.m_dlgObject).getAccessMask();
                break;
            }
            case 4: {
                asMask = ((Document)this.m_dlgObject).getAccessMask();
                break;
            }
            case 5: {
                asMask = ((CustomObject)this.m_dlgObject).getAccessMask();
                break;
            }
        }
        boolean bl = this.m_bSecurityReadOnly = (asMask & 0x40000) == 0;
        if (this.m_bSecurityReadOnly) {
            this.m_bSecurityHide = (asMask & 0x20000) == 0;
        }
        this.m_bPropsReadOnly = (asMask & 2) == 0;
        this.m_bLifecycleReadOnly = (asMask & 0x400) == 0;
    }

    private void initLayout(Container parent) throws WcmException {
        try {
            if (parent != null) {
                this.setComponentOrientation(parent.getComponentOrientation());
            }
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dim = WcmStringUtil.stringToDimension(WcmResourceString.s_propertiesDialogDim);
            if (dim == null) {
                dim = new Dimension(600, 400);
            }
            this.setPreferredSize(dim);
            this.setVisible(false);
            switch (this.m_dlgItem.getItemType()) {
                case 3: {
                    this.setTitle(WcmResourceString.s_folderPropertiesDlgTitle);
                    this.m_properties = ((Folder)this.m_dlgObject).getProperties();
                    this.m_tabbedPanel.add(WcmResourceString.s_properties, this.createFolderGeneralTab());
                    this.m_propertiesPanelA.setNameProperty(this.getFolderNameProperty(), true);
                    this.m_propertiesPanelA.loadCustomProperties(this.m_docClassObj, this.m_properties);
                    this.m_tabbedPanel.add(WcmResourceString.s_systemProperties, this.createSysPropsTab());
                    this.m_propertiesPanelB.loadSystemProperties(this.m_docClassObj, this.m_properties);
                    if (this.m_bSecurityHide) break;
                    this.addFolderSecurityTab();
                    break;
                }
                case 4: {
                    this.setTitle(WcmResourceString.s_documentProperties);
                    this.m_properties = ((Document)this.m_dlgObject).getProperties();
                    this.m_tabbedPanel.add(WcmResourceString.s_properties, this.createDocGeneralTab());
                    this.m_propertiesPanelA.setNameProperty(this.getDocumentNameProperty(), false);
                    this.m_propertiesPanelA.loadCustomProperties(this.m_docClassObj, this.m_properties);
                    this.m_tabbedPanel.add(WcmResourceString.s_systemProperties, this.createSysPropsTab());
                    this.m_propertiesPanelB.loadSystemProperties(this.m_docClassObj, this.m_properties);
                    if (this.m_bSecurityHide) break;
                    this.addDocumentSecurityTab();
                    break;
                }
                case 5: {
                    this.setTitle(WcmResourceString.s_customObjectProperties);
                    this.m_properties = ((CustomObject)this.m_dlgObject).getProperties();
                    this.m_tabbedPanel.add(WcmResourceString.s_properties, this.createDocGeneralTab());
                    this.m_propertiesPanelA.setNameProperty(this.getDocumentNameProperty(), false);
                    this.m_propertiesPanelA.loadCustomProperties(this.m_docClassObj, this.m_properties);
                    this.m_tabbedPanel.add(WcmResourceString.s_systemProperties, this.createSysPropsTab());
                    this.m_propertiesPanelB.loadSystemProperties(this.m_docClassObj, this.m_properties);
                    if (this.m_bSecurityHide) break;
                    this.addCustomObjectSecurityTab();
                    break;
                }
                default: {
                    System.out.println("Invalid item type " + this.m_dlgItem.getItemType());
                    throw new WcmException("client.WcmDlgPropertiesDialog.InvalidItemType", "Invalid Item Type.");
                }
            }
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(parent);
            this.pack();
            if (parent != null) {
                this.applyComponentOrientation(parent.getComponentOrientation());
            }
        }
        catch (Exception ex) {
            System.out.println("WcmDlgPropertiesDialog Exception " + ex.getMessage());
            if (this.m_dlgItem == null) {
                System.out.println(" No selected dialog item.");
            }
            throw new WcmException("client.WcmDlgPropertiesDialog.FailedInitDialog", "Failed to initialize dialog. Exception {0}.", (Object)ex.getMessage());
        }
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.m_bFrameSizeAdjusted) {
            return;
        }
        this.m_bFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    protected JPanel createDocGeneralTab() throws Exception {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        ImageIcon itemIcon = this.m_dlgItem.getBigIcon();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JLabel iconLabel = new JLabel(itemIcon, 2);
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new GridBagLayout());
        topLeftPanel.add((Component)new JLabel(WcmResourceString.s_name), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        String str = "";
        if (this.m_dlgItem == null) {
            this.m_itemName1.setText("No item provided!");
        } else {
            str = this.m_dlgItem.getLabel();
            this.m_itemName1.setText(str);
        }
        this.m_itemName1.setForeground(Color.black);
        topLeftPanel.add((Component)this.m_itemName1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        topLeftPanel.add((Component)new JLabel(WcmResourceString.s_class), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        str = "";
        if (this.m_dlgItem == null) {
            this.m_className1.setText("No Class Found!");
        } else {
            this.m_className1.setText(this.m_selDocClassName);
        }
        this.m_className1.setForeground(Color.black);
        topLeftPanel.add((Component)this.m_className1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        topPanel.add((Component)topLeftPanel, "Center");
        topPanel.add((Component)iconLabel, "After");
        mainPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 23, 1, new Insets(5, 10, 5, 20), 0, 0));
        this.m_propertiesPanelA = new WcmPropertiesGridPanel((Container)((Object)this));
        if (this.m_bPropsReadOnly) {
            this.m_propertiesPanelA.setMode(2);
        } else {
            this.m_propertiesPanelA.setMode(16);
        }
        mainPanel.add((Component)this.m_propertiesPanelA, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
        return mainPanel;
    }

    protected JPanel createFolderGeneralTab() throws Exception {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        ImageIcon itemIcon = this.m_dlgItem.getBigIcon();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JLabel iconLabel = new JLabel(itemIcon, 2);
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new GridBagLayout());
        topLeftPanel.add((Component)new JLabel(WcmResourceString.s_name), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        String str = "";
        if (this.m_dlgItem == null) {
            this.m_itemName1.setText("DummyItem");
        } else {
            str = this.m_dlgItem.getLabel();
            this.m_itemName1.setText(str);
        }
        this.m_itemName1.setForeground(Color.black);
        topLeftPanel.add((Component)this.m_itemName1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        topLeftPanel.add((Component)new JLabel(WcmResourceString.s_class), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        str = "";
        if (this.m_dlgItem == null) {
            this.m_className1.setText("No Class Found!");
        } else {
            this.m_className1.setText(this.m_selDocClassName);
        }
        this.m_className1.setForeground(Color.black);
        topLeftPanel.add((Component)this.m_className1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        topPanel.add((Component)topLeftPanel, "Center");
        topPanel.add((Component)iconLabel, "After");
        mainPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 23, 1, new Insets(5, 10, 5, 20), 0, 0));
        this.m_propertiesPanelA = new WcmPropertiesGridPanel((Container)((Object)this));
        if (this.m_bPropsReadOnly) {
            this.m_propertiesPanelA.setMode(2);
        } else {
            this.m_propertiesPanelA.setMode(16);
        }
        mainPanel.add((Component)this.m_propertiesPanelA, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
        return mainPanel;
    }

    protected JPanel createSysPropsTab() throws Exception {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)new JLabel(WcmResourceString.s_name), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        String str = "";
        if (this.m_dlgItem == null) {
            this.m_itemName2.setText("DummyItem");
        } else {
            str = this.m_dlgItem.getLabel();
            this.m_itemName2.setText(str);
        }
        this.m_itemName2.setForeground(Color.black);
        mainPanel.add((Component)this.m_itemName2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        int y = 1;
        mainPanel.add((Component)new JLabel(WcmResourceString.s_class), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
        str = "";
        if (this.m_dlgItem == null) {
            this.m_className2.setText("No Class Found!");
        } else {
            this.m_className2.setText(this.m_selDocClassName);
        }
        this.m_className2.setForeground(Color.black);
        mainPanel.add((Component)this.m_className2, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 10), 0, 0));
        String s_curState = this.m_dlgItem.getCurrentLifecycleState();
        if (this.m_dlgItem.getWcmObject().getObjectType() == 1 && s_curState != null && !s_curState.equalsIgnoreCase("")) {
            mainPanel.add((Component)new JLabel(WcmResourceString.s_lifeCycleState), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 10, 0, 5), 0, 0));
            this.m_stateComboBox = new JComboBox();
            this.m_stateComboBox.addActionListener(this);
            if (this.m_stateComboBox != null) {
                this.m_stateComboBox.setEditable(false);
                mainPanel.add((Component)this.m_stateComboBox, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 8, 0, 10), 0, 0));
            }
            String s_lastState = this.m_dlgItem.getLastLifecycleState();
            String s_nextState = this.m_dlgItem.getNextLifecycleState();
            boolean bInException = false;
            bInException = this.m_dlgItem.getWcmObject().getPropertyBooleanValue("IsInExceptionState");
            int idx = 0;
            if (bInException) {
                this.m_stateComboBox.addItem(new WcmLCStateItem(WcmResourceString.s_exception + " " + WcmResourceString.s_noChange, 0));
                this.m_stateComboBox.addItem(new WcmLCStateItem(WcmResourceString.s_clearException, 0x400000));
            } else {
                if (s_lastState != null) {
                    this.m_stateComboBox.addItem(new WcmLCStateItem(s_lastState + " " + WcmResourceString.s_demote, 0x200000));
                    ++idx;
                }
                this.m_stateComboBox.addItem(new WcmLCStateItem(s_curState + " " + WcmResourceString.s_noChange, 0));
                if (s_nextState != null) {
                    this.m_stateComboBox.addItem(new WcmLCStateItem(s_nextState + " " + WcmResourceString.s_promote, 0x100000));
                }
                this.m_stateComboBox.addItem(new WcmLCStateItem(WcmResourceString.s_setException, 0x300000));
                if (s_lastState != null) {
                    this.m_stateComboBox.addItem(new WcmLCStateItem(WcmResourceString.s_reset, 0x500000));
                }
            }
            this.m_stateComboBox.setSelectedIndex(idx);
            if (this.m_bLifecycleReadOnly) {
                this.m_stateComboBox.setEnabled(false);
            }
        }
        this.m_propertiesPanelB = new WcmPropertiesGridPanel((Container)((Object)this));
        this.m_propertiesPanelB.setMode(2);
        mainPanel.add((Component)this.m_propertiesPanelB, new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_OKButton.addActionListener(this);
            this.m_OKButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.okMonic));
            mainPanel.add((Component)this.m_OKButton, gbConst);
            this.m_cancelButton.addActionListener(this);
            this.m_cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.cancelMonic));
            mainPanel.add((Component)this.m_cancelButton, gbConst);
        }
        catch (Exception ex) {
            System.out.println("createButtonPanel Exception " + ex.getMessage());
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        this.m_retStatus = -1;
        if (obj == this.m_stateComboBox) {
            this.m_selLCStateItem = (WcmLCStateItem)this.m_stateComboBox.getSelectedItem();
        } else if (obj == this.m_cancelButton) {
            try {
                this.m_retStatus = 1;
                this.setVisible(false);
            }
            catch (Exception ex) {}
        } else if (obj == this.m_OKButton) {
            if (!this.m_propertiesPanelA.validateProperties()) {
                return;
            }
            try {
                switch (this.m_dlgObject.getObjectType()) {
                    case 1: 
                    case 1160: {
                        Properties props;
                        if (!this.m_bPropsReadOnly && (props = this.m_propertiesPanelA.getProperties(2)) != null && props.size() > 0) {
                            ((Document)this.m_dlgObject).setProperties(props);
                        }
                        if (this.m_securityPane.isModified()) {
                            Permissions perm = this.m_securityPane.getPermissions();
                            ((Document)this.m_dlgObject).setPermissions(perm, "Permissions");
                        }
                        if (this.m_selLCStateItem == null || this.m_selLCStateItem.getAction() == 0) break;
                        ((Document)this.m_dlgItem.getWcmObject()).changeLifeCycleState(this.m_selLCStateItem.getAction());
                        break;
                    }
                    case -101: 
                    case -100: {
                        Properties props;
                        if (!this.m_bPropsReadOnly && (props = this.m_propertiesPanelA.getProperties(2)) != null && props.size() > 0) {
                            ((Document)this.m_dlgObject).setProperties(props);
                        }
                        if (!this.m_securityPane.isModified()) break;
                        Permissions perm = this.m_securityPane.getPermissions();
                        ((Document)this.m_dlgObject).setPermissions(perm, "Permissions");
                        break;
                    }
                    case 15: {
                        Properties props;
                        if (!this.m_bPropsReadOnly && (props = this.m_propertiesPanelA.getProperties(2)) != null && props.size() > 0) {
                            ((CustomObject)this.m_dlgObject).setProperties(props);
                        }
                        if (this.m_securityPane == null || !this.m_securityPane.isModified()) break;
                        Permissions perm = this.m_securityPane.getPermissions();
                        ((CustomObject)this.m_dlgObject).setPermissions(perm, "Permissions");
                        break;
                    }
                    case 2: {
                        Properties props;
                        if (!this.m_bPropsReadOnly && (props = this.m_propertiesPanelA.getProperties(2)) != null && props.size() > 0) {
                            ((Folder)this.m_dlgObject).setProperties(props);
                        }
                        if (!this.m_securityPane.isModified()) break;
                        Permissions perm = this.m_securityPane.getPermissions();
                        ((Folder)this.m_dlgObject).setPermissions(perm);
                        break;
                    }
                    default: {
                        throw new WcmException("client.WcmDlgPropertiesDialog.UnsupportedObjectType", "Unsupported Object Type - {0}", (Object)Name.objectTypeAsName((int)this.m_dlgObject.getObjectType()));
                    }
                }
                if (!this.m_bPropsReadOnly) {
                    this.m_bDirty = true;
                }
            }
            catch (Exception ex) {
                WcmErrorUtil.showErrorMessage((Component)((Object)this), WcmResourceString.s_failAction.toString(ex.getMessage()), this.getTitle());
            }
            this.m_retStatus = 0;
            this.setVisible(false);
        }
    }

    public int getStatus() {
        return this.m_retStatus;
    }

    public boolean isModified() {
        return this.m_bDirty;
    }

    protected void setupClassInfo() throws WcmException {
        this.m_docClassObj = this.m_dlgItem.getClassDescription();
        try {
            if (this.m_docClassObj == null) {
                System.out.println("Invalid object. No Class Description Found");
                throw new WcmException("client.WcmDlgPropertiesInfo.ClassDescriptionNotFound", "No Class Description Found");
            }
            this.m_selDocClassName = WcmItemProperty.getClassDescDisplayName(this.m_docClassObj);
        }
        catch (Exception ex) {
            System.out.println("setupClassInfo got Exception " + ex.getMessage());
        }
    }

    public int showDialog(Container parent) throws WcmException {
        this.show();
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        return this.m_retStatus;
    }

    private void addFolderSecurityTab() {
        JPanel SecurityPanel = new JPanel();
        SecurityPanel.setLayout(new GridBagLayout());
        try {
            Permissions perms = ((Folder)this.m_dlgItem.getWcmObject()).getPermissions();
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog = this;
            this.m_securityPane = new WcmSecurityPanel((Window)((Object)this), wcmDlgPropertiesDialog.m_dlgItem.getSession(), perms, this.m_dlgObject.getObjectType(), this.m_bSecurityReadOnly);
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog2 = this;
            this.m_securityPane.setSitePrefs(wcmDlgPropertiesDialog2.m_dlgItem.getSitePreferences());
            SecurityPanel.add((Component)this.m_securityPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
            this.m_tabbedPanel.add(WcmResourceString.s_security, SecurityPanel);
        }
        catch (Exception e) {
            System.out.println("Get exception in SecurityPanel. " + e.getMessage());
            System.out.println("Skip adding Security Tab.");
        }
    }

    private void addDocumentSecurityTab() {
        JPanel SecurityPanel = new JPanel();
        SecurityPanel.setLayout(new GridBagLayout());
        Permissions perms = ((Document)this.m_dlgObject).getPermissions("Permissions");
        try {
            int objType = this.m_dlgObject.getObjectType();
            if (objType == 1160) {
                objType = 1;
            }
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog = this;
            this.m_securityPane = new WcmSecurityPanel((Window)((Object)this), wcmDlgPropertiesDialog.m_dlgItem.getSession(), perms, objType, this.m_bSecurityReadOnly);
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog2 = this;
            this.m_securityPane.setSitePrefs(wcmDlgPropertiesDialog2.m_dlgItem.getSitePreferences());
            SecurityPanel.add((Component)this.m_securityPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
            this.m_tabbedPanel.add(WcmResourceString.s_security, SecurityPanel);
        }
        catch (Exception e) {
            System.out.println("Get exception in SecurityPanel. " + e.getMessage());
            System.out.println("Skip adding Security Tab.");
        }
    }

    private void addCustomObjectSecurityTab() {
        JPanel SecurityPanel = new JPanel();
        SecurityPanel.setLayout(new GridBagLayout());
        Permissions perms = ((CustomObject)this.m_dlgObject).getPermissions("Permissions");
        try {
            int objType = this.m_dlgObject.getObjectType();
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog = this;
            this.m_securityPane = new WcmSecurityPanel((Window)((Object)this), wcmDlgPropertiesDialog.m_dlgItem.getSession(), perms, objType, this.m_bSecurityReadOnly);
            WcmDlgPropertiesDialog wcmDlgPropertiesDialog2 = this;
            this.m_securityPane.setSitePrefs(wcmDlgPropertiesDialog2.m_dlgItem.getSitePreferences());
            SecurityPanel.add((Component)this.m_securityPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 0, 10), 0, 0));
            this.m_tabbedPanel.add(WcmResourceString.s_security, SecurityPanel);
        }
        catch (Exception e) {
            System.out.println("Get exception in SecurityPanel. " + e.getMessage());
            System.out.println("Skip adding Security Tab.");
        }
    }

    private String getFolderNameProperty() throws WcmException {
        if (this.m_dlgItem == null) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedGetFolderNameProperty", "Failed to get Folder name property.");
        }
        return this.m_dlgItem.getFolderNameProperty();
    }

    private String getDocumentNameProperty() throws WcmException {
        if (this.m_dlgItem == null) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedGetDocumentNameProperty", "Failed to get Document name property.");
        }
        return this.m_dlgItem.getDocumentNameProperty();
    }

    private class WcmLCStateItem {
        private String m_label;
        private int m_action;

        public WcmLCStateItem(String label, int action) {
            this.m_label = label;
            this.m_action = action;
        }

        public String toString() {
            return this.m_label;
        }

        public int getAction() {
            return this.m_action;
        }
    }
}

