/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.toolkit.client.ui.WcmDlgIcons;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemIcon;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

class WcmDlgItemRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private DefaultListCellRenderer m_listRenderer = null;
    private WcmDlgItemIcon m_idmItemIcon = null;

    WcmDlgItemRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component renderer = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        this.updateRenderer(renderer, value);
        renderer.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        return renderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.m_listRenderer == null) {
            this.m_listRenderer = new DefaultListCellRenderer();
        }
        Component renderer = this.m_listRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.updateRenderer(renderer, value);
        return renderer;
    }

    private void updateRenderer(Component renderer, Object value) {
        if (renderer != null && value != null && value instanceof WcmDlgItemImpl) {
            WcmDlgItemImpl item = (WcmDlgItemImpl)value;
            ((JLabel)renderer).setText(item.getLabel());
            if (this.m_idmItemIcon == null) {
                this.m_idmItemIcon = new WcmDlgItemIcon();
            }
            this.m_idmItemIcon.setIcon(item.getIcon());
            if (item.getItemType() == 4) {
                this.m_idmItemIcon.setCheckedOutIcon(item.getCheckedOutIcon());
            } else {
                this.m_idmItemIcon.setCheckedOutIcon(WcmDlgIcons.getSmallTypIcon(12));
            }
            ((JLabel)renderer).setIcon(this.m_idmItemIcon);
        }
    }
}

