/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.BaseObjects;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Documents;
import com.filenet.wcm.api.Domain;
import com.filenet.wcm.api.Domains;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.ReadableMetadataObjects;
import com.filenet.wcm.api.Search;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmDlgIcons;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.WcmItemProperty;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WcmDlgItemImpl
implements WcmDlgItem {
    private static final String SRCHXML_DOCTYPE = "Document d";
    private static final String SRCHXML_FOLDERTYPE = "Folder d";
    private static final String SRCHXML_REQUEST_BEG = "<request>";
    private static final String SRCHXML_REQUEST_END = "</request>";
    private static final String SRCHXML_OBJSTORES_BEG = "<objectstores  mergeoption='union'>";
    private static final String SRCHXML_OBJSTORES_END = "</objectstores>";
    private static final String SRCHXML_QUERYSTATEMENT_BEG = "<querystatement tablealias=\"d\">";
    private static final String SRCHXML_QUERYSTATEMENT_END = "</querystatement>";
    public static final int DEFAULT_DOCUMENT_LIST_VIEW_MAX_RESULTS = 500;
    public static final int DEFAULT_FOLDER_LIST_VIEW_MAX_RESULTS = 500;
    public static final int DEFAULT_DETAILED_COLUMNS = 5;
    public static final int DEFAULT_VERSIONS_COLUMNS = 5;
    private static Session m_sess;
    private static WcmSitePrefs m_sitePrefs;
    private EntireNetwork m_networkObj;
    private WcmDlgItemImpl m_networkItem;
    private ReadableMetadataObject m_wcmObject;
    private int m_itemType = 0;
    private transient WcmDlgItemImpl m_parent;
    private String m_label;
    private boolean m_isReserved;
    private boolean m_isVersioningEnabled;
    private boolean m_isReservation;
    private boolean m_isDirectory;
    private boolean m_isRoot;
    private boolean m_isCompoundDocument;
    private WcmDlgItemImpl m_objectStore;
    private String m_objectStoreLabel;
    private ClassDescription m_classDescription;
    private String m_className;
    private String m_versionNumber;
    private String m_id;
    private String m_mimeType;
    private ImageIcon m_icon;
    private ImageIcon m_bigIcon;
    private Icon m_checkoutIcon;
    private String m_majorVersionNumber;
    private String m_minorVersionNumber;
    private String m_currentState;
    private VersionSeries m_versionSeries;
    private int m_lastSelectedRow = -1;
    private boolean m_dirty;
    private WcmDlgItemImpl[] m_contents;
    private int[] m_filterTypes;
    private PropertyDescriptions m_folderBasePropDescs;
    private PropertyDescriptions m_folderDetailPropDescs;
    private PropertyDescriptions m_folderDefaultDetailPropDescs;
    private PropertyDescriptions m_documentBasePropDescs;
    private PropertyDescriptions m_documentDetailPropDescs;
    private PropertyDescriptions m_documentDefaultDetailPropDescs;
    private PropertyDescriptions m_documentVersionsPropDescs;
    private PropertyDescriptions m_documentDefaultVersionsPropDescs;
    private String m_documentNamePropName;
    private String m_folderNamePropName;
    private String[] m_detailedNames;
    private String[] m_versionsNames;
    private String[] m_detailedValues;
    private String[] m_versionsValues;
    private boolean m_objectStoreIsDown;
    private String m_userName;
    private int m_currentStateIndex = 0;
    private String[] m_lifecycleStates;
    private int m_nVersionChoice = 0;
    private boolean m_assumeCheckout = false;

    public WcmDlgItemImpl(Session sess) {
        WcmDlgItemImpl.setSession(sess);
        this.m_networkObj = ObjectFactory.getEntireNetwork((Session)m_sess);
        this.m_label = WcmResourceString.s_theNetwork;
        this.m_isRoot = true;
        this.m_isDirectory = true;
        this.m_itemType = 1;
    }

    public WcmDlgItemImpl(Session sess, WcmSitePrefs sitePrefs) throws WcmException {
        WcmDlgItemImpl.setSession(sess);
        if (sitePrefs != null) {
            WcmDlgItemImpl.setSitePreferences(sitePrefs);
        }
        this.m_networkObj = ObjectFactory.getEntireNetwork((Session)m_sess);
        this.m_label = WcmResourceString.s_theNetwork;
        this.m_isRoot = true;
        this.m_isDirectory = true;
        this.m_itemType = 1;
    }

    public WcmDlgItemImpl(ReadableMetadataObject wo) throws WcmException {
        this.m_wcmObject = wo;
        int type = wo.getObjectType();
        try {
            switch (type) {
                case -101: 
                case -100: 
                case 1: 
                case 1160: {
                    this.init(4);
                    break;
                }
                case 15: {
                    this.init(5);
                    break;
                }
                case 2: {
                    this.init(3);
                    break;
                }
                default: {
                    System.out.println("WcmDlgItemImpl: unsupported type" + type);
                    throw new WcmException("client.WcmDlgItemImpl.unsupportedType", "Unsupported WcmObjectType encountered");
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItem.FailInitItem", "Fail to initialize item. Exception {0}.", (Object)e.getMessage());
        }
    }

    public WcmDlgItemImpl(ReadableMetadataObject wo, int type) throws WcmException {
        this.m_wcmObject = wo;
        try {
            this.init(type);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItem.FailInitItem", "Fail to initialize item. Exception {0}.", (Object)e.getMessage());
        }
    }

    public WcmDlgItemImpl(ReadableMetadataObject wo, int type, WcmDlgItemImpl parent) throws WcmException {
        this.m_wcmObject = wo;
        this.m_parent = parent;
        try {
            this.init(type);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItem.FailInitItem", "Fail to initialize item. Exception {0}.", (Object)e.getMessage());
        }
    }

    public void clearContents() {
        this.m_dirty = true;
        if (this.m_contents != null) {
            for (int i = 0; i < this.m_contents.length; ++i) {
                this.m_contents[i].clearContents();
                this.m_contents[i] = null;
            }
        }
        this.m_contents = null;
    }

    public void setDirty() {
        this.m_dirty = true;
    }

    public void clearDirty() {
        this.m_dirty = false;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void setObjectStoreDirty(String objStoreId) {
        if (this.m_itemType == 1 && this.m_contents != null) {
            for (int i = 0; i < this.m_contents.length; ++i) {
                if (!this.m_contents[i].getId().equalsIgnoreCase(objStoreId)) continue;
                this.m_contents[i].setDirty();
                break;
            }
        }
    }

    public WcmDlgItemImpl getRoot() throws WcmException {
        if (this.m_itemType == 1) {
            return this;
        }
        if (this.m_networkItem == null) {
            this.m_objectStore = (WcmDlgItemImpl)this.getObjectStore();
            if (this.m_objectStore != null) {
                this.m_networkItem = this.m_objectStore.getParent();
            }
        }
        return this.m_networkItem;
    }

    public String getCanonicalName() {
        String s = this.m_objectStoreLabel + ":" + Integer.toString(this.m_itemType) + ":" + this.m_label;
        return s;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    public ImageIcon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = this.itemIcon();
        }
        return this.m_icon;
    }

    public ImageIcon getBigIcon() {
        if (this.m_bigIcon == null) {
            this.m_bigIcon = this.itemBigIcon();
        }
        return this.m_bigIcon;
    }

    public Icon getCheckedOutIcon() {
        if (this.m_checkoutIcon != null) {
            return this.m_checkoutIcon;
        }
        if (this.isVersionItem()) {
            this.m_checkoutIcon = this.m_isReserved ? WcmDlgIcons.getSmallTypIcon(7) : this.getBlankIcon();
            return this.m_checkoutIcon;
        }
        try {
            this.m_checkoutIcon = this.m_majorVersionNumber.equalsIgnoreCase("0") ? WcmDlgIcons.getSmallTypIcon(10) : (this.m_wcmObject.getPropertyBooleanValue("IsCurrentVersion") ? (this.m_isReserved ? WcmDlgIcons.getSmallTypIcon(7) : this.getBlankIcon()) : WcmDlgIcons.getSmallTypIcon(11));
        }
        catch (Exception ex) {
            System.out.println("WcmDlgItemImpl: getCheckoutIcon exception " + ex.getMessage());
            return this.getBlankIcon();
        }
        return this.m_checkoutIcon;
    }

    public Icon getBlankIcon() {
        return WcmDlgIcons.getSmallTypIcon(12);
    }

    public int getVersionChoice() {
        return this.m_nVersionChoice;
    }

    public void setVersionChoice(int versionChoice) {
        this.m_nVersionChoice = versionChoice;
    }

    public WcmDlgItem[] list(int[] types) throws WcmException {
        try {
            if (this.m_dirty) {
                this.clearContents();
            }
            if (this.m_contents == null) {
                this.initContents(types);
            } else if (this.m_itemType != 1 && this.filterTypesChanged(types)) {
                this.clearContents();
                this.initContents(types);
            }
            this.m_dirty = false;
        }
        catch (WcmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItem.list", "Failed to get containees. Exception {0}.", (Object)e.getMessage());
        }
        return this.m_contents;
    }

    public boolean isDirectory() {
        return this.m_isDirectory;
    }

    public boolean isVirtualDirectory() {
        return this.m_isDirectory || this.m_isVersioningEnabled && this.m_parent.isDirectory();
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public boolean isReserved() {
        return this.m_isReserved;
    }

    public boolean isVersionItem() {
        if (this.m_parent == null) {
            return false;
        }
        return this.getItemType() == 4 && this.m_parent.getItemType() == 4;
    }

    public boolean getIsReservation() {
        return this.m_isReservation;
    }

    public ReadableMetadataObject getWcmObject() {
        return this.m_wcmObject;
    }

    public void setWcmObject(ReadableMetadataObject bsObj) {
        this.m_wcmObject = bsObj;
    }

    public String getLabel() {
        return this.m_label;
    }

    public WcmDlgItemImpl getParent() {
        return this.m_parent;
    }

    public int getItemType() {
        return this.m_itemType;
    }

    public WcmDlgItem getObjectStore() throws WcmException {
        if (this.m_objectStore == null) {
            if (this.m_itemType == 2) {
                return this;
            }
            WcmDlgItemImpl parent = this.m_parent;
            if (parent != null) {
                this.m_objectStore = (WcmDlgItemImpl)parent.getObjectStore();
                return this.m_objectStore;
            }
            if (WcmDlgItemImpl.getSession() != null) {
                WcmDlgItemImpl objStoreItem;
                String objStoreId = this.m_wcmObject.getObjectStoreId();
                ObjectStore objStoreObject = ObjectFactory.getObjectStore((String)objStoreId, (Session)m_sess);
                this.m_objectStore = objStoreItem = new WcmDlgItemImpl((ReadableMetadataObject)objStoreObject, 2);
                return this.m_objectStore;
            }
            if (parent == null) {
                System.out.println(" No ObjectStore item found for " + this.getLabel());
                throw new WcmException("client.WcmDlgItemImpl.ObjectStoreFindError", "Failed to locate ObjectStore");
            }
        }
        return this.m_objectStore;
    }

    public String getObjectStoreLabel() {
        if (this.m_objectStoreLabel == null) {
            if (this.m_itemType == 2) {
                this.m_objectStoreLabel = this.m_label;
                return this.m_objectStoreLabel;
            }
            for (WcmDlgItemImpl parent = this.m_parent; parent != null; parent = parent.getParent()) {
                if (parent.getItemType() != 2) continue;
                this.m_objectStoreLabel = parent.getLabel();
                return this.m_objectStoreLabel;
            }
        }
        return this.m_objectStoreLabel;
    }

    public ClassDescription getClassDescription() {
        return this.m_classDescription;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getId() {
        return this.m_id;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public WcmDlgItemImpl getLastContainee() {
        return this.m_contents[this.m_contents.length - 1];
    }

    public int getContaineeCount() {
        return this.m_contents.length;
    }

    public String getMajorVersionNumber() {
        return this.m_majorVersionNumber;
    }

    public String getMinorVersionNumber() {
        return this.m_minorVersionNumber;
    }

    public String getCurrentLifecycleState() {
        if (this.m_currentState == null || this.m_currentState.equalsIgnoreCase("")) {
            return null;
        }
        if (this.m_lifecycleStates == null) {
            this.m_lifecycleStates = ((Document)this.m_wcmObject).getLifeCycleStates();
        }
        if (this.m_lifecycleStates[this.m_currentStateIndex].equalsIgnoreCase(this.m_currentState)) {
            return this.m_currentState;
        }
        for (int i = 0; i < this.m_lifecycleStates.length; ++i) {
            if (!this.m_lifecycleStates[i].equalsIgnoreCase(this.m_currentState)) continue;
            this.m_currentStateIndex = i;
            break;
        }
        return this.m_currentState;
    }

    public String getLastLifecycleState() {
        if (this.getCurrentLifecycleState() == null) {
            return null;
        }
        if (this.m_currentStateIndex <= 0) {
            return null;
        }
        return this.m_lifecycleStates[this.m_currentStateIndex - 1];
    }

    public String getNextLifecycleState() {
        if (this.getCurrentLifecycleState() == null) {
            return null;
        }
        if (this.m_currentStateIndex >= this.m_lifecycleStates.length - 1) {
            return null;
        }
        return this.m_lifecycleStates[this.m_currentStateIndex + 1];
    }

    public VersionSeries getVersionSeries() {
        return this.m_versionSeries;
    }

    public boolean canCheckout() {
        if (this.m_itemType != 4) {
            return false;
        }
        try {
            if (((Document)this.m_wcmObject).getPropertyBooleanValue("IsCurrentVersion")) {
                Document resvDoc;
                if (this.m_isReserved && (resvDoc = ((Document)this.m_wcmObject).getReservation()).getPropertyIntValue("ReservationType") == 32) {
                    String resvOwner = resvDoc.getPropertyStringValue("Creator");
                    if (WcmString.compareIgnoreCase(this.getUserName(), resvOwner) == 0) {
                        this.m_assumeCheckout = true;
                        return true;
                    }
                }
                return !this.m_isReserved;
            }
            if (!this.isVersionItem()) {
                Document curDoc = this.m_versionSeries.getCurrentVersion();
                return !this.isCheckedout(curDoc);
            }
            return false;
        }
        catch (Exception ex) {
            this.m_parent.setDirty();
            return false;
        }
    }

    public int getLastSelectedRow() {
        return this.m_lastSelectedRow;
    }

    public void setLastSelectedRow(int nIndex) {
        this.m_lastSelectedRow = nIndex;
    }

    public String getPathname() {
        WcmDlgItemImpl parent;
        String str = this.getLabel();
        if (this.getItemType() == 2) {
            return str + ":\\";
        }
        for (parent = this.getParent(); parent != null && parent.getItemType() != 2; parent = parent.getParent()) {
            str = parent.getLabel() + "\\" + str;
        }
        if (parent.getItemType() == 2) {
            str = parent.getLabel() + ":\\" + str;
        }
        return str;
    }

    public String getPathnameWithoutOS() {
        StringBuffer buff = new StringBuffer();
        WcmDlgItemImpl dlgItem = this;
        while (dlgItem.getItemType() != 2) {
            buff.insert(0, "\\" + dlgItem.getLabel());
            dlgItem = dlgItem.getParent();
        }
        return buff.toString();
    }

    public String getContainmentPath() {
        String str = "";
        WcmDlgItemImpl parent = this.getParent();
        if (parent != null) {
            str = parent.getLabel();
            parent = parent.getParent();
        }
        while (parent != null && !parent.isRoot()) {
            str = parent.getLabel() + "/" + str;
            parent = parent.getParent();
        }
        return str;
    }

    public PropertyDescriptions getFolderBasePropDescs() {
        return this.m_folderBasePropDescs;
    }

    public PropertyDescriptions getFolderDetailPropDescs() {
        return this.m_folderDetailPropDescs;
    }

    public PropertyDescriptions getFolderDefaultDetailPropDescs() {
        return this.m_folderDefaultDetailPropDescs;
    }

    public PropertyDescriptions getDocumentBasePropDescs() {
        return this.m_documentBasePropDescs;
    }

    public PropertyDescriptions getDocumentDetailPropDescs() {
        return this.m_documentDetailPropDescs;
    }

    public PropertyDescriptions getDocumentVersionsPropDescs() {
        return this.m_documentVersionsPropDescs;
    }

    public PropertyDescriptions getDocumentDefaultDetailPropDescs() {
        return this.m_documentDefaultDetailPropDescs;
    }

    public PropertyDescriptions getDocumentDefaultVersionsPropDescs() {
        return this.m_documentDefaultVersionsPropDescs;
    }

    public String getFolderNamePropName() {
        return this.m_folderNamePropName;
    }

    public String getDocumentNamePropName() {
        return this.m_documentNamePropName;
    }

    public String[] getDetailedNames() {
        return this.m_detailedNames;
    }

    public String[] getVersionsNames() {
        return this.m_versionsNames;
    }

    public String[] getDetailedValues() {
        return this.m_detailedValues;
    }

    public String[] getVersionsValues() {
        return this.m_versionsValues;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public void setClassDescription(ClassDescription cd) {
        this.m_classDescription = cd;
    }

    public void setIsReserved(boolean isReserved) {
        this.m_isReserved = isReserved;
    }

    public void setMimeType(String mimeType) {
        this.m_mimeType = mimeType;
    }

    public void setVersionSeries(VersionSeries vs) {
        this.m_versionSeries = vs;
    }

    public void setIsReservation(boolean isReservation) {
        this.m_isReservation = isReservation;
    }

    public void setIsCompoundDocument(boolean isCompound) {
        this.m_isCompoundDocument = isCompound;
    }

    public void setCurrentLifecycleState(String currentState) {
        this.m_currentState = currentState;
    }

    public void setMajorVersionNumber(String majorVersionNumber) {
        this.m_majorVersionNumber = majorVersionNumber;
    }

    public void setMinorVersionNumber(String minorVersionNumber) {
        this.m_minorVersionNumber = minorVersionNumber;
    }

    public void setDetailedValues(String[] detailedValues) {
        this.m_detailedValues = detailedValues;
    }

    public void setVersionsValues(String[] versionsValues) {
        this.m_versionsValues = versionsValues;
    }

    public void appendChild(WcmDlgItemImpl child, int[] filterTypes) {
        if (this.m_contents == null) {
            this.m_contents = new WcmDlgItemImpl[1];
            this.m_contents[0] = child;
            this.m_filterTypes = filterTypes;
        } else {
            WcmDlgItemImpl[] newContents = new WcmDlgItemImpl[this.m_contents.length + 1];
            if (this.m_contents.length > 0) {
                System.arraycopy(this.m_contents, 0, newContents, 0, this.m_contents.length);
            }
            newContents[this.m_contents.length] = child;
            this.m_contents = newContents;
        }
    }

    public WcmDlgItem getChildById(String Id) throws WcmException {
        if (this.m_contents == null) {
            int[] types = new int[]{1, 2};
            this.initContents(types);
        }
        if (this.m_contents != null) {
            for (int i = 0; i < this.m_contents.length; ++i) {
                if (!this.m_contents[i].getId().equalsIgnoreCase(Id)) continue;
                return this.m_contents[i];
            }
        }
        return null;
    }

    public boolean hasContents() {
        return this.m_contents != null;
    }

    public boolean getObjectStoreIsDown() {
        return this.m_objectStoreIsDown;
    }

    public void setObjectStoreIsDown() {
        this.m_objectStoreIsDown = true;
        this.m_icon = this.itemIcon();
    }

    public WcmDlgItemImpl[] getContents() {
        return this.m_contents;
    }

    public void refreshItem() throws WcmException {
        if (this.m_itemType != 4) {
            return;
        }
        this.clearContents();
        try {
            this.m_wcmObject.refresh();
        }
        catch (ClassCastException c) {
            // empty catch block
        }
        try {
            this.init(this.m_itemType);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItem.FailInitItem", "Fail to initialize item. Exception {0}.", (Object)e.getMessage());
        }
    }

    public boolean refreshVersionState() {
        boolean stateChanged = false;
        try {
            if (this.m_itemType != 4) {
                return stateChanged;
            }
            boolean old_isReserved = this.m_isReserved;
            try {
                this.m_wcmObject.refresh();
            }
            catch (ClassCastException c) {
                // empty catch block
            }
            this.m_isReserved = ((Document)this.m_wcmObject).getPropertyBooleanValue("IsReserved");
            if (old_isReserved != this.m_isReserved) {
                stateChanged = true;
                this.m_dirty = true;
                if (!this.m_isReserved) {
                    Document newObj = ((Document)this.m_wcmObject).getVersionSeries().getCurrentVersion();
                    if (this.m_parent != null && this.m_parent.getItemType() == 4) {
                        this.m_parent.setWcmObject((ReadableMetadataObject)newObj);
                        this.m_parent.refreshItem();
                    } else {
                        this.m_wcmObject = newObj;
                        this.refreshItem();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("[Internal Error]Failed to refresh property - " + e.getMessage());
        }
        return stateChanged;
    }

    public static synchronized void setSession(Session sess) {
        m_sess = sess;
    }

    public static synchronized Session getSession() {
        return m_sess;
    }

    public static synchronized void setSitePreferences(WcmSitePrefs sitePrefs) {
        m_sitePrefs = sitePrefs;
    }

    public static synchronized WcmSitePrefs getSitePreferences() {
        return m_sitePrefs;
    }

    public String getUserName() {
        if (this.m_userName == null && m_sess != null) {
            User user = m_sess.verify();
            try {
                if (user != null) {
                    this.m_userName = user.getPropertyStringValue("ShortName");
                }
            }
            catch (Exception e) {
                System.out.println("Error in WcmDlgItemImpl::getUserName(): " + e.getMessage());
            }
            if (this.m_userName == null || this.m_userName.length() == 0) {
                String sToken = m_sess.getToken();
                HashMap oTokenMap = m_sess.fromToken(sToken);
                this.m_userName = (String)oTokenMap.get("userid");
            }
        }
        return this.m_userName;
    }

    public String getUserDisplayName() {
        if (this.m_userName == null && m_sess != null) {
            User user = m_sess.verify();
            try {
                if (user != null) {
                    this.m_userName = user.getName();
                }
            }
            catch (Exception e) {
                System.out.println("Error in WcmDlgItemImpl::getUserDisplayName(): " + e.getMessage());
            }
            if (this.m_userName == null || this.m_userName.length() == 0) {
                String sToken = m_sess.getToken();
                HashMap oTokenMap = m_sess.fromToken(sToken);
                this.m_userName = (String)oTokenMap.get("userid");
            }
        }
        return this.m_userName;
    }

    public void initObjectStores(ObjectStores objStores) throws Exception {
        if (this.m_itemType != 1) {
            throw new WcmException("client.WcmDlgItem.ObjectMustBeNetworkItem", "Object must be network item.");
        }
        if (objStores == null || objStores.size() <= 0) {
            return;
        }
        objStores = PropertyUtil.sort(objStores);
        int size = objStores.size();
        Vector<WcmDlgItemImpl> objStoreItems = new Vector<WcmDlgItemImpl>();
        for (int i = 0; i < size; ++i) {
            try {
                WcmDlgItemImpl objStoreItem = new WcmDlgItemImpl((ReadableMetadataObject)((ObjectStore)objStores.get(i)), 2, this);
                objStoreItems.add(objStoreItem);
                continue;
            }
            catch (WcmException e) {
                // empty catch block
            }
        }
        this.m_contents = new WcmDlgItemImpl[objStoreItems.size()];
        this.m_contents = objStoreItems.toArray(this.m_contents);
    }

    public EntireNetwork getEntireNetworkObject() {
        return this.m_networkObj;
    }

    public String getDocumentNameProperty() {
        String nameProp = "DocumentTitle";
        try {
            if (m_sitePrefs != null) {
                nameProp = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getDocumentNameProperty();
            }
        }
        catch (Exception ex) {
            System.out.print("Got exception from sitePref - getDocumentNameProperty().  Use 'Document Title'.");
        }
        return nameProp;
    }

    public String getFolderNameProperty() {
        String nameProp = "FolderName";
        try {
            if (m_sitePrefs != null) {
                nameProp = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getFolderNameProperty();
            }
        }
        catch (Exception ex) {
            System.out.print("Got exception from sitePref - getFolderNameProperty().  Use 'FOLDER'.");
            ex.printStackTrace();
        }
        return nameProp;
    }

    public String getCustomObjectNameProperty() {
        String nameProp = "Id";
        try {
            if (m_sitePrefs != null) {
                nameProp = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getCustomObjectNameProperty();
            }
        }
        catch (Exception ex) {
            System.out.print("Got exception from sitePref - getCustomObjectNameProperty().  Use 'ID'.");
            ex.printStackTrace();
        }
        return nameProp;
    }

    public boolean isAssumeCheckout() {
        return this.m_assumeCheckout;
    }

    private void init(int type) throws WcmException, PropertyNotFoundException {
        this.m_itemType = type;
        switch (type) {
            case 2: {
                this.m_isRoot = false;
                this.m_isDirectory = true;
                this.m_id = this.m_wcmObject.getId();
                WcmItemProperty.setObjStoreItemProperty(this);
                this.createFolderPropDescs();
                this.createDocumentPropDescs();
                break;
            }
            case 3: {
                this.m_isRoot = false;
                this.m_isDirectory = true;
                this.m_id = this.m_wcmObject.getId();
                WcmItemProperty.setFolderItemProperty(this, (WcmDlgItemImpl)this.getObjectStore());
                break;
            }
            case 4: {
                this.m_isRoot = false;
                this.m_isDirectory = false;
                this.m_id = this.m_wcmObject.getId();
                WcmItemProperty.setDocItemProperty(this, (WcmDlgItemImpl)this.getObjectStore());
                if (this.m_parent == null || this.m_parent.isDirectory()) break;
                WcmItemProperty.setVersionItemProperty(this, (WcmDlgItemImpl)this.getObjectStore());
                break;
            }
            case 5: {
                this.m_isRoot = false;
                this.m_isDirectory = false;
                this.m_id = this.m_wcmObject.getId();
                WcmItemProperty.setCustomObjProperty(this, (WcmDlgItemImpl)this.getObjectStore());
                break;
            }
            default: {
                System.out.println("Error! Unsupported item type " + type);
                throw new WcmException("client.WcmDlgItemImpl.UnsupportedItemType", "Unsupported Item Type");
            }
        }
    }

    private void initContents(int[] filterTypes) throws WcmException {
        try {
            if (filterTypes == null) {
                filterTypes = new int[]{};
            }
            int[] localTypes = (int[])filterTypes.clone();
            this.setDirty();
            int size = 0;
            boolean j = false;
            switch (this.m_itemType) {
                case 1: {
                    ObjectStores oss = null;
                    Domains domains = this.m_networkObj.getDomains();
                    if (domains.size() > 0) {
                        Domain curDomain = (Domain)domains.get(0);
                        oss = curDomain.getObjectStores();
                    }
                    this.initObjectStores(oss);
                    break;
                }
                case 2: {
                    BaseObjects objs;
                    Folder fldr = null;
                    try {
                        fldr = ((ObjectStore)this.m_wcmObject).getRootFolder();
                    }
                    catch (Exception ex) {
                        throw new WcmException("client.WcmDlgItemImpl.NoObjOrPermissionsError", "Object not found or permissions error.  Exception message: {0}", (Object)ex.getMessage());
                    }
                    if (fldr == null) {
                        return;
                    }
                    try {
                        objs = this.SearchContainees(this.normalizeType(localTypes), fldr);
                    }
                    catch (Exception ex) {
                        int asMask = 0;
                        try {
                            asMask = fldr.getAccessMask();
                        }
                        catch (Exception ex1) {
                            throw new WcmException("client.WcmDlgItemImpl.PermissionsError", "Permissions Error");
                        }
                        if ((asMask & 0x80) == 0) {
                            throw new WcmException("client.WcmDlgItemImpl.InsufficientPermissions", "Insufficient Permissions");
                        }
                        throw ex;
                    }
                    if (objs == null || objs.size() <= 0) {
                        return;
                    }
                    size = objs.size();
                    Vector<WcmDlgItemImpl> folderItems = new Vector<WcmDlgItemImpl>();
                    for (int i = 0; i < size; ++i) {
                        WcmDlgItemImpl item;
                        if (objs.get(i) instanceof Folder) {
                            item = new WcmDlgItemImpl((ReadableMetadataObject)((Folder)objs.get(i)), 3, this);
                            folderItems.add(item);
                            continue;
                        }
                        if (!(objs.get(i) instanceof StoredSearch)) continue;
                        item = new WcmDlgItemImpl((ReadableMetadataObject)objs.get(i), 4, this);
                        folderItems.add(item);
                    }
                    this.m_contents = new WcmDlgItemImpl[folderItems.size()];
                    this.m_contents = folderItems.toArray(this.m_contents);
                    break;
                }
                case 3: {
                    BaseObjects objs = this.SearchContainees(this.normalizeType(localTypes), (Folder)this.m_wcmObject);
                    if (objs == null || objs.size() <= 0) {
                        return;
                    }
                    size = objs.size();
                    ReadableMetadataObjects RMDObjs = (ReadableMetadataObjects)objs;
                    RMDObjs.orderByProperty("Name");
                    objs = RMDObjs;
                    this.m_contents = new WcmDlgItemImpl[size];
                    for (int i = 0; i < size; ++i) {
                        if (objs.get(i) instanceof Folder) {
                            this.m_contents[i] = new WcmDlgItemImpl((ReadableMetadataObject)((Folder)objs.get(i)), 3, this);
                            continue;
                        }
                        if (objs.get(i) instanceof CustomObject) {
                            this.m_contents[i] = new WcmDlgItemImpl((ReadableMetadataObject)objs.get(i), 5, this);
                            continue;
                        }
                        if (objs.get(i) instanceof ReadableMetadataObject) {
                            this.m_contents[i] = new WcmDlgItemImpl((ReadableMetadataObject)objs.get(i), 4, this);
                            continue;
                        }
                        System.out.println("Unknown objects from Folder.containees()!!");
                        throw new WcmException("client.WcmDlgItemImpl.UnsupportedItemType", "Unsupported Item Type");
                    }
                    break;
                }
                case 4: {
                    Documents objs = ((Document)this.m_wcmObject).getVersions();
                    if (objs == null || objs.size() <= 0) {
                        return;
                    }
                    size = objs.size();
                    Vector<WcmDlgItemImpl> items = new Vector<WcmDlgItemImpl>();
                    for (int i = 0; i < size; ++i) {
                        WcmDlgItemImpl item = new WcmDlgItemImpl((ReadableMetadataObject)objs.get(i), 4, this);
                        if (item.getIsReservation()) continue;
                        items.add(item);
                    }
                    this.m_contents = new WcmDlgItemImpl[items.size()];
                    this.m_contents = items.toArray(this.m_contents);
                    break;
                }
                default: {
                    System.out.println("Invalid WcmDlgItem type " + this.m_itemType);
                    throw new WcmException("client.WcmDlgItemImpl.UnsupportedItemType", "Unsupported Item Type");
                }
            }
            this.clearDirty();
            this.m_filterTypes = filterTypes;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmDlgItemImpl.InitContentsException", "Failed to get contents from {0} due to - {1}.", (Object)this.m_label, (Object)e.getMessage());
        }
    }

    private BaseObjects SearchContainees(int[] types, Folder fldr) {
        BaseObjects retBaseObj = null;
        String strObjLabel = this.getObjectStoreLabel();
        if (m_sess != null) {
            Search mySearch = ObjectFactory.getSearch((Session)m_sess);
            for (int i = 0; i < types.length; ++i) {
                String strSearchXML = this.constructSingleObjectTypeSearchXMLString(types[i], fldr.getId(), strObjLabel);
                BaseObjects baseObj = null;
                if (types[i] == 2) {
                    baseObj = mySearch.singleObjectTypeExecute(strSearchXML, 2);
                } else if (types[i] == -101 || types[i] == -100 || types[i] == 1160 || types[i] == 1 || types[i] == 15) {
                    baseObj = mySearch.singleObjectTypeExecute(strSearchXML, 1);
                }
                if (baseObj == null) continue;
                if (retBaseObj == null) {
                    retBaseObj = baseObj;
                    continue;
                }
                retBaseObj.addAll((Collection)baseObj);
            }
        }
        return retBaseObj;
    }

    private String constructSingleObjectTypeSearchXMLString(int type, String fldrId, String objectStoreName) {
        String strObjectType = SRCHXML_DOCTYPE;
        strObjectType = type == 2 ? SRCHXML_FOLDERTYPE : SRCHXML_DOCTYPE;
        StringBuffer sbfXML = new StringBuffer(256);
        sbfXML.append(SRCHXML_REQUEST_BEG);
        sbfXML.append(SRCHXML_OBJSTORES_BEG);
        sbfXML.append("<objectstore id=").append("'").append(objectStoreName).append("'/>");
        sbfXML.append(SRCHXML_OBJSTORES_END);
        sbfXML.append(SRCHXML_QUERYSTATEMENT_BEG);
        sbfXML.append("SELECT d.Id, ");
        String nameProp = type == 2 ? this.getFolderNameProperty() : (type == 15 ? this.getCustomObjectNameProperty() : this.getDocumentNameProperty());
        sbfXML.append(nameProp).append(" FROM ").append(strObjectType).append(" Where d.This INFOLDER '").append(fldrId).append("'");
        if (type == -101) {
            sbfXML.append(" AND IsClass(d, PublishTemplate)");
        } else if (type == -100) {
            sbfXML.append(" AND IsClass(d, StoredSearch)");
        } else if (type == 1160) {
            sbfXML.append(" AND IsClass(d, WorkflowDefinition)");
        } else if (type == 2) {
            sbfXML.append(" AND d.IsHiddenContainer = false");
        } else if (type == 15) {
            sbfXML.append(" AND IsClass(d, CustomObject)");
        }
        sbfXML.append(" ORDER BY ").append(nameProp);
        sbfXML.append(SRCHXML_QUERYSTATEMENT_END);
        int nPreferListSize = type == 2 ? WcmDlgItemImpl.getSitePreferenceFolderMaxSize() : WcmDlgItemImpl.getSitePreferenceDocumentMaxSize();
        sbfXML.append("<options maxrecords='").append(++nPreferListSize).append("' cursorlocation='client' objectasid='false'/>");
        sbfXML.append(SRCHXML_REQUEST_END);
        String strXML = sbfXML.toString();
        return strXML;
    }

    public static int getSitePreferenceDocumentMaxSize() {
        int nPreferListSize = 0;
        try {
            if (m_sitePrefs != null) {
                nPreferListSize = m_sitePrefs.getFilterDocumentMaxResults();
            }
        }
        catch (Exception ex) {
            System.out.print("Got exception from sitePref - getFilterDocumentMaxResults();.  Use 'DEFAULT_DOCUMENT_LIST_VIEW_MAX_RESULTS'.");
            ex.printStackTrace();
            nPreferListSize = 500;
        }
        if (nPreferListSize <= 0) {
            nPreferListSize = 500;
        }
        return nPreferListSize;
    }

    public static int getSitePreferenceFolderMaxSize() {
        int nPreferListSize = 0;
        try {
            if (m_sitePrefs != null) {
                nPreferListSize = m_sitePrefs.getFilterFolderMaxResults();
            }
        }
        catch (Exception ex) {
            System.out.print("Got exception from sitePref - getFilterFolderMaxResults();.  Use 'DEFAULT_FOLDER_LIST_VIEW_MAX_RESULTS'.");
            ex.printStackTrace();
            nPreferListSize = 500;
        }
        if (nPreferListSize <= 0) {
            nPreferListSize = 500;
        }
        return nPreferListSize;
    }

    private ImageIcon itemIcon() {
        switch (this.m_itemType) {
            case 4: {
                return WcmDlgIcons.getSmallDocIcon(this.m_mimeType, this.m_isCompoundDocument);
            }
            case 2: {
                if (this.m_objectStoreIsDown) {
                    return WcmDlgIcons.getSmallTypIcon(6);
                }
                return WcmDlgIcons.getSmallTypIcon(this.m_itemType);
            }
        }
        return WcmDlgIcons.getSmallTypIcon(this.m_itemType);
    }

    private ImageIcon itemBigIcon() {
        if (this.m_itemType != 4) {
            return WcmDlgIcons.getBigTypIcon(this.m_itemType);
        }
        return WcmDlgIcons.getBigDocIcon(this.m_mimeType);
    }

    private int[] normalizeType(int[] origTypes) {
        boolean bHasFolderType = false;
        boolean bHasDocumentType = false;
        int nDocumentSubType = 0;
        for (int i = 0; i < origTypes.length; ++i) {
            if (origTypes[i] == 2) {
                bHasFolderType = true;
                continue;
            }
            if (origTypes[i] == 1) {
                bHasDocumentType = true;
                continue;
            }
            if (origTypes[i] != -101 && origTypes[i] != -100 && origTypes[i] != 1160) continue;
            ++nDocumentSubType;
        }
        int nNewTypeLen = origTypes.length;
        if (!bHasFolderType) {
            ++nNewTypeLen;
        }
        if (bHasDocumentType) {
            nNewTypeLen -= nDocumentSubType;
        }
        int[] types = new int[nNewTypeLen];
        int nNewIdx = 0;
        for (int nOrigIdx = 0; nOrigIdx < origTypes.length; ++nOrigIdx) {
            if (bHasDocumentType && (origTypes[nOrigIdx] == -101 || origTypes[nOrigIdx] == -100 || origTypes[nOrigIdx] == 1160)) continue;
            types[nNewIdx++] = origTypes[nOrigIdx];
        }
        if (!bHasFolderType) {
            types[nNewIdx] = 2;
        }
        return types;
    }

    private void createFolderPropDescs() {
        this.m_folderBasePropDescs = this.createBaseFolderPropDescs();
        this.m_folderDefaultDetailPropDescs = this.createDefaultDetailFolderPropDescs();
        Vector<String> detailedNameList = new Vector<String>();
        try {
            if (m_sitePrefs != null) {
                String[] detailedNames = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getDetailedProps();
                for (int i = 0; i < detailedNames.length; ++i) {
                    if (detailedNames[i].equalsIgnoreCase("ContentSize") || detailedNames[i].equalsIgnoreCase("MajorVersionNumber") || detailedNameList.contains(detailedNames[i])) continue;
                    detailedNameList.add(detailedNames[i]);
                }
                this.m_folderNamePropName = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getFolderNameProperty();
                String[] newPropNames = new String[detailedNameList.size()];
                newPropNames = detailedNameList.toArray(newPropNames);
                this.m_folderDetailPropDescs = ObjectFactory.getPropertyDescriptions((String[])newPropNames);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_folderDetailPropDescs = this.createDefaultDetailFolderPropDescs();
        this.m_folderNamePropName = "FolderName";
    }

    private void createDocumentPropDescs() {
        this.m_documentBasePropDescs = this.createBaseDocumentPropDescs();
        this.m_documentDefaultDetailPropDescs = this.createDefaultDetailDocumentPropDescs();
        this.m_documentDefaultVersionsPropDescs = this.createDefaultVersionsDocumentPropDescs();
        Vector<String> detailedNameList = new Vector<String>();
        Vector<String> versionsNameList = new Vector<String>();
        try {
            if (m_sitePrefs != null) {
                int i;
                this.m_detailedNames = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getDetailedProps();
                this.m_versionsNames = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getVersionProps();
                for (i = 0; i < this.m_detailedNames.length; ++i) {
                    if (detailedNameList.contains(this.m_detailedNames[i])) continue;
                    detailedNameList.add(this.m_detailedNames[i]);
                }
                for (i = 0; i < this.m_versionsNames.length; ++i) {
                    if (versionsNameList.contains(this.m_versionsNames[i])) continue;
                    versionsNameList.add(this.m_versionsNames[i]);
                }
                this.m_documentNamePropName = m_sitePrefs.getObjectStorePrefs(this.getObjectStoreLabel()).getDocumentNameProperty();
                String[] tempNames = new String[detailedNameList.size()];
                tempNames = detailedNameList.toArray(tempNames);
                this.m_documentDetailPropDescs = ObjectFactory.getPropertyDescriptions((String[])tempNames);
                tempNames = new String[versionsNameList.size()];
                tempNames = versionsNameList.toArray(tempNames);
                this.m_documentVersionsPropDescs = ObjectFactory.getPropertyDescriptions((String[])tempNames);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_documentDetailPropDescs = this.createDefaultDetailDocumentPropDescs();
        this.m_documentVersionsPropDescs = this.createDefaultVersionsDocumentPropDescs();
        this.m_documentNamePropName = "DocumentTitle";
        this.m_detailedNames = new String[]{"ContentSize", "Creator", "LastModifier", "DateLastModified", "MajorVersionNumber"};
        this.m_versionsNames = new String[]{"VersionStatus", "MajorVersionNumber", "MinorVersionNumber", "LastModifier", "DateLastModified"};
    }

    private PropertyDescriptions createBaseFolderPropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"ClassDescription"});
    }

    private PropertyDescriptions createDefaultDetailFolderPropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"Creator", "LastModifier", "DateLastModified"});
    }

    private PropertyDescriptions createBaseDocumentPropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"ClassDescription", "MimeType", "IsReserved", "CurrentState", "CompoundDocumentState", "VersionSeries", "VersionStatus", "MajorVersionNumber", "MinorVersionNumber"});
    }

    private PropertyDescriptions createDefaultDetailDocumentPropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"ContentSize", "Creator", "LastModifier", "DateLastModified", "MajorVersionNumber"});
    }

    private PropertyDescriptions createDefaultVersionsDocumentPropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"VersionStatus", "MajorVersionNumber", "MinorVersionNumber", "LastModifier", "DateLastModified"});
    }

    private boolean filterTypesChanged(int[] types) {
        if (this.m_filterTypes == null) {
            this.m_filterTypes = types;
            return false;
        }
        int[] newTypes = types;
        int[] oldTypes = this.m_filterTypes;
        for (int i = 0; i < newTypes.length; ++i) {
            boolean found = false;
            for (int j = 0; j < oldTypes.length; ++j) {
                if (newTypes[i] != oldTypes[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private boolean isCheckedout(Document curDoc) {
        boolean checkedout = false;
        try {
            if (this.m_majorVersionNumber.equalsIgnoreCase("0")) {
                if (curDoc.getPropertyBooleanValue("IsReserved")) {
                    this.m_checkoutIcon = WcmDlgIcons.getSmallTypIcon(8);
                    checkedout = true;
                } else {
                    this.m_checkoutIcon = WcmDlgIcons.getSmallTypIcon(10);
                }
            } else if (this.m_wcmObject.getPropertyBooleanValue("IsCurrentVersion")) {
                if (this.m_isReserved) {
                    this.m_checkoutIcon = WcmDlgIcons.getSmallTypIcon(7);
                    checkedout = true;
                } else {
                    this.m_checkoutIcon = this.getBlankIcon();
                }
            } else if (curDoc.getPropertyBooleanValue("IsReserved")) {
                this.m_checkoutIcon = WcmDlgIcons.getSmallTypIcon(9);
                checkedout = true;
            } else {
                this.m_checkoutIcon = WcmDlgIcons.getSmallTypIcon(11);
            }
        }
        catch (Exception ex) {
            System.out.println("WcmDlgItemImpl: getCheckoutIcon exception " + ex.getMessage());
        }
        return checkedout;
    }
}

