/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemChooserDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;

public class WcmDlgItemChooser
implements WcmDlg {
    private int m_browseMode = 1;
    private WcmDlgItemImpl m_initialDirectory;
    private String m_onlyThisObjectStore;
    private String m_buttonText;
    private String m_buttonMnemonic;
    private String m_buttonTooltipText;
    private String m_dialogTitle;
    private WcmDlgItemImpl m_selectedItem;
    private int m_nFileMode = 0;
    private Exception m_creationException;
    private int[] m_filterTypes;
    private String m_filterClass;
    private ObjectStores m_visibleObjStores;
    private boolean m_rootFolderSelectable;
    private boolean m_showVersionChoice;

    public WcmDlgItemChooser(WcmDlgItem scopeItem, WcmDlgItem contextItem, int[] types) throws WcmException {
        this.m_filterTypes = types;
        if (contextItem != null && contextItem.getParent() != null) {
            contextItem.getParent().setDirty();
            contextItem.getParent().refreshItem();
        }
        this.init((WcmDlgItemImpl)contextItem, (WcmDlgItemImpl)scopeItem);
    }

    public WcmDlgItem getSelectedItem() {
        return this.m_selectedItem;
    }

    public int getSelectedMode() {
        return this.m_nFileMode;
    }

    public void setBrowseMode(int mode) {
        this.m_browseMode = mode;
    }

    public void setMimeType(String mimeType) {
    }

    public void setVisibleObjectStores(ObjectStores objStores) throws WcmException {
        boolean found = false;
        if (this.m_initialDirectory != null && this.m_initialDirectory.getItemType() != 1) {
            for (ObjectStore visibleObjStore : objStores) {
                if (this.m_initialDirectory.getObjectStore().getId().compareToIgnoreCase(visibleObjStore.getId()) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                this.m_initialDirectory = this.m_initialDirectory.getRoot();
                this.m_selectedItem = null;
            }
        }
        this.m_visibleObjStores = objStores;
    }

    public int showDialog(Container parent) throws WcmException {
        WcmDlgItemChooserDialog itemChooserDialog = null;
        int nResult = -1;
        try {
            if (this.m_creationException != null) {
                return nResult;
            }
            itemChooserDialog = parent instanceof Frame ? new WcmDlgItemChooserDialog((Frame)parent, (WcmDlgItem)this.m_initialDirectory, this.m_buttonText, this.m_buttonMnemonic, this.m_buttonTooltipText, this.m_filterTypes, this.m_browseMode, this.m_onlyThisObjectStore, this.m_visibleObjStores, this.m_showVersionChoice) : (parent instanceof Dialog ? new WcmDlgItemChooserDialog((Dialog)parent, (WcmDlgItem)this.m_initialDirectory, this.m_buttonText, this.m_buttonMnemonic, this.m_buttonTooltipText, this.m_filterTypes, this.m_browseMode, this.m_onlyThisObjectStore, this.m_visibleObjStores, this.m_showVersionChoice) : new WcmDlgItemChooserDialog((Frame)null, (WcmDlgItem)this.m_initialDirectory, this.m_buttonText, this.m_buttonMnemonic, this.m_buttonTooltipText, this.m_filterTypes, this.m_browseMode, this.m_onlyThisObjectStore, this.m_visibleObjStores, this.m_showVersionChoice));
            if (this.m_dialogTitle != null) {
                itemChooserDialog.setTitle(this.m_dialogTitle);
            }
            itemChooserDialog.setFilterClass(this.m_filterClass);
            itemChooserDialog.setRootFolderSelectable(this.m_rootFolderSelectable);
            itemChooserDialog.setPreSelectedItem(this.m_initialDirectory);
            nResult = itemChooserDialog.showDialog(parent);
            this.m_selectedItem = (WcmDlgItemImpl)itemChooserDialog.getSelectedItem();
            this.m_nFileMode = itemChooserDialog.getSelectedMode();
            itemChooserDialog = null;
        }
        catch (Exception ex) {
            parent.setEnabled(true);
            System.out.println("WcmDlgItemChooser " + ex.toString());
            throw new WcmException("client.WcmDlgItemChooser.CreateDialogError", "Error creating the dialog.");
        }
        return nResult;
    }

    public void setTitle(String title) {
        this.m_dialogTitle = title;
    }

    public void setButtonText(String buttonText) {
        this.m_buttonText = buttonText;
    }

    public void setButtonMnemonic(String MnemoicText) {
        this.m_buttonMnemonic = MnemoicText;
    }

    public void setButtonTooltip(String tooltipText) {
        this.m_buttonTooltipText = tooltipText;
    }

    public void setFilterClass(String filterClass) {
        this.m_filterClass = filterClass;
    }

    public void setRootFolderSelectable(boolean selectable) {
        this.m_rootFolderSelectable = selectable;
    }

    public void setShowVersionChoice(boolean show) {
        this.m_showVersionChoice = show;
    }

    private void init(WcmDlgItemImpl contextItem, WcmDlgItemImpl scopeItem) {
        try {
            if (scopeItem != null && scopeItem.getItemType() == 2) {
                this.m_onlyThisObjectStore = scopeItem.getObjectStoreLabel();
            }
            if (this.m_onlyThisObjectStore != null) {
                if (contextItem == null || contextItem.getItemType() == 1) {
                    contextItem = scopeItem;
                } else {
                    String initialObjStoreName = contextItem.getObjectStoreLabel();
                    if (initialObjStoreName == null || !initialObjStoreName.equalsIgnoreCase(this.m_onlyThisObjectStore)) {
                        contextItem = scopeItem;
                    }
                }
            }
            if (contextItem == null) {
                this.m_initialDirectory = contextItem = scopeItem;
            } else if (contextItem.getItemType() == 2) {
                this.m_initialDirectory = contextItem;
            } else {
                this.m_selectedItem = this.m_initialDirectory = contextItem.getParent();
            }
        }
        catch (Exception ex) {
            this.m_creationException = ex;
        }
    }

    public void setFilename(String filename) {
    }

    public void setContextItem(WcmDlgItemImpl contextItem) {
        this.m_initialDirectory = contextItem;
    }
}

