/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.toolkit.client.ui.WcmItemProperty;
import com.filenet.wcm.toolkit.client.ui.WcmPropertiesGridPanel;
import com.filenet.wcm.toolkit.client.ui.common.WcmNonEditableTextField;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddFolderWizard;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddWizard;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassTreeDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.util.WcmClassDescsDom;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

class WcmDlgDocPropertiesPanel
extends JPanel
implements ActionListener {
    private JLabel m_docNameLabel = new JLabel();
    private JLabel m_folderLabel;
    private JLabel m_folderName;
    private JLabel m_classNameLabel;
    private JTextField m_classNameField;
    private WcmPropertiesGridPanel m_propertiesPanel;
    private WcmDlgItemImpl m_folder;
    private String m_docName;
    private ClassDescription m_fixedClassObj;
    private ClassDescriptions m_docClassDescs;
    private ClassDescription[] m_docClassObjs;
    private ClassDescription m_selClassDesc;
    private String m_selDocClassName;
    private int m_selDocClassIndex;
    private boolean m_bFixedClass;
    private Properties m_preloadProps;
    private int m_objType;
    private int m_wizardType = 0;
    private Dialog m_parent;
    private JButton m_browseTreeButton;
    private WcmDlgClassTreeDialog m_browseTreeDlg;
    private org.w3c.dom.Document m_oDoc;
    private boolean m_oDocIsNew;
    private WcmDlgClassDescItem m_classItem;
    private WcmDlgItemImpl m_checkinItem;

    public WcmDlgDocPropertiesPanel(Dialog parent, String docName, WcmDlgClassDescItem classItem, int objType, Properties props, int wizardType) throws WcmException {
        this(parent, docName, classItem, objType, props, wizardType, null);
    }

    public WcmDlgDocPropertiesPanel(Dialog parent, String docName, WcmDlgClassDescItem classItem, int objType, Properties props, int wizardType, WcmDlgItemImpl checkinItem) throws WcmException {
        try {
            this.m_parent = parent;
            this.m_docName = docName;
            this.m_preloadProps = props;
            this.m_objType = objType;
            this.m_classItem = classItem;
            this.m_wizardType = wizardType;
            this.m_checkinItem = checkinItem;
            this.m_bFixedClass = this.m_classItem.getIsHidden();
            this.m_selDocClassName = this.m_classItem.getClassName();
            this.m_selClassDesc = this.m_classItem.getClassDescription();
            if (this.m_bFixedClass) {
                this.m_fixedClassObj = this.m_classItem.getClassDescription();
            }
            this.initLayout();
        }
        catch (Exception ex) {
            System.out.println("WcmDlgDocPropertiesPanel exception " + ex.getMessage());
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedConstructPropertiesPanel", "Failed Constructing Properties Panel.\n {0}", (Object)ex.getLocalizedMessage());
        }
    }

    private void initLayout() throws WcmException {
        try {
            this.setLayout(new GridBagLayout());
            if (this.m_classItem.getIsHidden() || this.m_classItem.getId().equalsIgnoreCase("{01A3A8CA-7AEC-11D1-A31B-0020AF9FBB1C}")) {
                this.add((Component)new JLabel(""), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)new JLabel(WcmResourceString.s_fileNameColon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.m_docNameLabel.setText(this.m_docName);
                this.m_docNameLabel.setForeground(Color.black);
                this.add((Component)this.m_docNameLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
            }
            int y = 1;
            if (this.m_wizardType == 0 || this.m_wizardType == 2) {
                this.m_folderLabel = this.m_wizardType == 0 ? new JLabel(WcmResourceString.s_folderColon) : new JLabel(WcmResourceString.s_createIn);
                this.add((Component)this.m_folderLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.m_folderName = new JLabel();
                this.m_folderName.setForeground(Color.black);
                this.add((Component)this.m_folderName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
                ++y;
            }
            this.add((Component)new JLabel(WcmResourceString.s_classColon), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
            if (this.m_bFixedClass) {
                this.m_classNameLabel = new JLabel();
                this.m_classNameLabel.setText(this.m_selDocClassName);
                this.add((Component)this.m_classNameLabel, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
            } else {
                this.m_classNameField = new WcmNonEditableTextField();
                this.m_classNameField.setText(this.m_selDocClassName);
                this.add((Component)this.m_classNameField, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 8, 0, 2), 0, 0));
                this.m_browseTreeButton = new JButton(WcmResourceString.s_browseDots);
                this.m_browseTreeButton.addActionListener(this);
                this.add((Component)this.m_browseTreeButton, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 0, 0), 0, 0));
            }
            ++y;
            this.m_propertiesPanel = new WcmPropertiesGridPanel();
            switch (this.m_wizardType) {
                case 2: {
                    this.m_propertiesPanel.setMode(25);
                    break;
                }
                case 0: {
                    if (this.isDesignerClass()) {
                        this.m_propertiesPanel.setMode(57);
                        break;
                    }
                    this.m_propertiesPanel.setMode(25);
                    break;
                }
                case 1: {
                    if (this.isDesignerClass()) {
                        this.m_propertiesPanel.setMode(60);
                        break;
                    }
                    this.m_propertiesPanel.setMode(28);
                }
            }
            this.add((Component)this.m_propertiesPanel, new GridBagConstraints(0, y, 3, 1, 1.0, 1.0, 23, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        catch (Exception ex) {
            System.out.println("initLayout exception " + ex.getMessage());
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedInitPropertiesPanel", "Failed init Properties Panel.\n {0}", (Object)ex.getLocalizedMessage());
        }
    }

    public void setFolder(WcmDlgItemImpl folder, String folderPath) throws WcmException {
        if (folder != null) {
            if (this.m_folder == null) {
                this.m_folder = folder;
                this.m_folderName.setText(folderPath);
                this.resetClassDescription();
                this.resetPropertiesGrid();
                if (this.m_bFixedClass) {
                    this.initFixedClassAndProperties();
                } else {
                    this.initClassAndProperties();
                }
            } else if (folder.getObjectStore().getLabel().compareToIgnoreCase(this.m_folder.getObjectStore().getLabel()) != 0) {
                this.m_folder = folder;
                this.m_folderName.setText(folderPath);
                this.resetClassDescription();
                this.resetPropertiesGrid();
                if (this.m_fixedClassObj != null) {
                    this.initFixedClassAndProperties();
                } else {
                    this.initClassAndProperties();
                }
            } else {
                this.m_folder = folder;
                this.m_folderName.setText(folderPath);
            }
        }
    }

    public void loadProperties() throws WcmException {
        try {
            this.resetPropertiesGrid();
            this.m_propertiesPanel.loadCustomProperties(this.m_fixedClassObj, this.m_preloadProps);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedInitClass", "Failed to load Properties. Exception {0} ", (Object)ex.getMessage());
        }
    }

    private void initFixedClassAndProperties() throws WcmException {
        try {
            if (this.m_fixedClassObj == null) {
                ObjectStore objStore = (ObjectStore)this.m_folder.getObjectStore().getWcmObject();
                this.m_fixedClassObj = (ClassDescription)objStore.getObject(25, this.m_classItem.getId());
                this.m_selDocClassName = WcmItemProperty.getClassDescDisplayName(this.m_fixedClassObj);
                this.m_classNameLabel.setText(this.m_selDocClassName);
            }
            this.m_propertiesPanel.loadCustomProperties(this.m_fixedClassObj, this.m_preloadProps);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedInitClass", "Failed to load Properties. Exception {0} ", (Object)ex.getMessage());
        }
    }

    private ClassDescription getTopFirstClass(ObjectStore os, org.w3c.dom.Document oDoc) throws Exception {
        ClassDescription cd = null;
        Element oRoot = oDoc.getDocumentElement();
        Element oCD = WcmClassDescsDom.getChildElement(oRoot, "classdesc");
        if (oCD != null) {
            Element oId = WcmClassDescsDom.getChildElement(oCD, "id");
            String sGuid = WcmClassDescsDom.getValue(oId);
            cd = (ClassDescription)os.getObject(25, sGuid);
        }
        return cd;
    }

    private void initClassAndProperties() throws WcmException {
        try {
            WcmDlgDocPropertiesPanel wcmDlgDocPropertiesPanel = this;
            this.m_oDoc = WcmClassDescsDom.getObjectStoreClassesDOM(wcmDlgDocPropertiesPanel.m_folder.getSession(), this.m_folder.getObjectStore().getId(), this.m_objType, false);
            this.m_oDocIsNew = true;
            this.m_selClassDesc = this.getTopFirstClass((ObjectStore)this.m_folder.getObjectStore().getWcmObject(), this.m_oDoc);
            String className = WcmItemProperty.getClassDescDisplayName(this.m_selClassDesc);
            this.m_classNameField.setText(className);
            this.m_propertiesPanel.loadCustomProperties(this.m_selClassDesc, this.m_preloadProps);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedInitClass", "Failed to load Properties. Exception {0} ", (Object)ex.getMessage());
        }
    }

    private void setClassAndProperties(WcmDlgClassDescItem cdItem) throws WcmException {
        try {
            this.m_selClassDesc = cdItem.getClassDescription();
            String className = WcmItemProperty.getClassDescDisplayName(this.m_selClassDesc);
            this.m_classNameField.setText(cdItem.getClassName());
            this.m_propertiesPanel.loadCustomProperties(cdItem.getClassDescription(), this.m_preloadProps);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedInitClass", "Failed to load Properties. Exception {0} ", (Object)ex.getMessage());
        }
    }

    public void setDocName(String docName) {
        this.m_docName = docName;
        this.m_docNameLabel.setText(this.m_docName);
    }

    public ClassDescription getClassObject() {
        if (this.m_bFixedClass) {
            return this.m_fixedClassObj;
        }
        return this.m_selClassDesc;
    }

    public String getClassId() {
        if (this.m_bFixedClass) {
            return this.m_fixedClassObj.getId();
        }
        return this.m_selClassDesc.getId();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_browseTreeButton) {
            this.performBrowseClassTree();
        }
    }

    public boolean validateProps() throws Exception {
        return this.m_propertiesPanel.validateProperties();
    }

    private void resetPropertiesGrid() throws WcmException {
        switch (this.m_wizardType) {
            case 2: {
                this.m_propertiesPanel.setMode(25);
                this.m_propertiesPanel.setNameProperty(this.getFolderNameProperty(), true);
                break;
            }
            case 0: {
                if (this.isDesignerClass()) {
                    this.m_propertiesPanel.setMode(57);
                } else {
                    this.m_propertiesPanel.setMode(25);
                }
                this.m_propertiesPanel.setNameProperty(this.getDocumentNameProperty(), false);
                break;
            }
            case 1: {
                if (this.isDesignerClass()) {
                    this.m_propertiesPanel.setMode(60);
                } else {
                    this.m_propertiesPanel.setMode(28);
                }
                this.m_propertiesPanel.setNameProperty(this.getDocumentNameProperty(), false);
            }
        }
    }

    private void setClassItems(int size) {
        this.m_docClassObjs = new ClassDescription[size];
        for (int i = 0; i < size; ++i) {
            this.m_docClassObjs[i] = (ClassDescription)this.m_docClassDescs.get(i);
        }
    }

    public Properties getProperties() throws WcmException {
        return this.m_propertiesPanel.getProperties(2);
    }

    public String getNewFolderName() throws WcmException {
        String metaName = ((WcmDlgItemImpl)this.m_folder.getObjectStore()).getFolderNamePropName();
        Properties props = this.getProperties();
        Iterator it = props.iterator();
        String newFolderName = "";
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.getName().equalsIgnoreCase(metaName)) continue;
            Object propVal = prop.getValue();
            newFolderName = propVal.toString();
            break;
        }
        return newFolderName;
    }

    public void setRequestFocus() {
        if (this.m_browseTreeButton != null) {
            this.m_browseTreeButton.requestFocus();
        } else {
            this.m_propertiesPanel.requestFocus();
        }
    }

    private boolean validateClassDescription(ClassDescription classDesc) throws PropertyNotFoundException {
        PropertyDescriptions propDescs = classDesc.getPropertyDescriptions();
        ListIterator it = propDescs.listIterator();
        while (it.hasNext()) {
            PropertyDescription propDesc = (PropertyDescription)it.next();
            if (propDesc.getPropertyBooleanValue("IsSystemGenerated") || propDesc.getPropertyBooleanValue("IsHidden") || !propDesc.getPropertyBooleanValue("IsValueRequired") || propDesc.getPropertyIntValue("DataType") != 1 && propDesc.getPropertyIntValue("DataType") != 7) continue;
            WcmErrorUtil.showErrorMessage(this, WcmResourceString.s_badClassSelection.toString(classDesc.getName()), this.m_parent.getTitle());
            return false;
        }
        return true;
    }

    private ObjectStore getObjectStore() {
        ReadableMetadataObject rmdObj;
        ObjectStore objStore = null;
        if (this.m_checkinItem != null && (rmdObj = this.m_checkinItem.getWcmObject()) instanceof Document) {
            Document docObj = (Document)rmdObj;
            try {
                objStore = (ObjectStore)docObj.getPropertyValue("ObjectStore");
            }
            catch (Exception ex) {
                objStore = null;
            }
        }
        return objStore;
    }

    public void setWaitCursor() {
        if (this.m_wizardType == 2) {
            ((WcmDlgAddFolderWizard)((Object)this.m_parent)).setWaitCursor();
        } else {
            ((WcmDlgAddWizard)((Object)this.m_parent)).setWaitCursor();
        }
    }

    public void restoreCursor() {
        if (this.m_wizardType == 2) {
            ((WcmDlgAddFolderWizard)((Object)this.m_parent)).restoreCursor();
        } else {
            ((WcmDlgAddWizard)((Object)this.m_parent)).restoreCursor();
        }
    }

    protected void performBrowseClassTree() {
        this.setWaitCursor();
        try {
            WcmDlgClassDescItem cdItem;
            if (this.m_browseTreeDlg == null || this.m_oDocIsNew) {
                if (this.m_folder != null) {
                    this.m_browseTreeDlg = new WcmDlgClassTreeDialog(this.m_parent, (ObjectStore)this.m_folder.getObjectStore().getWcmObject(), this.m_oDoc, this.m_selClassDesc, true);
                } else {
                    ObjectStore objStore = this.getObjectStore();
                    WcmDlgDocPropertiesPanel wcmDlgDocPropertiesPanel = this;
                    Session sess = wcmDlgDocPropertiesPanel.m_checkinItem.getSession();
                    if (sess != null && objStore != null) {
                        this.m_oDoc = WcmClassDescsDom.getObjectStoreClassesDOM(sess, objStore.getId(), this.m_objType, false);
                        this.m_oDocIsNew = true;
                        this.m_browseTreeDlg = new WcmDlgClassTreeDialog(this.m_parent, objStore, this.m_oDoc, this.m_selClassDesc, true);
                    }
                }
                this.m_oDocIsNew = false;
            }
            this.restoreCursor();
            int retVal = this.m_browseTreeDlg.showDialog();
            if (retVal == 0 && (cdItem = this.m_browseTreeDlg.getSelected()) != null && cdItem.getId().compareToIgnoreCase(this.m_selClassDesc.getId()) != 0) {
                if (this.validateClassDescription(cdItem.getClassDescription())) {
                    this.setClassAndProperties(cdItem);
                } else {
                    cdItem.setClassStatus(1);
                }
            }
            this.restoreCursor();
        }
        catch (Exception ex) {
            this.restoreCursor();
            WcmErrorUtil.showErrorMessage(this, ex.getLocalizedMessage(), this.m_parent.getTitle());
        }
    }

    private String getFolderNameProperty() throws WcmException {
        if (this.m_folder == null) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedGetFolderNameProperty", "Failed to get Folder name property.");
        }
        return this.m_folder.getFolderNameProperty();
    }

    private String getDocumentNameProperty() throws WcmException {
        WcmDlgItemImpl dlgItem = null;
        dlgItem = this.m_wizardType == 1 ? (WcmDlgItemImpl)((WcmDlgAddWizard)((Object)this.m_parent)).getSelectedItem() : this.m_folder;
        if (dlgItem == null) {
            throw new WcmException("client.WcmDlgDocPropertiesPanel.FailedGetDocumentNameProperty", "Failed to get Document name property.");
        }
        return dlgItem.getDocumentNameProperty();
    }

    private void resetClassDescription() throws WcmException {
        ObjectStore objStore = (ObjectStore)this.m_folder.getObjectStore().getWcmObject();
        this.m_fixedClassObj = (ClassDescription)objStore.getObject(25, this.m_classItem.getId());
        this.m_classItem = new WcmDlgClassDescItem(this.m_fixedClassObj);
        this.m_selDocClassName = this.m_classItem.getClassName();
        if (this.m_bFixedClass) {
            this.m_classNameLabel.setText(this.m_selDocClassName);
        }
    }

    private boolean isDesignerClass() {
        String classId = this.m_classItem.getId();
        if (classId.equalsIgnoreCase("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}")) {
            return true;
        }
        return this.m_bFixedClass && (classId.equalsIgnoreCase("{FBA25CE9-A06A-4F79-8A23-E09AE54DD7CD}") || classId.equalsIgnoreCase("{D508E302-7E74-42F4-A7D7-B985DD333509}") || classId.equalsIgnoreCase("{A5C636CD-11BD-455D-9E1A-604A356ABFBA}") || classId.equalsIgnoreCase("{902C0C1F-65DC-4925-B8FA-B4ECA4AD752A}") || classId.equalsIgnoreCase("{193E5683-C724-4C3B-8D55-F4091B9B7222}"));
    }
}

