/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.ReadableSecurityObject;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgSecurityHelper;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;

class WcmDlgDocPermissionsPanel
extends JPanel {
    private JLabel m_docNameLabel = new JLabel();
    private JLabel m_folderLabel;
    private JLabel m_folderName = new JLabel();
    private JLabel m_classLabel;
    private String m_docName;
    private String m_className;
    private WcmSecurityPanel m_securityPanel;
    private Dialog m_parent;
    private int m_objType;
    private int m_wizardType = 0;
    private WcmDlgClassDescItem m_classItem;
    private WcmDlgSecurityHelper m_securityHelper;
    private boolean m_bSecurityReadOnly;
    private boolean m_bSecurityModifiable = true;
    private WcmSitePrefs m_sitePref = null;

    public WcmDlgDocPermissionsPanel(Dialog parent, String docName, WcmDlgClassDescItem classItem, int objType, int wizardType) {
        this.m_parent = parent;
        this.m_docName = docName;
        this.m_classItem = classItem;
        this.m_className = classItem.getClassName();
        this.m_objType = objType;
        this.m_wizardType = wizardType;
        this.initLayout(parent);
    }

    public void SetSitePrefs(WcmSitePrefs sitePref) {
        this.m_sitePref = sitePref;
    }

    public void refresh(WcmDlgItemImpl item, String folderPath, String docName, String selDocClassName, ClassDescription cd) {
        try {
            System.out.println(" Entering WcmDlgDocPermissionsPanel.refresh(); folderPath: " + folderPath);
            System.out.println(" Entering WcmDlgDocPermissionsPanel.refresh(); docName: " + docName);
            System.out.println(" Entering WcmDlgDocPermissionsPanel.refresh(); selDocClassName: " + selDocClassName);
            if (item == null) {
                System.out.println(" WcmDlgDocPermissionsPanel.refresh() WcmDlgItemImpl item is null");
                throw new WcmException("client.WcmDlgAddWizard.IllegalNullArgumentException", "Invalid null input parameters");
            }
            if (cd == null) {
                System.out.println(" WcmDlgDocPermissionsPanel.refresh() ClassDescription cd is null");
                throw new WcmException("client.WcmDlgAddWizard.IllegalNullArgumentException", "Invalid null input parameters");
            }
            this.m_folderName.setText(folderPath);
            this.m_docName = docName;
            this.m_docNameLabel.setText(this.m_docName);
            this.m_className = selDocClassName;
            this.m_classLabel.setText(this.m_className);
            if (this.m_securityPanel != null) {
                return;
            }
            GridBagConstraints gbCons = new GridBagConstraints();
            int objType = this.m_objType;
            switch (this.m_wizardType) {
                case 0: {
                    System.out.println(" WcmDlgAddWizard.TYPE_ADDWIZARD");
                    this.m_securityHelper = new WcmDlgSecurityHelper(cd);
                    System.out.println(" Before creating a new WcmSecurityPanel");
                    this.m_securityPanel = new WcmSecurityPanel(this.m_parent, item.getSession(), this.m_securityHelper.getObjectPermissions(), this.m_securityHelper.getTemplatePermissions(), objType, !this.m_securityHelper.isEditable(), item.getUserDisplayName());
                    System.out.println(" After creating a new WcmSecurityPanel");
                    this.m_securityPanel.setSitePrefs(item.getSitePreferences());
                    break;
                }
                case 2: {
                    this.m_securityHelper = new WcmDlgSecurityHelper(cd);
                    this.m_securityPanel = new WcmSecurityPanel(this.m_parent, item.getSession(), this.m_securityHelper.getObjectPermissions(), this.m_securityHelper.getTemplatePermissions(), objType, !this.m_securityHelper.isEditable(), item.getUserDisplayName());
                    this.m_securityPanel.setSitePrefs(item.getSitePreferences());
                    break;
                }
                case 1: {
                    System.out.println(" WcmDlgAddWizard.TYPE_CHECKINWIZARD");
                    int docMask = ((Document)item.getWcmObject()).getAccessMask();
                    boolean bWriteACL = (docMask & 0x40000) != 0;
                    this.m_securityHelper = new WcmDlgSecurityHelper((ReadableSecurityObject)item.getWcmObject(), bWriteACL);
                    this.m_bSecurityModifiable = bWriteACL && this.m_securityHelper.isEditable();
                    System.out.println(" Before creating a new WcmSecurityPanel");
                    this.m_securityPanel = new WcmSecurityPanel((Window)this.m_parent, item.getSession(), this.m_securityHelper.getObjectPermissions(), this.m_securityHelper.getTemplatePermissions(), objType, !this.m_bSecurityModifiable);
                    System.out.println(" After creating a new WcmSecurityPanel");
                    this.m_securityPanel.setSitePrefs(item.getSitePreferences());
                }
            }
            this.add((Component)this.m_securityPanel, new GridBagConstraints(0, 3, 2, 2, 1.0, 1.0, 23, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.applyComponentOrientation(this.m_parent.getComponentOrientation());
        }
        catch (Exception ex) {
            System.out.println(" WcmDlgDocPermissionsPanel.refresh() exception message: " + ex.getMessage());
            WcmErrorUtil.showErrorMessage(this.m_parent, ex.getMessage(), this.m_parent.getTitle());
        }
    }

    public WcmSecurityPanel getSecurityPanel() {
        return this.m_securityPanel;
    }

    public boolean isSecurityModifiable() {
        return this.m_bSecurityModifiable;
    }

    private void initLayout(Dialog parent) {
        try {
            this.setLayout(new GridBagLayout());
            if (this.m_classItem.getIsHidden() || this.m_classItem.getId().equalsIgnoreCase("{01A3A8CA-7AEC-11D1-A31B-0020AF9FBB1C}")) {
                this.add((Component)new JLabel(""), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)new JLabel(WcmResourceString.s_fileNameColon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.m_docNameLabel.setText(this.m_docName);
                this.m_docNameLabel.setForeground(Color.black);
                this.add((Component)this.m_docNameLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
            }
            int y = 1;
            if (this.m_wizardType == 0 || this.m_wizardType == 2) {
                this.m_folderLabel = this.m_wizardType == 0 ? new JLabel(WcmResourceString.s_folderColon) : new JLabel(WcmResourceString.s_createIn);
                this.add((Component)this.m_folderLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.m_folderName.setForeground(Color.black);
                this.add((Component)this.m_folderName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
                ++y;
            }
            this.add((Component)new JLabel(WcmResourceString.s_classColon), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.m_classLabel = new JLabel(this.m_className);
            this.m_classLabel.setForeground(Color.black);
            this.add((Component)this.m_classLabel, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 10, 0, 0), 0, 0));
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(parent, ex.getMessage(), parent.getTitle());
        }
    }
}

