/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.ae.util.bidi.BiDiOrientation;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmNonEditableTextField;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddWizard;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemChooser;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class WcmDlgDocFolderPanel
extends JPanel
implements ActionListener {
    protected static final String FILE_EXTENSION = ".doc";
    private JTextField m_docName = new JTextField();
    private JTextField m_docFolder;
    private JButton m_browseButton;
    private ImageIcon m_blankIcon;
    private WcmDlgItemChooser m_folderBrowser;
    private WcmDlgItemImpl m_folder;
    private Dialog m_parent;
    private WcmDlgItem m_contextItem;
    private WcmDlgItem m_scopeItem;
    private WcmDlgClassDescItem m_classItem;

    public WcmDlgDocFolderPanel(Dialog parent, WcmDlgItem scopeItem, WcmDlgItem initialDirectory, WcmDlgClassDescItem classItem) {
        this.m_parent = parent;
        this.m_contextItem = initialDirectory;
        this.m_scopeItem = scopeItem;
        this.m_classItem = classItem;
        this.initLayout();
    }

    public WcmDlgItemImpl getFolder() {
        return this.m_folder;
    }

    public String getDocName() {
        String docName = this.m_docName.getText();
        return docName;
    }

    public void setDocName(String filename) {
        this.m_docName.setText(filename);
    }

    public boolean validateProps() throws WcmException {
        if (this.m_folder == null) {
            throw new WcmException("client.WcmDlgDocFolderPanel.ObjStoreNameRequired", "ObjectStore:\\Folder Name is required.");
        }
        if (!this.m_classItem.getIsHidden()) {
            String docName = this.m_docName.getText();
            docName.trim();
            if (docName == null || docName.length() == 0) {
                throw new WcmException("client.WcmDlgDocFolderPanel.FileNameRequired", "File Name is required.");
            }
            if (!((WcmDlgAddWizard)((Object)this.m_parent)).validateFilename(docName)) {
                throw new WcmException("client.WcmDlgDocFolderPanel.InvalidDocName", "Filename: {0}, cannot contain any of the following characters\n \\ / : * ? \" < > |", (Object)docName);
            }
        }
        return true;
    }

    public void resetValue() {
        WcmDlgItem contextItem = ((WcmDlgAddWizard)((Object)this.m_parent)).getContextItem();
        if (contextItem == null) {
            this.m_docFolder.setText("");
        } else {
            this.m_docFolder.setText(contextItem.getPathname());
            this.m_folder = (WcmDlgItemImpl)contextItem;
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_browseButton) {
            this.performBrowseButton();
        }
    }

    public void setRequestFocus() {
        if (this.m_classItem.getIsHidden()) {
            this.m_browseButton.requestFocus();
        } else {
            this.m_docName.requestFocus();
        }
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        this.m_blankIcon = WcmImageLoader.createImageIcon("type/Blank32.gif");
        this.add((Component)new JLabel(this.m_blankIcon), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_classItem.getIsHidden()) {
            this.add((Component)new JLabel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)new JLabel(WcmResourceString.s_fileNameColon), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_docName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 5, 0), 0, 0));
        }
        this.add((Component)new JLabel(WcmResourceString.s_folderColon), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_docFolder = new WcmNonEditableTextField();
        this.add((Component)this.m_docFolder, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.m_browseButton = new JButton(WcmResourceString.s_browseDots);
        this.m_browseButton.addActionListener(this);
        this.add((Component)this.m_browseButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(this.m_blankIcon), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void performBrowseButton() {
        try {
            if (this.m_folderBrowser == null) {
                this.m_folderBrowser = new WcmDlgItemChooser(this.m_scopeItem, this.m_contextItem, new int[]{2});
            } else if (this.m_contextItem != null) {
                this.m_folderBrowser.setContextItem(this.getContextDirectory(this.m_contextItem));
            }
            this.m_folderBrowser.setTitle(WcmResourceString.s_selectAFolder);
            this.m_folderBrowser.setBrowseMode(3);
            this.m_folderBrowser.setRootFolderSelectable(this.m_classItem.getId().equalsIgnoreCase("{D508E302-7E74-42F4-A7D7-B985DD333509}"));
            ((WcmDlgAddWizard)((Object)this.m_parent)).setWaitCursor();
            int retVal = this.m_folderBrowser.showDialog(this.m_parent);
            if (retVal == 0) {
                this.m_contextItem = this.m_folderBrowser.getSelectedItem();
                if (this.m_contextItem != null && (this.m_contextItem.getItemType() == 3 || this.m_contextItem.getItemType() == 2)) {
                    this.m_folder = (WcmDlgItemImpl)this.m_contextItem;
                    this.m_docFolder.setText(BiDiOrientation.formatPath((String)this.m_folder.getPathname()));
                    ((WcmDlgAddWizard)((Object)this.m_parent)).setContextItem(this.m_contextItem);
                    ((WcmDlgAddWizard)((Object)this.m_parent)).setEnableNext(true);
                    ((WcmDlgAddWizard)((Object)this.m_parent)).setRequestFocusNext();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("performBrowseButton exception " + ex.getMessage());
        }
        ((WcmDlgAddWizard)((Object)this.m_parent)).restoreCursor();
    }

    private WcmDlgItemImpl getContextDirectory(WcmDlgItem contextItem) throws WcmException {
        if (contextItem == null) {
            return null;
        }
        WcmDlgItemImpl dir = (WcmDlgItemImpl)contextItem;
        if (dir.getItemType() == 4 && (dir = dir.getParent()).getItemType() == 4) {
            dir = dir.getParent();
        }
        if (dir.getItemType() == 3) {
            dir = dir.getParent();
        }
        if (dir.getItemType() != 2 && dir.getItemType() != 3) {
            throw new WcmException("client.WcmDlg.InvalidInputParam", "Invalid input param {0}", (Object)contextItem.toString());
        }
        return dir;
    }
}

