/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemChooserDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgSelectionPanel;
import com.filenet.wcm.toolkit.client.util.ObjectStoreFilteringUtil;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class WcmDlgDirectoryModel
extends AbstractListModel
implements TableModel {
    private static final int NUM_OBJECTSTORE_COLUMNS = 1;
    private WcmDlgSelectionPanel m_selectionPanel = null;
    private WcmDlgItemChooserDialog m_itemChooserDlg = null;
    private WcmDlgItem[] m_itemCache = null;
    private int m_nItemCount = 0;
    private boolean m_bFolderAndDocItemsOverMax = false;
    private EventListenerList m_tblListenerList = null;
    private ObjectStoreFilteringUtil m_objectStoreFilter = new ObjectStoreFilteringUtil("");

    public WcmDlgDirectoryModel(WcmDlgSelectionPanel selectionPanel) {
        this.m_selectionPanel = selectionPanel;
        if (this.m_selectionPanel != null) {
            this.m_itemChooserDlg = this.m_selectionPanel.getItemChooserDialog();
        }
        this.m_tblListenerList = new EventListenerList();
        try {
            this.rescan();
        }
        catch (WcmException ex) {
            WcmErrorUtil.showErrorMessage((Component)((Object)this.m_itemChooserDlg), ex.getMessage(), this.m_itemChooserDlg.getTitle());
        }
    }

    public void getContents(WcmDlgItemImpl item) throws WcmException {
        WcmDlgItem[] itemCache = null;
        try {
            this.invalidateCache();
            if (item == null) {
                return;
            }
            this.m_itemChooserDlg.setWaitCursor();
            itemCache = item.list(this.m_itemChooserDlg.getFilterTypes());
            if (itemCache != null) {
                if (item.getItemType() == 1) {
                    this.m_itemCache = this.retrieveNeighborhoodItems(itemCache);
                    this.m_bFolderAndDocItemsOverMax = false;
                } else {
                    this.m_itemCache = this.m_itemChooserDlg.getFilterClass() != null ? this.retrieveObjectStoreItems(itemCache) : itemCache;
                    this.m_bFolderAndDocItemsOverMax = this.m_itemCache != null && this.m_itemCache.length > WcmDlgItemImpl.getSitePreferenceDocumentMaxSize();
                }
            } else {
                this.m_bFolderAndDocItemsOverMax = false;
            }
            this.m_objectStoreFilter.setObjectStoreFilterList(WcmDlgFactory.getObjectStoreFilterList());
            this.m_nItemCount = this.m_itemCache != null ? this.m_itemCache.length : 0;
        }
        catch (WcmException ex) {
            throw ex;
        }
        finally {
            this.updateUI();
            this.m_itemChooserDlg.restoreCursor();
        }
    }

    public void rescan() throws WcmException {
        this.getContents(this.m_selectionPanel.getCurrentDirectory());
    }

    public void updateUI() {
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        this.fireContentsChanged(this, 0, this.m_nItemCount - 1);
    }

    public int getSize() {
        return this.m_nItemCount;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public int indexOf(Object obj) {
        if (obj == null) {
            for (int i = 0; i < this.m_nItemCount; ++i) {
                if (this.m_itemCache[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.m_nItemCount; ++i) {
                if (!obj.equals(this.m_itemCache[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getElementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.m_nItemCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.m_itemCache != null) {
            return this.m_itemCache[index];
        }
        return null;
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_tblListenerList.add(TableModelListener.class, l);
    }

    public Class getColumnClass(int nColumnIndex) {
        WcmDlgItemImpl currentDirectory = this.m_selectionPanel.getCurrentDirectory();
        if (currentDirectory == null) {
            return null;
        }
        if (nColumnIndex == 0) {
            return WcmDlgItemImpl.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        WcmDlgItemImpl currentDirectory = this.m_selectionPanel.getCurrentDirectory();
        if (currentDirectory == null) {
            return 0;
        }
        if (currentDirectory.isRoot()) {
            return 1;
        }
        int colNum = 1;
        try {
            colNum = this.m_selectionPanel.getViewMode() == 1 ? (colNum += ((WcmDlgItemImpl)currentDirectory.getObjectStore()).getDetailedNames().length) : (colNum += ((WcmDlgItemImpl)currentDirectory.getObjectStore()).getVersionsNames().length);
        }
        catch (Exception ex) {
            System.out.println("WcmDlgDirectoryModel.getColumnCount Exception " + ex.getMessage());
            if (this.m_selectionPanel.getViewMode() == 1) {
                colNum += 5;
            }
            colNum += 5;
        }
        return colNum;
    }

    public String getColumnName(int nColumnIndex) {
        WcmDlgItemImpl currentDirectory = this.m_selectionPanel.getCurrentDirectory();
        if (currentDirectory == null) {
            return null;
        }
        if (nColumnIndex == 0) {
            return WcmResourceString.s_name;
        }
        String colName = "Column" + nColumnIndex;
        try {
            colName = this.m_selectionPanel.getViewMode() == 1 ? ((WcmDlgItemImpl)currentDirectory.getObjectStore()).getDetailedNames()[nColumnIndex - 1] : ((WcmDlgItemImpl)currentDirectory.getObjectStore()).getVersionsNames()[nColumnIndex - 1];
        }
        catch (Exception ex) {
            System.out.println("WcmDlgDirectoryModel.getColumnName Exception " + ex.getMessage());
        }
        return colName;
    }

    public int getRowCount() {
        return this.getSize();
    }

    public Object getValueAt(int nRow, int nCol) {
        if (this.m_itemCache == null || nRow >= this.m_nItemCount) {
            return null;
        }
        WcmDlgItemImpl item = (WcmDlgItemImpl)this.m_itemCache[nRow];
        if (nCol == 0) {
            return item;
        }
        String propVal = this.m_selectionPanel.getViewMode() == 1 ? item.getDetailedValues()[nCol - 1] : item.getVersionsValues()[nCol - 1];
        return propVal;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public boolean isItemsOverMax() {
        return this.m_bFolderAndDocItemsOverMax;
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_tblListenerList.remove(TableModelListener.class, l);
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    private void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_tblListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    private void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    private void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    private void invalidateCache() {
        this.m_itemCache = null;
        this.m_nItemCount = 0;
    }

    private WcmDlgItem[] retrieveNeighborhoodItems(WcmDlgItem[] itemCache) {
        Vector<WcmDlgItem> items = null;
        String onlyObjStore = null;
        WcmDlgItem[] itemArray = null;
        try {
            if (itemCache == null) {
                return null;
            }
            items = new Vector<WcmDlgItem>();
            onlyObjStore = this.m_itemChooserDlg.showOnlyThisObjStore();
            ObjectStores visibleObjStores = this.m_itemChooserDlg.getVisibleObjectStores();
            if (onlyObjStore != null) {
                for (int nIndex = 0; nIndex < itemCache.length; ++nIndex) {
                    if (VWStringUtils.compareIgnoreCase((String)onlyObjStore, (String)itemCache[nIndex].getLabel()) != 0) continue;
                    items.addElement(itemCache[nIndex]);
                    break;
                }
            } else if (visibleObjStores != null) {
                block3: for (int nIndex = 0; nIndex < itemCache.length; ++nIndex) {
                    for (ObjectStore visibleObjStore : visibleObjStores) {
                        if (VWStringUtils.compareIgnoreCase((String)visibleObjStore.getId(), (String)itemCache[nIndex].getId()) != 0) continue;
                        items.addElement(itemCache[nIndex]);
                        continue block3;
                    }
                }
            } else {
                return itemCache;
            }
            if (!items.isEmpty()) {
                itemArray = items.toArray(new WcmDlgItemImpl[0]);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return itemArray;
    }

    private WcmDlgItem[] retrieveObjectStoreItems(WcmDlgItem[] itemCache) {
        Vector<WcmDlgItem> items = null;
        WcmDlgItem[] itemArray = null;
        try {
            if (itemCache == null) {
                return null;
            }
            items = new Vector<WcmDlgItem>();
            String filterClass = this.m_itemChooserDlg.getFilterClass();
            for (int nIndex = 0; nIndex < itemCache.length; ++nIndex) {
                if (itemCache[nIndex].getWcmObject().getClassId().equalsIgnoreCase(filterClass)) {
                    items.addElement(itemCache[nIndex]);
                    continue;
                }
                if (itemCache[nIndex].getWcmObject().getObjectType() != 2) continue;
                items.addElement(itemCache[nIndex]);
            }
            if (!items.isEmpty()) {
                itemArray = items.toArray(new WcmDlgItemImpl[0]);
            }
        }
        catch (Exception ex) {
            System.out.println("WcmDlgDirectoryModel.retrieveObjectStoreItems Exception " + ex.getMessage());
        }
        return itemArray;
    }
}

