/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class WcmDlgDirectoryComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Vector m_directories = null;
    private int m_nTopIndex = -1;
    private int m_nPathCount = 0;
    private WcmDlgItem m_selectedDirectory = null;

    public WcmDlgDirectoryComboBoxModel(WcmDlgItemImpl initialDirectory) {
        try {
            this.m_directories = new Vector();
            this.m_directories.addElement(initialDirectory.getRoot());
            this.addItem(initialDirectory);
        }
        catch (Exception ex) {
            System.out.println("[Internal Error] Failed to init WcmDlgDirectoryComboBoxModel Exception" + ex.getMessage());
        }
    }

    public void addItem(WcmDlgItem directory) {
        WcmDlgItem item = null;
        WcmDlgItemImpl parent = null;
        Vector<WcmDlgItem> path = null;
        if (directory == null || this.m_directories == null) {
            return;
        }
        if (this.m_selectedDirectory != null) {
            this.removeSelectedDirectory();
        }
        item = directory;
        path = new Vector<WcmDlgItem>(10);
        while ((parent = item.getParent()) != null) {
            path.addElement(item);
            if (this.m_directories.contains(item)) {
                this.m_nTopIndex = this.m_directories.indexOf(item);
            }
            item = parent;
        }
        this.m_nPathCount = path.size();
        if (this.m_nTopIndex < 0 && this.m_directories.contains(item)) {
            this.m_nTopIndex = this.m_directories.indexOf(item);
        }
        for (int i = 0; i < path.size(); ++i) {
            this.m_directories.insertElementAt(path.elementAt(i), this.m_nTopIndex + 1);
        }
        this.setSelectedItem(directory);
    }

    public int getSize() {
        if (this.m_directories != null) {
            return this.m_directories.size();
        }
        return 0;
    }

    public Object getElementAt(int nIndex) throws ArrayIndexOutOfBoundsException {
        if (this.m_directories != null) {
            return this.m_directories.elementAt(nIndex);
        }
        return null;
    }

    public Object getSelectedItem() {
        return this.m_selectedDirectory;
    }

    public void setSelectedItem(Object selectedDirectory) {
        this.m_selectedDirectory = (WcmDlgItem)selectedDirectory;
        this.fireContentsChanged(this, -1, -1);
    }

    private void removeSelectedDirectory() {
        if (this.m_nTopIndex >= 0) {
            for (int i = this.m_nTopIndex; i < this.m_nTopIndex + this.m_nPathCount; ++i) {
                this.m_directories.removeElementAt(this.m_nTopIndex + 1);
            }
        }
        this.m_nTopIndex = -1;
        this.m_nPathCount = 0;
        this.m_selectedDirectory = null;
    }
}

