/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDateTableCellRenderer;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDirectoryModel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemRenderer;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgSelectionPanel;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class WcmDlgContentsPanel
extends JPanel
implements ListSelectionListener,
IVWMouseActionListener,
TableModelListener {
    public static final int VIEW_LIST = 0;
    public static final int VIEW_DETAILED = 1;
    public static final int VIEW_VERSIONS = 2;
    public static final String VIEW_LIST_LABEL = "List View";
    public static final String VIEW_DETAILED_LABEL = "Table view";
    public static final String VIEW_VERSIONS_LABEL = "Versions view";
    private int m_viewMode = 0;
    private CardLayout m_cardLayout;
    private WcmDlgDirectoryModel m_directoryModel;
    private JList m_contentsList;
    private VWTable m_contentsTable;
    private VWTable m_versionsTable;
    private WcmDlgSelectionPanel m_selectionPanel;

    public WcmDlgContentsPanel(WcmDlgSelectionPanel selectionPanel) {
        this.m_selectionPanel = selectionPanel;
        this.initLayout();
    }

    public void clearSelection() {
        switch (this.m_viewMode) {
            case 0: {
                if (this.m_contentsList == null) break;
                this.m_contentsList.clearSelection();
                break;
            }
            case 1: {
                if (this.m_contentsTable == null) break;
                this.m_contentsTable.clearSelection();
                break;
            }
            case 2: {
                if (this.m_versionsTable == null) break;
                this.m_versionsTable.clearSelection();
            }
        }
    }

    public void displayContents(WcmDlgItemImpl item) throws WcmException {
        if (this.m_directoryModel != null) {
            this.m_directoryModel.getContents(item);
        }
    }

    public void switchToListView() {
        if (this.m_viewMode == 0) {
            return;
        }
        this.m_contentsList.clearSelection();
        int nIndex = this.m_contentsTable.getSelectedRow();
        if (nIndex >= 0 && nIndex < this.m_contentsList.getModel().getSize()) {
            this.m_contentsList.ensureIndexIsVisible(nIndex);
            this.m_contentsList.setSelectedIndex(nIndex);
        }
        if (this.m_cardLayout != null) {
            this.m_cardLayout.show(this, VIEW_LIST_LABEL);
            this.m_viewMode = 0;
        }
    }

    public void switchToDetailView() {
        if (this.m_viewMode == 1) {
            return;
        }
        this.m_contentsTable.clearSelection();
        int nIndex = this.m_contentsList.getSelectedIndex();
        if (nIndex >= 0 && nIndex < this.m_contentsTable.getRowCount()) {
            this.m_contentsTable.setRowSelectionInterval(nIndex, nIndex);
        }
        if (this.m_cardLayout != null) {
            this.m_cardLayout.show(this, VIEW_DETAILED_LABEL);
            this.m_viewMode = 1;
        }
    }

    public void switchToVersionsView() {
        if (this.m_viewMode == 2) {
            return;
        }
        this.m_versionsTable.clearSelection();
        if (this.m_cardLayout != null) {
            this.m_cardLayout.show(this, VIEW_VERSIONS_LABEL);
            this.m_viewMode = 2;
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int nRowIndex = -1;
        WcmDlgItemImpl item = null;
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource() == this.m_contentsTable.getSelectionModel() && (nRowIndex = this.m_contentsTable.getSelectedRow()) >= 0) {
            item = (WcmDlgItemImpl)this.m_contentsTable.getModel().getValueAt(nRowIndex, 0);
            item.getParent().setLastSelectedRow(nRowIndex);
        }
        if (event.getSource() == this.m_versionsTable.getSelectionModel()) {
            nRowIndex = this.m_versionsTable.getSelectedRow();
            if (nRowIndex >= 0) {
                item = (WcmDlgItemImpl)this.m_versionsTable.getModel().getValueAt(nRowIndex, 0);
                item.getParent().setLastSelectedRow(nRowIndex);
            }
        } else if (event.getSource() == this.m_contentsList && (nRowIndex = this.m_contentsList.getSelectedIndex()) >= 0) {
            item = (WcmDlgItemImpl)this.m_contentsList.getModel().getElementAt(nRowIndex);
            item.getParent().setLastSelectedRow(nRowIndex);
        }
        if (item != null) {
            this.m_selectionPanel.setSelectedItem(item);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        WcmDlgItemImpl item = null;
        if (event.getSource() == this.m_contentsList) {
            int nIndex = this.m_contentsList.locationToIndex(event.getPoint());
            if (nIndex < 0) {
                return;
            }
            item = (WcmDlgItemImpl)this.m_contentsList.getModel().getElementAt(nIndex);
            if (item == null) {
                return;
            }
        } else if (event.getSource() == this.m_contentsTable) {
            int nRowIndex = this.m_contentsTable.rowAtPoint(event.getPoint());
            if (nRowIndex < 0) {
                return;
            }
            item = (WcmDlgItemImpl)this.m_contentsTable.getModel().getValueAt(nRowIndex, 0);
            if (item == null) {
                return;
            }
        } else if (event.getSource() == this.m_versionsTable) {
            int nRowIndex = this.m_versionsTable.rowAtPoint(event.getPoint());
            if (nRowIndex < 0) {
                return;
            }
            item = (WcmDlgItemImpl)this.m_versionsTable.getModel().getValueAt(nRowIndex, 0);
            if (item == null) {
                return;
            }
        }
        if (item.isDirectory()) {
            this.m_contentsList.clearSelection();
            this.m_selectionPanel.setCurrentDirectory(item);
        } else if (this.m_selectionPanel.setSelectedItem(item)) {
            this.m_selectionPanel.onApprove();
        }
    }

    public void createPopup(MouseEvent event) {
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 0: {
                if (this.m_viewMode == 1 && event.getFirstRow() == 0) {
                    this.m_contentsTable.sizeColumnsToFit(-1);
                    break;
                }
                if (this.m_viewMode != 2 || event.getFirstRow() != 0) break;
                this.m_versionsTable.sizeColumnsToFit(-1);
            }
        }
    }

    public int getViewMode() {
        return this.m_viewMode;
    }

    public WcmDlgDirectoryModel getDlgDirectoryModel() {
        return this.m_directoryModel;
    }

    private void initLayout() {
        WcmDlgItemRenderer itemRenderer = null;
        VWMouseAdapter mouseListener = null;
        try {
            this.m_cardLayout = new CardLayout();
            this.setLayout(this.m_cardLayout);
            itemRenderer = new WcmDlgItemRenderer();
            this.m_directoryModel = new WcmDlgDirectoryModel(this.m_selectionPanel);
            this.m_directoryModel.addTableModelListener(this);
            mouseListener = new VWMouseAdapter((IVWMouseActionListener)this);
            this.m_contentsList = new JList();
            this.m_contentsList.getSelectionModel().setSelectionMode(0);
            this.m_contentsList.setCellRenderer(itemRenderer);
            this.m_contentsList.setModel(this.m_directoryModel);
            this.m_contentsList.addListSelectionListener(this);
            this.m_contentsList.addMouseListener((MouseListener)mouseListener);
            this.m_contentsList.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (WcmDlgContentsPanel.this.m_contentsList.getSelectedIndex() < 0) {
                        int keyCode = evt.getKeyCode();
                        if (keyCode == 40) {
                            WcmDlgContentsPanel.this.m_contentsList.setSelectedIndex(0);
                            evt.consume();
                        } else if (keyCode == 38) {
                            int last = WcmDlgContentsPanel.this.m_contentsList.getModel().getSize() - 1;
                            WcmDlgContentsPanel.this.m_contentsList.ensureIndexIsVisible(last);
                            WcmDlgContentsPanel.this.m_contentsList.setSelectedIndex(last);
                            evt.consume();
                        }
                    }
                }
            });
            this.add((Component)new JScrollPane(this.m_contentsList), VIEW_LIST_LABEL);
            this.m_contentsTable = new VWTable((TableModel)this.m_directoryModel);
            this.m_contentsTable.setShowGrid(false);
            this.m_contentsTable.addKeyListener((KeyListener)new TabKeyListener());
            this.m_contentsTable.getSelectionModel().addListSelectionListener(this);
            this.m_contentsTable.getSelectionModel().setSelectionMode(0);
            this.m_contentsTable.setDefaultRenderer(WcmDlgItemImpl.class, (TableCellRenderer)itemRenderer);
            this.m_contentsTable.setDefaultRenderer(GregorianCalendar.class, (TableCellRenderer)new WcmDlgDateTableCellRenderer());
            this.m_contentsTable.setDefaultRenderer(String.class, (TableCellRenderer)new WcmDlgStringRenderer());
            this.m_contentsTable.setColumnSelectionAllowed(false);
            this.m_contentsTable.addMouseListener((MouseListener)mouseListener);
            this.add((Component)new JScrollPane((Component)this.m_contentsTable), VIEW_DETAILED_LABEL);
            this.m_versionsTable = new VWTable((TableModel)this.m_directoryModel);
            this.m_versionsTable.setShowGrid(false);
            this.m_versionsTable.addKeyListener((KeyListener)new TabKeyListener());
            this.m_versionsTable.getSelectionModel().addListSelectionListener(this);
            this.m_versionsTable.getSelectionModel().setSelectionMode(0);
            this.m_versionsTable.setDefaultRenderer(WcmDlgItemImpl.class, (TableCellRenderer)itemRenderer);
            this.m_versionsTable.setDefaultRenderer(GregorianCalendar.class, (TableCellRenderer)new WcmDlgDateTableCellRenderer());
            this.m_versionsTable.setColumnSelectionAllowed(false);
            this.m_versionsTable.addMouseListener((MouseListener)mouseListener);
            this.add((Component)new JScrollPane((Component)this.m_versionsTable), VIEW_VERSIONS_LABEL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRowSelection(int nIndex) {
        if (this.m_viewMode == 0) {
            this.m_contentsList.clearSelection();
            if (nIndex >= 0 && nIndex < this.m_contentsList.getModel().getSize()) {
                this.m_contentsList.ensureIndexIsVisible(nIndex);
                this.m_contentsList.setSelectedIndex(nIndex);
            }
            if (this.m_cardLayout != null) {
                this.m_cardLayout.show(this, VIEW_LIST_LABEL);
            }
        } else if (this.m_viewMode == 1) {
            this.m_contentsTable.clearSelection();
            if (nIndex >= 0 && nIndex < this.m_contentsTable.getRowCount()) {
                this.m_contentsTable.setRowSelectionInterval(nIndex, nIndex);
            }
            if (this.m_cardLayout != null) {
                this.m_cardLayout.show(this, VIEW_DETAILED_LABEL);
            }
        } else {
            this.m_versionsTable.clearSelection();
            if (nIndex >= 0 && nIndex < this.m_versionsTable.getRowCount()) {
                this.m_versionsTable.setRowSelectionInterval(nIndex, nIndex);
            }
            if (this.m_cardLayout != null) {
                this.m_cardLayout.show(this, VIEW_VERSIONS_LABEL);
            }
        }
    }

    public int getRowSelection() {
        if (this.m_viewMode == 0) {
            return this.m_contentsList.getSelectedIndex();
        }
        if (this.m_viewMode == 1) {
            return this.m_contentsTable.getSelectedRow();
        }
        return this.m_versionsTable.getSelectedRow();
    }

    private void moveToNewRow(boolean forward, VWTable table) {
        if (!forward && table.getRowCount() == 0) {
            table.transferFocus();
            return;
        }
        int row = table.getSelectedRow();
        int column = table.getSelectedColumn();
        if (column == -1) {
            column = 0;
        }
        if (forward) {
            if (++row == table.getRowCount()) {
                row = 0;
            }
        } else if (--row < 0) {
            row = table.getRowCount() - 1;
        }
        ListSelectionModel rowSelection = table.getSelectionModel();
        ListSelectionModel colSelection = table.getColumnModel().getSelectionModel();
        rowSelection.setSelectionInterval(row, row);
        colSelection.setSelectionInterval(column, column);
    }

    public class WcmDlgStringRenderer
    extends DefaultTableCellRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer m_listRenderer;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
            renderer.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            return renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.m_listRenderer == null) {
                this.m_listRenderer = new DefaultListCellRenderer();
            }
            Component renderer = this.m_listRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            return renderer;
        }
    }

    private class TabKeyListener
    extends KeyAdapter {
        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 9) {
                if (evt.isShiftDown()) {
                    if (WcmDlgContentsPanel.this.m_viewMode == 1) {
                        WcmDlgContentsPanel.this.moveToNewRow(false, WcmDlgContentsPanel.this.m_contentsTable);
                    } else {
                        WcmDlgContentsPanel.this.moveToNewRow(false, WcmDlgContentsPanel.this.m_versionsTable);
                    }
                } else if (WcmDlgContentsPanel.this.m_viewMode == 1) {
                    WcmDlgContentsPanel.this.moveToNewRow(true, WcmDlgContentsPanel.this.m_contentsTable);
                } else {
                    WcmDlgContentsPanel.this.moveToNewRow(true, WcmDlgContentsPanel.this.m_versionsTable);
                }
                evt.consume();
            }
        }
    }
}

