/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassTreeCellRenderer;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassTreeDialog;
import com.filenet.wcm.toolkit.client.util.WcmClassDescsDom;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WcmDlgClassTreePanel
extends JPanel {
    private DefaultMutableTreeNode m_rootNode;
    private DefaultTreeModel m_treeModel;
    private JTree m_tree;
    private DefaultTreeCellRenderer m_renderer;
    private ObjectStore m_objectStore;
    private Document m_oDoc;
    private Element m_oRootCD;
    private WcmDlgClassTreeDialog m_parent;
    private boolean m_filterHiddenClasses;

    public WcmDlgClassTreePanel(WcmDlgClassTreeDialog parent, ObjectStore os, Document oDoc, boolean filterHiddenClasses) throws Exception {
        this.m_parent = parent;
        this.m_objectStore = os;
        this.m_oDoc = oDoc;
        this.m_filterHiddenClasses = filterHiddenClasses;
        WcmDlgClassDescItem cdItem = this.getTopFirstClass(oDoc);
        this.m_rootNode = new DefaultMutableTreeNode(cdItem);
        this.m_treeModel = new DefaultTreeModel(this.m_rootNode);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        this.m_tree.addTreeSelectionListener(this.m_parent);
        VWMouseAdapter mouseListener = new VWMouseAdapter((IVWMouseActionListener)this.m_parent);
        this.m_tree.addMouseListener((MouseListener)mouseListener);
        TreeUI ui = this.m_tree.getUI();
        if (ui instanceof BasicTreeUI) {
            ((BasicTreeUI)ui).setCollapsedIcon(WcmImageLoader.createImageIcon("action/Collapse16.gif"));
            ((BasicTreeUI)ui).setExpandedIcon(WcmImageLoader.createImageIcon("action/Expand16.gif"));
        }
        this.m_renderer = new WcmDlgClassTreeCellRenderer();
        this.m_renderer.setOpenIcon(WcmImageLoader.createImageIcon("action/Choices16.gif"));
        this.m_renderer.setClosedIcon(WcmImageLoader.createImageIcon("action/Choices16.gif"));
        this.m_renderer.setLeafIcon(WcmImageLoader.createImageIcon("action/Choices16.gif"));
        this.m_tree.setCellRenderer(this.m_renderer);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        this.initTree();
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        this.add((Component)scrollPane, "Center");
    }

    public Object getValue() {
        Object objValue = null;
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
            if (node != null) {
                objValue = node.getUserObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objValue;
    }

    public JTree getTree() {
        return this.m_tree;
    }

    private DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.m_tree.getSelectionPath();
        boolean isVisible = false;
        if (parentPath == null) {
            parentNode = this.m_rootNode;
            isVisible = true;
        } else {
            parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        }
        return this.addObject(parentNode, child, isVisible);
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, true);
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean isVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.m_rootNode;
        }
        this.m_treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (isVisible) {
            this.m_tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    private Vector getSiblingClasses(Element oParent) throws Exception {
        Vector<Element> cList = new Vector<Element>();
        Element oChild = WcmClassDescsDom.getChildElement(oParent, "classdesc");
        while (oChild != null) {
            Node oSibling;
            cList.add(oChild);
            for (oSibling = oChild.getNextSibling(); oSibling != null && !(oSibling instanceof Element); oSibling = oSibling.getNextSibling()) {
            }
            oChild = (Element)oSibling;
        }
        return cList;
    }

    private void initTree() throws Exception {
        Vector cList;
        if (this.m_oDoc != null && (cList = this.getSiblingClasses(this.m_oRootCD)) != null && cList.size() > 0) {
            this.populateChoiceItems(this.m_rootNode, cList, true);
        }
    }

    private void populateChoiceItems(DefaultMutableTreeNode ParentNode, Vector cList, boolean isVisible) throws Exception {
        if (cList != null && cList.size() > 0) {
            for (Element oElem : cList) {
                Element oId = WcmClassDescsDom.getChildElement(oElem, "id");
                String sGuid = WcmClassDescsDom.getValue(oId);
                ClassDescription cd = (ClassDescription)this.m_objectStore.getObject(25, sGuid);
                WcmDlgClassDescItem cdItem = new WcmDlgClassDescItem(cd);
                if (this.m_filterHiddenClasses && cdItem.getIsHidden()) continue;
                DefaultMutableTreeNode node = this.addObject(ParentNode, cdItem, isVisible);
                cList = this.getSiblingClasses(oElem);
                if (cList == null || cList.size() <= 0) continue;
                this.populateChoiceItems(node, cList, false);
            }
        }
    }

    private WcmDlgClassDescItem getTopFirstClass(Document oDoc) throws Exception {
        WcmDlgClassDescItem cdItem = null;
        Object sName = null;
        try {
            Element oRoot = oDoc.getDocumentElement();
            this.m_oRootCD = WcmClassDescsDom.getChildElement(oRoot, "classdesc");
            if (this.m_oRootCD != null) {
                Element oId = WcmClassDescsDom.getChildElement(this.m_oRootCD, "id");
                String sGuid = WcmClassDescsDom.getValue(oId);
                ClassDescription cd = (ClassDescription)this.m_objectStore.getObject(25, sGuid);
                cdItem = new WcmDlgClassDescItem(cd);
            }
        }
        catch (Exception ex) {
            System.out.println(" Failed to get top first class. Exception - " + ex.getMessage());
            throw ex;
        }
        return cdItem;
    }
}

