/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.common.WcmNonEditableTextField;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassTreePanel;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.w3c.dom.Document;

public class WcmDlgClassTreeDialog
extends JDialog
implements ActionListener,
TreeSelectionListener,
IVWMouseActionListener {
    private JTextField m_textField;
    private JLabel m_selLabel;
    private JLabel m_choiceLabel;
    private WcmDlgClassTreePanel m_classTreePanel;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JPanel m_okCancelPanel;
    private static int status = 1;
    private Document m_oDoc;
    private ObjectStore m_objectStore;
    private WcmDlgClassDescItem m_selectedCD;
    private Window m_parent;
    private boolean m_filterHiddenClasses;

    public WcmDlgClassTreeDialog(Frame parent, ObjectStore os, Document oDoc, ClassDescription cd, boolean filterHiddenClasses) throws Exception {
        super(parent, true);
        WcmDlgFactory.checkParam(os);
        this.m_parent = parent;
        this.m_objectStore = os;
        this.m_oDoc = oDoc;
        this.m_selectedCD = new WcmDlgClassDescItem(cd);
        this.m_filterHiddenClasses = filterHiddenClasses;
        this.init(parent);
    }

    public WcmDlgClassTreeDialog(Dialog parent, ObjectStore os, Document oDoc, ClassDescription cd, boolean filterHiddenClasses) throws Exception {
        super(parent, true);
        WcmDlgFactory.checkParam(os);
        this.m_parent = parent;
        this.m_objectStore = os;
        this.m_oDoc = oDoc;
        this.m_selectedCD = new WcmDlgClassDescItem(cd);
        this.m_filterHiddenClasses = filterHiddenClasses;
        this.init(parent);
    }

    private void init(Container parent) {
        try {
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dimension = WcmStringUtil.stringToDimension(WcmResourceString.s_classTreeDiaglogDim);
            if (dimension == null) {
                dimension = new Dimension(500, 350);
            }
            this.setSize(dimension);
            this.setLocationRelativeTo(parent);
            this.setTitle(WcmResourceString.w_selectAClass.toString(this.m_objectStore.getName()));
            this.createControls();
            this.layoutComponents();
            this.m_textField.setText(this.m_selectedCD.toString());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    WcmDlgClassTreeDialog.this.setVisible(false);
                }
            });
            this.applyComponentOrientation(this.m_parent.getComponentOrientation());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public WcmDlgClassDescItem getSelected() {
        return this.m_selectedCD;
    }

    protected void createControls() throws Exception {
        this.m_selLabel = new JLabel(WcmUIComponentResource.SELECTED_CHOICE);
        this.m_textField = new WcmNonEditableTextField();
        this.m_choiceLabel = new JLabel(WcmUIComponentResource.AVAILABLE_CHOICE);
        this.m_classTreePanel = new WcmDlgClassTreePanel(this, this.m_objectStore, this.m_oDoc, this.m_filterHiddenClasses);
        this.m_okCancelPanel = this.createButtonPanel();
    }

    protected void layoutComponents() {
        GridBagConstraints gbCons = null;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 6, 1, 6);
        cp.add((Component)this.m_selLabel, gbCons);
        ++gbCons.gridy;
        gbCons.weightx = 0.9;
        cp.add((Component)this.m_textField, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(6, 6, 1, 6);
        cp.add((Component)this.m_choiceLabel, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 0.9;
        gbCons.weighty = 1.0;
        cp.add((Component)this.m_classTreePanel, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridwidth = 0;
        cp.add((Component)this.m_okCancelPanel, gbCons);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_okButton) {
            status = 0;
            this.setVisible(false);
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
        } else if (e.getSource() == this.m_cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.m_okButton = new JButton(WcmUIComponentResource.OK);
        this.m_okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.m_okButton, gbCons);
        ++gbCons.gridx;
        this.m_cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.m_cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.m_cancelButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    public void valueChanged(TreeSelectionEvent event) {
        Object objValue;
        if (event.getSource() == this.m_classTreePanel.getTree() && (objValue = this.m_classTreePanel.getValue()) != null) {
            this.m_selectedCD = (WcmDlgClassDescItem)objValue;
            this.m_textField.setText(objValue.toString());
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        Object objValue;
        if (event.getSource() == this.m_classTreePanel.getTree() && (objValue = this.m_classTreePanel.getValue()) != null) {
            this.m_selectedCD = (WcmDlgClassDescItem)objValue;
            this.m_textField.setText(objValue.toString());
            status = 0;
            this.setVisible(false);
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void createPopup(MouseEvent event) {
    }
}

