/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Domain;
import com.filenet.wcm.api.Domains;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.util.WcmException;

public class WcmDlgClassDescItem {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    private ClassDescription m_classDescription;
    private String m_className;
    private String m_id;
    private int m_classStatus = 0;
    private boolean m_isHidden;
    private int m_objType;

    public WcmDlgClassDescItem(ClassDescription cd) throws WcmException {
        try {
            this.m_classDescription = cd;
            this.m_className = this.m_classDescription.getPropertyStringValue("DisplayName");
            this.m_isHidden = this.m_classDescription.getPropertyBooleanValue("IsHidden");
            this.m_id = cd.getId();
            this.m_objType = this.m_classDescription.getPropertyIntValue("ObjectType");
        }
        catch (PropertyNotFoundException pnfe) {
            System.out.println("constructor exception on creating the WcmDlgClassDescItem" + pnfe.getMessage());
            pnfe.printStackTrace();
            throw new WcmException("client.WcmDlgClassDescItem.PropertyNotFound", "Property Not Found Exception");
        }
    }

    public WcmDlgClassDescItem(String classId, WcmDlgItemImpl item) throws WcmException {
        if (item.getItemType() == 1) {
            if (!item.hasContents()) {
                ObjectStores oss = null;
                EntireNetwork network = item.getEntireNetworkObject();
                Domains domains = network.getDomains();
                if (domains.size() > 0) {
                    Domain curDomain = (Domain)domains.get(0);
                    oss = curDomain.getObjectStores();
                }
                try {
                    item.initObjectStores(oss);
                }
                catch (Exception ex) {
                    System.out.println("constructor exception on creating the WcmDlgClassDescItem" + ex.getMessage());
                    ex.printStackTrace();
                    throw new WcmException("client.WcmDlgClassDescItem.UnexpectedException", "Exception - {0}", (Object)ex.getMessage());
                }
            }
            int cnt = item.getContaineeCount();
            WcmDlgItemImpl[] osItems = item.getContents();
            boolean foundGoodOS = false;
            while (cnt > 0 && !foundGoodOS) {
                WcmDlgItemImpl osItem;
                if ((osItem = osItems[--cnt]).getObjectStoreIsDown()) continue;
                try {
                    this.m_classDescription = (ClassDescription)((ObjectStore)osItem.getWcmObject()).getObject(25, classId);
                    this.m_className = this.m_classDescription.getPropertyStringValue("DisplayName");
                    this.m_isHidden = this.m_classDescription.getPropertyBooleanValue("IsHidden");
                    this.m_id = this.m_classDescription.getId();
                    this.m_objType = this.m_classDescription.getPropertyIntValue("ObjectType");
                    foundGoodOS = true;
                }
                catch (PropertyNotFoundException pnfe) {
                    System.out.println("constructor exception on creating the WcmDlgClassDescItem" + pnfe.getMessage());
                    pnfe.printStackTrace();
                    throw new WcmException("client.WcmDlgClassDescItem.PropertyNotFound", "Property Not Found Exception");
                }
                catch (Exception ex) {
                    System.out.println("constructor exception on creating the WcmDlgClassDescItem (object store is down)" + ex.getMessage());
                    ex.printStackTrace();
                    osItem.setObjectStoreIsDown();
                }
            }
            if (!foundGoodOS) {
                System.out.println("constructor exception on creating the WcmDlgClassDescItem (failed to find a working object store)");
                throw new WcmException("client.WcmDlgClassDescItem.NoWorkingObjectStores", "Cannot launch add wizard - failed to find a working object store");
            }
        } else {
            try {
                this.m_classDescription = (ClassDescription)((ObjectStore)item.getObjectStore().getWcmObject()).getObject(25, classId);
                this.m_className = this.m_classDescription.getPropertyStringValue("DisplayName");
                this.m_isHidden = this.m_classDescription.getPropertyBooleanValue("IsHidden");
                this.m_id = this.m_classDescription.getId();
                this.m_objType = this.m_classDescription.getPropertyIntValue("ObjectType");
            }
            catch (PropertyNotFoundException pnfe) {
                System.out.println("constructor exception on creating the WcmDlgClassDescItem " + pnfe.getMessage());
                pnfe.printStackTrace();
                throw new WcmException("client.WcmDlgClassDescItem.PropertyNotFound", "Property Not Found Exception");
            }
            catch (Exception ex) {
                System.out.println("constructor exception on creating the WcmDlgClassDescItem " + ex.getMessage());
                ex.printStackTrace();
                throw new WcmException("client.WcmDlgClassDescItem.UnexpectedException", "Exception - {0}", (Object)ex.getMessage());
            }
        }
    }

    public String toString() {
        return this.m_className;
    }

    public ClassDescription getClassDescription() {
        return this.m_classDescription;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getId() {
        return this.m_id;
    }

    public void setClassStatus(int status) {
        this.m_classStatus = status;
    }

    public int getClassStatus() {
        return this.m_classStatus;
    }

    public boolean getIsHidden() {
        return this.m_isHidden;
    }

    public int getObjectType() {
        return this.m_objType;
    }
}

