/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgContentsPanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDirectoryComboBoxModel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDirectoryComboBoxRenderer;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemChooserDialog;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgSelectionPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class WcmDlgBrowsePanel
extends JPanel
implements ActionListener,
TableModelListener {
    private static final Dimension HSTRUT5 = new Dimension(5, 1);
    private static final Dimension HSTRUT10 = new Dimension(10, 1);
    private static final Dimension HSTRUT25 = new Dimension(25, 1);
    private static final Insets INSETS0 = new Insets(0, 0, 0, 0);
    private JComboBox m_directoryComboBox;
    private WcmDlgDirectoryComboBoxModel m_directoryComboBoxModel;
    private JButton m_upButton;
    private JButton m_homeButton;
    private JToggleButton m_versionListButton;
    private JToggleButton m_listViewButton;
    private JToggleButton m_detailViewButton;
    private JButton m_newFolderButton;
    private JButton m_deleteButton;
    private JButton m_propertiesButton;
    private JButton m_refreshButton;
    private WcmDlgContentsPanel m_contentsPane;
    private JButton m_othersButton;
    private JButton m_openButton;
    private JButton m_cancelButton;
    private JRadioButton m_checkoutRadioButton;
    private JRadioButton m_copyRadioButton;
    private JButton m_selectButton;
    private JRadioButton m_releasedRadioButton;
    private JRadioButton m_currentRadioButton;
    private JPanel m_versionChoice;
    private WcmDlgSelectionPanel m_selectionPanel;
    private JPanel m_showContentsPanel;
    private JTextArea m_jtxOverMax;

    public WcmDlgBrowsePanel(WcmDlgSelectionPanel selectionPanel) {
        this.m_selectionPanel = selectionPanel;
        this.initLayout();
        this.m_selectionPanel.getItemChooserDialog().addWindowListener(new WindowHandler());
    }

    public int getMode() {
        if (this.m_selectionPanel.getItemChooserDialog().isDirectorySelectionOnly()) {
            return 0;
        }
        if (this.m_checkoutRadioButton != null && this.m_checkoutRadioButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    public int getVersionChoice() {
        if (this.m_releasedRadioButton == null) {
            return 0;
        }
        if (this.m_releasedRadioButton.isSelected()) {
            return 1;
        }
        if (this.m_currentRadioButton.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void setCurrentDirectory(WcmDlgItemImpl currentDirectory) throws WcmException {
        this.turnOffVersionsMode();
        if (this.m_contentsPane != null) {
            this.m_contentsPane.displayContents(currentDirectory);
        }
        if (currentDirectory != null && this.m_directoryComboBoxModel != null) {
            this.m_directoryComboBoxModel.addItem(currentDirectory);
        }
        int selectedRow = currentDirectory.getLastSelectedRow();
        this.m_contentsPane.setRowSelection(selectedRow);
        if (selectedRow < 0) {
            this.m_openButton.setEnabled(false);
        }
        this.m_newFolderButton.setEnabled(this.canContainFolder(currentDirectory));
    }

    public void setSelectedItem(WcmDlgItemImpl selectedItem) {
        if (selectedItem == null) {
            return;
        }
        this.m_deleteButton.setEnabled(this.isDeletableItem(selectedItem));
        this.m_propertiesButton.setEnabled(this.canViewProperties(selectedItem));
        this.m_openButton.setEnabled(this.isApprovableItem(selectedItem));
        if (selectedItem.getItemType() == 4) {
            int curRowSelection = this.m_contentsPane.getRowSelection();
            if (selectedItem.refreshVersionState()) {
                try {
                    this.m_contentsPane.displayContents(selectedItem.getParent());
                    this.m_contentsPane.setRowSelection(curRowSelection);
                }
                catch (Exception ex) {
                    System.out.println("[Internal Error] failed to update version state " + ex.getMessage());
                }
            }
            selectedItem.getParent().setLastSelectedRow(curRowSelection);
            this.m_versionListButton.setEnabled(true);
            if (this.m_checkoutRadioButton != null && this.m_copyRadioButton != null) {
                if (selectedItem.canCheckout()) {
                    this.m_checkoutRadioButton.setEnabled(true);
                    this.m_checkoutRadioButton.setSelected(true);
                    this.m_copyRadioButton.setSelected(false);
                } else {
                    this.m_checkoutRadioButton.setEnabled(false);
                    this.m_checkoutRadioButton.setSelected(false);
                    this.m_copyRadioButton.setSelected(true);
                }
                this.m_copyRadioButton.setEnabled(true);
            }
            if (!selectedItem.isVersionItem() && this.m_versionChoice != null) {
                this.m_versionChoice.setVisible(true);
                this.m_releasedRadioButton.setEnabled(this.isReleasedChoiceAvailable());
                this.m_releasedRadioButton.setSelected(this.isReleasedChoiceAvailable());
                this.m_currentRadioButton.setSelected(!this.isReleasedChoiceAvailable());
                this.m_currentRadioButton.setEnabled(true);
            }
        } else {
            if (this.isSelectFolderDialog()) {
                this.m_selectButton.setEnabled(selectedItem.getItemType() == 3 || this.isRootFolderSelectable() && selectedItem.getItemType() == 2);
            }
            this.m_versionListButton.setSelected(false);
            this.m_versionListButton.setEnabled(false);
            if (this.m_checkoutRadioButton != null) {
                this.m_checkoutRadioButton.setSelected(false);
                this.m_checkoutRadioButton.setEnabled(false);
            }
            if (this.m_copyRadioButton != null) {
                this.m_copyRadioButton.setSelected(false);
                this.m_copyRadioButton.setEnabled(false);
            }
            if (this.m_versionChoice != null) {
                this.m_versionChoice.setVisible(false);
                this.m_releasedRadioButton.setSelected(false);
                this.m_releasedRadioButton.setEnabled(false);
                this.m_currentRadioButton.setSelected(false);
                this.m_currentRadioButton.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        WcmDlgItemChooserDialog itemDialog = this.m_selectionPanel.getItemChooserDialog();
        if (event.getSource() == this.m_directoryComboBox) {
            this.m_directoryComboBox.hidePopup();
            WcmDlgItemImpl item = (WcmDlgItemImpl)this.m_directoryComboBox.getSelectedItem();
            this.m_selectionPanel.setCurrentDirectory(item);
        } else if (event.getSource() == this.m_upButton) {
            this.m_selectionPanel.changeToParentDirectory();
        } else if (event.getSource() == this.m_homeButton) {
            this.m_selectionPanel.setCurrentDirectory(null);
        } else if (event.getSource() == this.m_versionListButton) {
            this.performVersionList(itemDialog);
        } else if (event.getSource() == this.m_listViewButton) {
            if (this.m_contentsPane != null) {
                this.m_contentsPane.switchToListView();
            }
        } else if (event.getSource() == this.m_detailViewButton) {
            if (this.m_contentsPane != null) {
                this.m_contentsPane.switchToDetailView();
            }
            this.redisplayCurrentContents(itemDialog);
        } else if (event.getSource() == this.m_newFolderButton) {
            if (this.m_selectionPanel != null) {
                this.m_selectionPanel.addNewFolder();
            }
        } else if (event.getSource() == this.m_deleteButton) {
            if (this.m_selectionPanel != null && this.m_selectionPanel.deleteItem()) {
                this.m_deleteButton.setEnabled(false);
                this.m_propertiesButton.setEnabled(false);
                this.m_versionListButton.setEnabled(false);
            }
        } else if (event.getSource() == this.m_propertiesButton) {
            if (this.m_selectionPanel != null) {
                this.m_selectionPanel.showProperties();
            }
        } else if (event.getSource() == this.m_refreshButton) {
            this.refreshContents(itemDialog, true);
        } else if (event.getSource() == this.m_othersButton) {
            if (this.m_selectionPanel != null) {
                this.m_selectionPanel.onOthers();
            }
        } else if (event.getSource() == this.m_checkoutRadioButton) {
            if (this.m_versionChoice != null) {
                this.m_releasedRadioButton.setEnabled(this.isReleasedChoiceAvailable());
                this.m_currentRadioButton.setSelected(!this.isReleasedChoiceAvailable());
            }
        } else if (event.getSource() == this.m_copyRadioButton) {
            if (this.m_versionChoice != null) {
                this.m_releasedRadioButton.setEnabled(this.isReleasedChoiceAvailable());
                this.m_releasedRadioButton.setSelected(this.isReleasedChoiceAvailable());
            }
        } else if (event.getSource() == this.m_openButton) {
            WcmDlgItemImpl selectedItem = this.m_selectionPanel.getSelectedItem();
            WcmDlgItemImpl dir = this.m_selectionPanel.getCurrentDirectory();
            if (selectedItem != null) {
                if (selectedItem.isDirectory()) {
                    this.m_selectionPanel.setCurrentDirectory(selectedItem);
                } else {
                    this.m_selectionPanel.onApprove();
                }
                return;
            }
            this.m_selectionPanel.setSelectedItem(null);
        } else if (event.getSource() == this.m_selectButton) {
            this.m_selectionPanel.onApprove();
        } else if (event.getSource() == this.m_cancelButton) {
            this.m_selectionPanel.onCancel();
        }
    }

    public int getViewMode() {
        return this.m_contentsPane.getViewMode();
    }

    public JButton getDefaultButton() {
        if (this.isSelectFolderDialog()) {
            return this.m_selectButton;
        }
        return this.m_openButton;
    }

    private float getPanelAlignment() {
        float panelAlignment = 0.0f;
        Container parentContainer = this.m_selectionPanel.getParentContainer();
        if (parentContainer != null && !parentContainer.getComponentOrientation().isLeftToRight()) {
            panelAlignment = 1.0f;
        }
        return panelAlignment;
    }

    private void initLayout() {
        try {
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.getToolBarPanel(), "First");
            this.m_showContentsPanel = new JPanel(new BorderLayout());
            String strItemTypes = this.getItemTypesString(this.m_selectionPanel.getItemChooserDialog().getFilterTypes());
            this.m_jtxOverMax = new JTextArea(WcmResourceString.s_itemOverMax.toString(strItemTypes)){

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            this.m_jtxOverMax.setLineWrap(true);
            this.m_jtxOverMax.setWrapStyleWord(true);
            this.m_jtxOverMax.setEditable(false);
            this.m_jtxOverMax.setVisible(false);
            this.m_jtxOverMax.setBackground(this.getBackground());
            this.m_showContentsPanel.add((Component)this.m_jtxOverMax, "First");
            this.m_contentsPane = new WcmDlgContentsPanel(this.m_selectionPanel);
            this.m_contentsPane.getDlgDirectoryModel().addTableModelListener(this);
            this.m_showContentsPanel.add((Component)this.m_contentsPane, "Center");
            this.add((Component)this.m_showContentsPanel, "Center");
            this.add((Component)this.getButtonPanel(), "After");
            this.m_directoryComboBox.setSelectedIndex(this.m_directoryComboBoxModel.getSize() - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getItemTypesString(int[] nTypes) {
        String strTypes = WcmResourceString.s_document;
        if (nTypes == null) {
            return strTypes;
        }
        String strTempTypes = "";
        for (int i = 0; i < nTypes.length; ++i) {
            if (nTypes[i] == -100) {
                if (strTempTypes.length() > 0) {
                    strTempTypes = strTempTypes + WcmResourceString.s_and;
                }
                strTempTypes = strTempTypes + WcmResourceString.s_search;
                continue;
            }
            if (nTypes[i] == -101) {
                if (strTempTypes.length() > 0) {
                    strTempTypes = strTempTypes + WcmResourceString.s_and;
                }
                strTempTypes = strTempTypes + WcmResourceString.s_publishTemplate;
                continue;
            }
            if (nTypes[i] != 1160) continue;
            if (strTempTypes.length() > 0) {
                strTempTypes = strTempTypes + WcmResourceString.s_and;
            }
            strTempTypes = strTempTypes + WcmResourceString.s_processDefinition;
        }
        if (strTempTypes.length() > 0) {
            strTypes = strTempTypes;
        }
        return strTypes;
    }

    private JPanel getToolBarPanel() {
        JPanel panel = null;
        JLabel label = null;
        try {
            panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 2));
            label = new JLabel(WcmResourceString.s_lookin);
            label.setDisplayedMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_lookinNMonic));
            float panelAlignment = this.getPanelAlignment();
            label.setAlignmentX(panelAlignment);
            label.setAlignmentY(0.5f);
            panel.add(Box.createRigidArea(HSTRUT10));
            panel.add(label);
            panel.add(Box.createRigidArea(HSTRUT10));
            this.m_directoryComboBox = new BidiComboBox(this.m_selectionPanel.getComponentOrientation());
            this.m_directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
            label.setLabelFor(this.m_directoryComboBox);
            this.m_directoryComboBoxModel = new WcmDlgDirectoryComboBoxModel(this.m_selectionPanel.getCurrentDirectory());
            this.m_directoryComboBox.setModel(this.m_directoryComboBoxModel);
            this.m_directoryComboBox.setSelectedIndex(-1);
            this.m_directoryComboBox.addActionListener(this);
            this.m_directoryComboBox.setRenderer(new WcmDlgDirectoryComboBoxRenderer());
            this.m_directoryComboBox.setAlignmentX(panelAlignment);
            this.m_directoryComboBox.setAlignmentY(0.5f);
            panel.add(this.m_directoryComboBox);
            panel.add(Box.createRigidArea(HSTRUT10));
            this.m_upButton = WcmImageLoader.createIconButton("action/button/UpOneLevel16.gif", WcmResourceString.s_upOneLevelToolTip);
            this.m_upButton.setAlignmentX(panelAlignment);
            this.m_upButton.setAlignmentY(0.5f);
            this.m_upButton.setMargin(INSETS0);
            this.m_upButton.addActionListener(this);
            panel.add(this.m_upButton);
            this.m_homeButton = WcmImageLoader.createIconButton("action/button/Home16.gif", WcmResourceString.s_homeToolTip);
            this.m_homeButton.setAlignmentX(panelAlignment);
            this.m_homeButton.setAlignmentY(0.5f);
            this.m_homeButton.setMargin(INSETS0);
            this.m_homeButton.addActionListener(this);
            panel.add(this.m_homeButton);
            panel.add(Box.createRigidArea(HSTRUT5));
            this.m_versionListButton = WcmImageLoader.createIconToggleButton("action/button/VersionList16.gif", WcmResourceString.s_versionListToolTip);
            this.m_versionListButton.setAlignmentX(panelAlignment);
            this.m_versionListButton.setAlignmentY(0.5f);
            this.m_versionListButton.setMargin(INSETS0);
            this.m_versionListButton.setEnabled(false);
            this.m_versionListButton.setSelected(false);
            this.m_versionListButton.addActionListener(this);
            panel.add(this.m_versionListButton);
            panel.add(Box.createRigidArea(HSTRUT5));
            this.m_listViewButton = new JToggleButton((Icon)WcmImageLoader.createImageIcon("action/button/ViewList16.gif")){

                public boolean isFocusTraversable() {
                    return !WcmDlgBrowsePanel.this.m_listViewButton.isSelected();
                }
            };
            this.m_listViewButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_listViewButton.setToolTipText(WcmResourceString.s_listToolTip);
            this.m_listViewButton.setActionCommand(WcmResourceString.s_listToolTip);
            this.m_listViewButton.setEnabled(true);
            this.m_listViewButton.setSelected(true);
            this.m_listViewButton.setAlignmentX(panelAlignment);
            this.m_listViewButton.setAlignmentY(0.5f);
            this.m_listViewButton.setMargin(INSETS0);
            this.m_listViewButton.addActionListener(this);
            panel.add(this.m_listViewButton);
            this.m_detailViewButton = new JToggleButton((Icon)WcmImageLoader.createImageIcon("action/button/ViewDetails16.gif")){

                public boolean isFocusTraversable() {
                    return !WcmDlgBrowsePanel.this.m_detailViewButton.isSelected();
                }
            };
            this.m_detailViewButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_detailViewButton.setToolTipText(WcmResourceString.s_detailsToolTip);
            this.m_detailViewButton.setActionCommand(WcmResourceString.s_detailsToolTip);
            this.m_detailViewButton.setSelected(false);
            this.m_detailViewButton.setEnabled(true);
            this.m_detailViewButton.setAlignmentX(panelAlignment);
            this.m_detailViewButton.setAlignmentY(0.5f);
            this.m_detailViewButton.setMargin(INSETS0);
            this.m_detailViewButton.addActionListener(this);
            panel.add(this.m_detailViewButton);
            panel.add(Box.createRigidArea(HSTRUT5));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.m_listViewButton);
            bg.add(this.m_detailViewButton);
            this.m_newFolderButton = WcmImageLoader.createIconButton("action/button/NewFolder16.gif", WcmResourceString.s_addNewFolder);
            this.m_newFolderButton.setEnabled(false);
            this.m_newFolderButton.setAlignmentX(panelAlignment);
            this.m_newFolderButton.setAlignmentY(0.5f);
            this.m_newFolderButton.setMargin(INSETS0);
            this.m_newFolderButton.addActionListener(this);
            panel.add(this.m_newFolderButton);
            this.m_deleteButton = WcmImageLoader.createIconButton("action/Delete16.gif", WcmResourceString.s_delete);
            this.m_deleteButton.setEnabled(false);
            this.m_deleteButton.setAlignmentX(panelAlignment);
            this.m_deleteButton.setAlignmentY(0.5f);
            this.m_deleteButton.setMargin(INSETS0);
            this.m_deleteButton.addActionListener(this);
            panel.add(this.m_deleteButton);
            this.m_propertiesButton = WcmImageLoader.createIconButton("action/Properties16.gif", WcmResourceString.s_properties);
            this.m_propertiesButton.setEnabled(false);
            this.m_propertiesButton.setAlignmentX(panelAlignment);
            this.m_propertiesButton.setAlignmentY(0.5f);
            this.m_propertiesButton.setMargin(INSETS0);
            this.m_propertiesButton.addActionListener(this);
            panel.add(this.m_propertiesButton);
            this.m_refreshButton = WcmImageLoader.createIconButton("action/button/Refresh16.gif", WcmResourceString.s_refreshToolTip);
            this.m_refreshButton.setEnabled(true);
            this.m_refreshButton.setAlignmentX(panelAlignment);
            this.m_refreshButton.setAlignmentY(0.5f);
            this.m_refreshButton.setMargin(INSETS0);
            this.m_refreshButton.addActionListener(this);
            panel.add(this.m_refreshButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel mainPanel = null;
        JPanel upPanel = null;
        JPanel downPanel = null;
        WcmDlgItemChooserDialog itemChooserDialog = null;
        GridBagConstraints gbConst = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 23, 2, new Insets(5, 0, 5, 0), 0, 0);
        try {
            upPanel = new JPanel();
            upPanel.add(Box.createVerticalBox());
            downPanel = new JPanel();
            downPanel.setLayout(new GridBagLayout());
            itemChooserDialog = this.m_selectionPanel.getItemChooserDialog();
            if (itemChooserDialog.isBrowseOthers()) {
                this.m_othersButton = new JButton(WcmResourceString.s_others);
                this.m_othersButton.setMnemonic(this.getOthersButtonMnemonic(itemChooserDialog));
                this.m_othersButton.addActionListener(this);
                this.m_othersButton.setToolTipText(this.getOthersButtonToolTipText(itemChooserDialog));
                downPanel.add((Component)this.m_othersButton, gbConst);
            }
            if (itemChooserDialog.isBrowseToOpen()) {
                JPanel openAs = new JPanel();
                Dimension dim = WcmStringUtil.stringToDimension(WcmResourceString.s_openAsPanelDim);
                if (dim == null) {
                    dim = new Dimension(100, 80);
                }
                openAs.setPreferredSize(dim);
                openAs.setLayout(new BoxLayout(openAs, 3));
                openAs.setBorder(new TitledBorder(WcmResourceString.s_openAs));
                this.m_checkoutRadioButton = new JRadioButton(WcmResourceString.s_checkOut);
                this.m_checkoutRadioButton.addActionListener(this);
                this.m_checkoutRadioButton.setEnabled(false);
                openAs.add(this.m_checkoutRadioButton);
                this.m_copyRadioButton = new JRadioButton(WcmResourceString.s_copy);
                this.m_copyRadioButton.addActionListener(this);
                this.m_copyRadioButton.setEnabled(false);
                openAs.add(this.m_copyRadioButton);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.m_checkoutRadioButton);
                bg.add(this.m_copyRadioButton);
                downPanel.add((Component)openAs, gbConst);
            }
            if (itemChooserDialog.isShowVersionChoice()) {
                this.m_versionChoice = new JPanel();
                this.m_versionChoice.setLayout(new BoxLayout(this.m_versionChoice, 3));
                this.m_versionChoice.setBorder(new TitledBorder(WcmResourceString.s_versionChoice));
                this.m_releasedRadioButton = new JRadioButton(WcmResourceString.s_released);
                this.m_releasedRadioButton.setEnabled(false);
                this.m_versionChoice.add(this.m_releasedRadioButton);
                this.m_currentRadioButton = new JRadioButton(WcmResourceString.s_current);
                this.m_currentRadioButton.setEnabled(false);
                this.m_currentRadioButton.setSelected(!this.isReleasedChoiceAvailable());
                this.m_versionChoice.add(this.m_currentRadioButton);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.m_releasedRadioButton);
                bg.add(this.m_currentRadioButton);
                downPanel.add((Component)this.m_versionChoice, gbConst);
                this.m_versionChoice.setVisible(false);
            }
            if (this.isSelectFolderDialog()) {
                this.m_openButton = new JButton(WcmResourceString.s_open, WcmImageLoader.createImageIcon("action/OpenFolder16.gif"));
                this.m_openButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_openNMonic));
                this.m_openButton.setToolTipText(WcmResourceString.s_openDirectoryToolTip);
            } else {
                this.m_openButton = new JButton(this.getApproveButtonText(itemChooserDialog));
                this.m_openButton.setMnemonic(this.getApproveButtonMnemonic(itemChooserDialog));
                this.m_openButton.setToolTipText(this.getApproveButtonToolTipText(itemChooserDialog));
            }
            this.m_openButton.addActionListener(this);
            this.m_openButton.setEnabled(false);
            downPanel.add((Component)this.m_openButton, gbConst);
            if (this.isSelectFolderDialog()) {
                this.m_selectButton = new JButton(WcmResourceString.s_select);
                this.m_selectButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_selectNMonic));
                this.m_selectButton.addActionListener(this);
                this.m_selectButton.setToolTipText(WcmResourceString.s_acceptItemToolTip);
                this.m_selectButton.setEnabled(false);
                downPanel.add((Component)this.m_selectButton, gbConst);
            }
            this.m_cancelButton = new JButton(WcmResourceString.s_cancel);
            this.m_cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_cancelNMonic));
            if (itemChooserDialog.getBrowseMode() == 3) {
                this.m_cancelButton.setToolTipText(WcmResourceString.s_abortFolderChooserDialog);
            } else {
                this.m_cancelButton.setToolTipText(WcmResourceString.s_cancelButtonToolTip);
            }
            this.m_cancelButton.addActionListener(this);
            downPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)upPanel, "Center");
            mainPanel.add((Component)downPanel, "Last");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return mainPanel;
    }

    private String getApproveButtonText(WcmDlgItemChooserDialog itemChooserDialog) {
        String buttonText = itemChooserDialog.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        switch (itemChooserDialog.getBrowseMode()) {
            case 2: 
            case 5: {
                return WcmResourceString.s_open;
            }
            case 1: {
                return WcmResourceString.s_select;
            }
            case 3: {
                return WcmResourceString.s_open;
            }
        }
        return "???";
    }

    private int getApproveButtonMnemonic(WcmDlgItemChooserDialog itemChooserDialog) {
        int nMnemonic = itemChooserDialog.getApproveButtonMnemonic();
        if (nMnemonic != -1 && nMnemonic != 0) {
            return nMnemonic;
        }
        switch (itemChooserDialog.getBrowseMode()) {
            case 2: 
            case 5: {
                return WcmStringUtil.stringToMnemonic(WcmResourceString.s_openNMonic);
            }
            case 1: {
                return WcmStringUtil.stringToMnemonic(WcmResourceString.s_selectNMonic);
            }
            case 3: {
                return WcmStringUtil.stringToMnemonic(WcmResourceString.s_openNMonic);
            }
        }
        return -1;
    }

    private int getOthersButtonMnemonic(WcmDlgItemChooserDialog itemChooserDialog) {
        return WcmStringUtil.stringToMnemonic(WcmResourceString.s_othersNMonic);
    }

    private String getApproveButtonToolTipText(WcmDlgItemChooserDialog itemChooserDialog) {
        String tooltipText = itemChooserDialog.getApproveButtonToolTipText();
        if (tooltipText != null && tooltipText.length() > 0) {
            return tooltipText;
        }
        switch (itemChooserDialog.getBrowseMode()) {
            case 2: {
                return WcmResourceString.s_openItemToolTip;
            }
            case 1: {
                return WcmResourceString.s_openItemToolTip;
            }
            case 3: {
                return WcmResourceString.s_openDirectoryToolTip;
            }
        }
        return null;
    }

    private String getOthersButtonToolTipText(WcmDlgItemChooserDialog itemChooserDialog) {
        String tooltipText = itemChooserDialog.getOthersButtonToolTipText();
        if (tooltipText != null) {
            return tooltipText;
        }
        return null;
    }

    private boolean isApprovableItem(WcmDlgItemImpl selectedItem) {
        return selectedItem != null && selectedItem.getItemType() != 1;
    }

    private boolean canViewProperties(WcmDlgItemImpl selectedItem) {
        if (selectedItem == null) {
            return false;
        }
        return selectedItem.getItemType() == 4 || selectedItem.getItemType() == 5 || selectedItem.getItemType() == 3;
    }

    private boolean canContainFolder(WcmDlgItemImpl dir) {
        if (dir == null) {
            return false;
        }
        return dir.getItemType() == 2 || dir.getItemType() == 3;
    }

    public void tableChanged(TableModelEvent tmEvent) {
        if (tmEvent.getSource() == this.m_contentsPane.getDlgDirectoryModel()) {
            if (this.m_contentsPane.getDlgDirectoryModel().isItemsOverMax()) {
                this.m_jtxOverMax.setVisible(true);
            } else {
                this.m_jtxOverMax.setVisible(false);
            }
        }
    }

    public boolean isDeletableItem(WcmDlgItemImpl selectedItem) {
        if (selectedItem == null) {
            return false;
        }
        return selectedItem.getItemType() == 4 && selectedItem.getParent().getItemType() != 4 || selectedItem.getItemType() == 3 || selectedItem.getItemType() == 5;
    }

    public void refreshContents(WcmDlgItemChooserDialog itemDialog, boolean bClearSelection) {
        WcmDlgItemImpl dir = this.m_selectionPanel.getCurrentDirectory();
        if (this.m_versionListButton.isSelected()) {
            int idx = dir.getLastSelectedRow();
            WcmDlgItemImpl docItem = dir.getContents()[idx];
            docItem.clearContents();
            if (docItem.getItemType() == 4) {
                try {
                    if (this.m_contentsPane != null) {
                        this.m_contentsPane.displayContents(docItem);
                    }
                    if (bClearSelection) {
                        docItem.setLastSelectedRow(-1);
                        this.disableSelectionContextButtons();
                    }
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage((Component)((Object)itemDialog), ex.getMessage(), itemDialog.getTitle());
                    this.m_selectionPanel.onCancel();
                }
            } else {
                System.out.println(" No version list on this item " + docItem.getLabel());
            }
        } else {
            dir.clearContents();
            try {
                if (bClearSelection) {
                    dir.setLastSelectedRow(-1);
                    this.disableSelectionContextButtons();
                }
                this.setCurrentDirectory(dir);
            }
            catch (WcmException ex) {
                WcmErrorUtil.showErrorMessage((Component)((Object)itemDialog), ex.getMessage(), itemDialog.getTitle());
            }
        }
    }

    private void disableSelectionContextButtons() {
        if (this.m_checkoutRadioButton != null) {
            this.m_checkoutRadioButton.setEnabled(false);
            this.m_checkoutRadioButton.setSelected(false);
        }
        if (this.m_copyRadioButton != null) {
            this.m_copyRadioButton.setEnabled(false);
            this.m_copyRadioButton.setSelected(false);
        }
        this.m_deleteButton.setEnabled(false);
        this.m_openButton.setEnabled(false);
        this.m_propertiesButton.setEnabled(false);
    }

    private boolean isSelectFolderDialog() {
        return this.m_selectionPanel.getItemChooserDialog().getBrowseMode() == 3 | (this.m_selectionPanel.getItemChooserDialog().getBrowseMode() == 1 && this.m_selectionPanel.getItemChooserDialog().isDirectorySelectionEnabled()) | (this.m_selectionPanel.getItemChooserDialog().getBrowseMode() == 5 && this.m_selectionPanel.getItemChooserDialog().isDirectorySelectionEnabled());
    }

    private void performVersionList(WcmDlgItemChooserDialog itemDialog) {
        if (this.m_versionListButton.isSelected()) {
            this.turnOnVersionsMode();
            WcmDlgItemImpl item = this.m_selectionPanel.getSelectedItem();
            if (item.getItemType() == 4) {
                try {
                    if (this.m_contentsPane != null) {
                        this.m_contentsPane.displayContents(item);
                    }
                    this.m_contentsPane.setRowSelection(item.getContaineeCount() - 1);
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage((Component)((Object)itemDialog), ex.getMessage(), itemDialog.getTitle());
                    this.turnOffVersionsMode();
                    this.m_selectionPanel.onCancel();
                }
            } else {
                this.turnOffVersionsMode();
                System.out.println(" No version list on this item " + item.getLabel());
            }
        } else {
            this.turnOffVersionsMode();
            this.redisplayCurrentContents(itemDialog);
        }
    }

    private boolean isRootFolderSelectable() {
        WcmDlgItemChooserDialog itemDialog = this.m_selectionPanel.getItemChooserDialog();
        return itemDialog.isRootFolderSelectable();
    }

    private void turnOnVersionsMode() {
        this.m_listViewButton.setEnabled(false);
        this.m_detailViewButton.setEnabled(false);
        if (this.m_versionChoice != null) {
            this.m_versionChoice.setVisible(false);
            this.m_releasedRadioButton.setSelected(false);
            this.m_releasedRadioButton.setEnabled(false);
            this.m_currentRadioButton.setSelected(false);
            this.m_currentRadioButton.setEnabled(false);
        }
        this.m_contentsPane.switchToVersionsView();
    }

    private void turnOffVersionsMode() {
        this.m_listViewButton.setEnabled(true);
        this.m_detailViewButton.setEnabled(true);
        if (this.m_listViewButton.isSelected()) {
            this.m_contentsPane.switchToListView();
        } else {
            this.m_contentsPane.switchToDetailView();
        }
    }

    private void redisplayCurrentContents(WcmDlgItemChooserDialog itemDialog) {
        WcmDlgItemImpl dirItem = (WcmDlgItemImpl)this.m_directoryComboBox.getSelectedItem();
        try {
            if (this.m_contentsPane != null) {
                this.m_contentsPane.displayContents(dirItem);
            }
            this.m_contentsPane.setRowSelection(dirItem.getLastSelectedRow());
        }
        catch (WcmException ex) {
            WcmErrorUtil.showErrorMessage((Component)((Object)itemDialog), ex.getMessage(), itemDialog.getTitle());
        }
    }

    private boolean isReleasedChoiceAvailable() {
        if (this.m_checkoutRadioButton == null) {
            return true;
        }
        return !this.m_checkoutRadioButton.isSelected();
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowOpened(WindowEvent e) {
            WcmDlgBrowsePanel.this.m_directoryComboBox.requestFocus();
        }
    }
}

