/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.WcmItemProperty;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddWizard;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDocFolderPanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDocPermissionsPanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgDocPropertiesPanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityPanel;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JPanel;

class WcmDlgAddWizardMiddlePanel
extends JPanel {
    private final String FOLDER_PANEL = "Folder";
    private final String PROPERTIES_PANEL = "Properties";
    private final String PERMISSIONS_PANEL = "Permissions";
    private JPanel[] m_middlePanels;
    private CardLayout m_cardLayout;
    private ClassDescription m_docClass;
    private WcmDlgClassDescItem m_classItem;
    private int m_objType;
    private String m_title;
    private WcmDlgItemImpl m_folder;
    private String m_docName;
    private int m_pageIndex;
    private int m_wizardType = 0;
    private WcmDlgItemImpl m_checkinItem;
    private Properties m_props;
    private Properties m_showProps;
    private Dialog m_parent;
    private String m_newFolderName;
    private boolean m_securityModifiable;

    public WcmDlgAddWizardMiddlePanel(Dialog parent, WcmDlgItem scopeItem, WcmDlgItem contextItem, WcmDlgClassDescItem classItem, Properties props) throws Exception {
        if (scopeItem == null) {
            System.out.println("WcmDlgAddWizardMiddlePanel constructor has null scopeItem parameter");
            throw new WcmException("client.WcmDlgAddWizard.IllegalNullArgumentException", "Invalid null input parameters");
        }
        this.m_classItem = classItem;
        this.m_objType = this.discoverObjectType();
        this.m_props = props;
        this.m_parent = parent;
        this.initLayout(parent, scopeItem, contextItem, props);
        this.m_parent.addWindowListener(new WindowHandler());
    }

    public WcmDlgAddWizardMiddlePanel(Dialog parent, WcmDlgClassDescItem classItem, WcmDlgItemImpl checkinItem, Properties props, String filename) throws Exception {
        if (classItem == null || checkinItem == null) {
            throw new WcmException("client.WcmDlgAddWizardMiddlePanel.IllegalNullArgumentException", "Invalid null input parameters");
        }
        this.m_wizardType = 1;
        this.m_classItem = classItem;
        this.m_objType = this.discoverObjectType();
        this.m_checkinItem = checkinItem;
        this.m_parent = parent;
        this.m_props = props;
        if (this.m_props == null) {
            this.m_props = ObjectFactory.getProperties();
        }
        this.createCheckinShowProperties();
        this.m_docName = filename != null ? new String(filename) : new String("");
        this.initCheckinLayout(parent, this.m_showProps);
        this.m_parent.addWindowListener(new WindowHandler());
    }

    public WcmDlgAddWizardMiddlePanel(Dialog parent, WcmDlgItemImpl directoryItem, WcmDlgClassDescItem classItem, Properties props) throws Exception {
        if (directoryItem == null) {
            throw new WcmException("client.WcmDlgAddWizardMiddlePanel.IllegalNullArgumentException", "Invalid null input parameters");
        }
        this.m_wizardType = 2;
        this.m_classItem = classItem;
        this.m_objType = 2;
        this.m_folder = directoryItem;
        this.m_parent = parent;
        this.m_props = props;
        if (this.m_props == null) {
            this.m_props = ObjectFactory.getProperties();
        }
        this.m_docName = new String("");
        this.initCheckinLayout(parent, this.m_showProps);
        this.m_parent.addWindowListener(new WindowHandler());
    }

    public Properties getProperties() throws WcmException {
        Properties props = this.m_wizardType == 0 ? ((WcmDlgDocPropertiesPanel)this.m_middlePanels[1]).getProperties() : ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).getProperties();
        if (this.m_props != null) {
            for (Property prop : this.m_props) {
                if (this.foundPropInProps(prop, props)) continue;
                props.add((Object)prop);
            }
        }
        return props;
    }

    public ClassDescription getDocClass() {
        return this.m_docClass;
    }

    public String getDocClassId() {
        return this.m_docClass.getId();
    }

    public ClassDescription getDocClassObject() {
        return this.m_docClass;
    }

    public String getDocFileName() {
        return this.m_docName;
    }

    public void setDocFileName(String filename) {
        this.m_docName = new String(filename);
        if (this.m_wizardType == 0) {
            ((WcmDlgDocFolderPanel)this.m_middlePanels[0]).setDocName(new String(this.m_docName));
        } else {
            ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).setDocName(new String(this.m_docName));
        }
    }

    public WcmSecurityPanel getSecurityPanel() {
        if (this.m_wizardType == 0) {
            return ((WcmDlgDocPermissionsPanel)this.m_middlePanels[2]).getSecurityPanel();
        }
        return ((WcmDlgDocPermissionsPanel)this.m_middlePanels[1]).getSecurityPanel();
    }

    public boolean isSecurityModifiable() {
        if (this.m_wizardType == 1) {
            return ((WcmDlgDocPermissionsPanel)this.m_middlePanels[1]).isSecurityModifiable();
        }
        return true;
    }

    public boolean isSecurityModified() {
        if (this.m_wizardType == 1) {
            WcmSecurityPanel secPanel = ((WcmDlgDocPermissionsPanel)this.m_middlePanels[1]).getSecurityPanel();
            if (secPanel == null) {
                return false;
            }
            return secPanel.isModified();
        }
        return true;
    }

    public WcmDlgItemImpl getFolder() {
        return this.m_folder;
    }

    public boolean nextPage() throws Exception {
        boolean result = true;
        this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.m_wizardType == 0) {
                switch (this.m_pageIndex) {
                    case 0: {
                        if (((WcmDlgDocFolderPanel)this.m_middlePanels[0]).validateProps()) {
                            this.m_folder = ((WcmDlgDocFolderPanel)this.m_middlePanels[0]).getFolder();
                            this.m_docName = ((WcmDlgDocFolderPanel)this.m_middlePanels[0]).getDocName();
                            ((WcmDlgDocPropertiesPanel)this.m_middlePanels[1]).setFolder(this.m_folder, new String(this.m_folder.getPathname()));
                            ((WcmDlgDocPropertiesPanel)this.m_middlePanels[1]).setDocName(new String(this.m_docName));
                            this.m_cardLayout.show(this, "Properties");
                            ++this.m_pageIndex;
                            break;
                        }
                        result = false;
                        break;
                    }
                    case 1: {
                        if (((WcmDlgDocPropertiesPanel)this.m_middlePanels[1]).validateProps()) {
                            this.m_cardLayout.show(this, "Permissions");
                            ++this.m_pageIndex;
                            this.m_docClass = ((WcmDlgDocPropertiesPanel)this.m_middlePanels[1]).getClassObject();
                            String docClassName = WcmItemProperty.getClassDescDisplayName(this.m_docClass);
                            ((WcmDlgDocPermissionsPanel)this.m_middlePanels[2]).refresh(this.m_folder, this.m_folder.getPathname(), this.m_docName, docClassName, this.m_docClass);
                            break;
                        }
                        result = false;
                        break;
                    }
                }
            } else if (this.m_wizardType == 1) {
                switch (this.m_pageIndex) {
                    case 0: {
                        if (((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).validateProps()) {
                            this.m_cardLayout.show(this, "Permissions");
                            ++this.m_pageIndex;
                            this.m_docClass = ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).getClassObject();
                            String docClassName = WcmItemProperty.getClassDescDisplayName(this.m_docClass);
                            ((WcmDlgDocPermissionsPanel)this.m_middlePanels[1]).refresh(this.m_checkinItem, "no folder", this.m_docName, docClassName, this.m_docClass);
                            break;
                        }
                        result = false;
                        break;
                    }
                }
            } else {
                switch (this.m_pageIndex) {
                    case 0: {
                        if (((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).validateProps()) {
                            this.m_newFolderName = ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).getNewFolderName();
                            this.m_cardLayout.show(this, "Permissions");
                            ++this.m_pageIndex;
                            this.m_docClass = ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).getClassObject();
                            String docClassName = WcmItemProperty.getClassDescDisplayName(this.m_docClass);
                            ((WcmDlgDocPermissionsPanel)this.m_middlePanels[1]).refresh(this.m_folder, this.m_folder.getPathname(), this.m_docName, docClassName, this.m_docClass);
                            break;
                        }
                        result = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_parent.setCursor(Cursor.getDefaultCursor());
            throw e;
        }
        this.m_parent.setCursor(Cursor.getDefaultCursor());
        return result;
    }

    public void previousPage() {
        if (this.m_wizardType == 0) {
            switch (this.m_pageIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_cardLayout.show(this, "Folder");
                    --this.m_pageIndex;
                    break;
                }
                case 2: {
                    this.m_cardLayout.show(this, "Properties");
                    --this.m_pageIndex;
                }
            }
        } else {
            switch (this.m_pageIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_cardLayout.show(this, "Properties");
                    --this.m_pageIndex;
                }
            }
        }
    }

    public void resetValue() throws WcmException {
        if (this.m_wizardType == 0) {
            ((WcmDlgDocFolderPanel)this.m_middlePanels[0]).resetValue();
        } else if (this.m_wizardType == 1) {
            ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).loadProperties();
        } else {
            ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).setFolder(this.m_folder, this.m_folder.getPathname());
        }
    }

    public String getNewFolderName() {
        return this.m_newFolderName;
    }

    public String getNewCheckinClassId() {
        return ((WcmDlgDocPropertiesPanel)this.m_middlePanels[0]).getClassId();
    }

    private void initLayout(Dialog parent, WcmDlgItem scopeItem, WcmDlgItem contextItem, Properties props) throws WcmException {
        this.m_middlePanels = new JPanel[3];
        this.m_middlePanels[0] = new WcmDlgDocFolderPanel(parent, scopeItem, contextItem, this.m_classItem);
        try {
            this.m_middlePanels[1] = new WcmDlgDocPropertiesPanel(parent, this.m_docName, this.m_classItem, this.m_objType, props, this.m_wizardType);
        }
        catch (WcmException ex) {
            System.out.println("initLayout exception on creating the WcmDlgDocPropertiesPanel" + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        this.m_middlePanels[2] = new WcmDlgDocPermissionsPanel(parent, this.m_docName, this.m_classItem, this.m_objType, this.m_wizardType);
        this.m_cardLayout = new CardLayout();
        this.setLayout(this.m_cardLayout);
        this.add((Component)this.m_middlePanels[0], "Folder");
        this.add((Component)this.m_middlePanels[1], "Properties");
        this.add((Component)this.m_middlePanels[2], "Permissions");
        this.m_cardLayout.first(this);
    }

    private void initCheckinLayout(Dialog parent, Properties props) throws WcmException {
        this.m_middlePanels = new JPanel[2];
        this.m_middlePanels[0] = new WcmDlgDocPropertiesPanel(parent, this.m_docName, this.m_classItem, this.m_objType, props, this.m_wizardType, this.m_checkinItem);
        this.m_middlePanels[1] = new WcmDlgDocPermissionsPanel(parent, this.m_docName, this.m_classItem, this.m_objType, this.m_wizardType);
        this.m_cardLayout = new CardLayout();
        this.setLayout(this.m_cardLayout);
        this.add((Component)this.m_middlePanels[0], "Properties");
        this.add((Component)this.m_middlePanels[1], "Permissions");
        this.m_cardLayout.first(this);
    }

    private void createCheckinShowProperties() {
        this.m_showProps = ObjectFactory.getProperties();
        this.m_showProps.addAll((Collection)this.m_props);
        Properties existingProps = null;
        try {
            try {
                this.m_checkinItem.getWcmObject().refresh();
            }
            catch (ClassCastException c) {
                // empty catch block
            }
            existingProps = ((Document)this.m_checkinItem.getWcmObject()).getProperties();
        }
        catch (Exception ex) {
            System.out.println("WcmDlgAddWizardMiddlePanel has exception " + ex.getMessage());
        }
        if (existingProps != null) {
            for (Property existingProp : existingProps) {
                if (this.foundPropInProps(existingProp, this.m_showProps)) continue;
                this.m_showProps.add((Object)existingProp);
            }
        }
    }

    private boolean foundPropInProps(Property prop, Properties props) {
        for (Property curProp : props) {
            if (!curProp.getName().equalsIgnoreCase(prop.getName())) continue;
            return true;
        }
        return false;
    }

    private int discoverObjectType() {
        int objType;
        block12: {
            objType = 0;
            ClassDescription cd = this.m_classItem.getClassDescription();
            try {
                if (cd.isSubclassOf("{D508E302-7E74-42F4-A7D7-B985DD333509}")) {
                    objType = -100;
                } else if (cd.isSubclassOf("{FBA25CE9-A06A-4F79-8A23-E09AE54DD7CD}")) {
                    objType = -101;
                } else if (cd.isSubclassOf("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}")) {
                    objType = 1;
                } else if (cd.isSubclassOf("{01A3A8CA-7AEC-11D1-A31B-0020AF9FBB1C}")) {
                    objType = 2;
                } else if (cd.isSubclassOf("{D32E4F58-AFB2-11D2-8BD6-00E0290F729A}")) {
                    objType = 15;
                }
            }
            catch (Exception ex) {
                System.out.println("WcmDlgAddWizardMiddlePanel has exception in discoverObjectType(), will re-try TYPE_DOCUMENT");
                if (cd.isSubclassOf("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}")) {
                    objType = 1;
                }
                if (!cd.isSubclassOf("{01A3A8CA-7AEC-11D1-A31B-0020AF9FBB1C}")) break block12;
                objType = 2;
            }
        }
        return objType;
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowOpened(WindowEvent e) {
            if (WcmDlgAddWizardMiddlePanel.this.m_wizardType == 0) {
                ((WcmDlgDocFolderPanel)WcmDlgAddWizardMiddlePanel.this.m_middlePanels[0]).setRequestFocus();
            } else if (WcmDlgAddWizardMiddlePanel.this.m_wizardType == 1) {
                ((WcmDlgAddWizard)((Object)WcmDlgAddWizardMiddlePanel.this.m_parent)).setRequestFocusNext();
            } else {
                ((WcmDlgDocPropertiesPanel)WcmDlgAddWizardMiddlePanel.this.m_middlePanels[0]).setRequestFocus();
            }
        }
    }
}

