/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.dlg;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgAddWizardMiddlePanel;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class WcmDlgAddFolderWizard
extends VWModalDialog
implements ActionListener,
IVWFrameInterface {
    private static final Dimension HSTRUT5 = new Dimension(5, 1);
    private static final Dimension HSTRUT15 = new Dimension(15, 1);
    private Container m_parentPanel;
    private WcmDlgAddWizardMiddlePanel m_middlePanel;
    private JPanel m_bottomPanel;
    private JButton m_backButton;
    private JButton m_nextButton;
    private JButton m_finishButton;
    private JButton m_cancelButton;
    private JPanel m_topPanel;
    private JPanel m_introArea;
    private JLabel m_introHeader;
    private JTextPane m_introBody;
    private SimpleAttributeSet m_boldBlackText;
    private SimpleAttributeSet m_plainBlackText;
    private Document m_doc;
    private int m_status = 1;
    private ClassDescription m_classDesc;
    private WcmDlgClassDescItem m_classItem;
    private int m_middlePanelIndex;
    private WcmDlgItemImpl m_newDocItem;
    private BaseObject m_newObj;
    private ObjectStore m_objStoreObj;
    private WcmDlgItemImpl m_directoryItem;
    private Folder m_createdFolder;
    private Session m_sess = null;

    public WcmDlgAddFolderWizard(Dialog parent, WcmDlgItemImpl directoryItem, WcmDlgClassDescItem classItem, Properties props) throws WcmException {
        super(parent);
        if (directoryItem == null) {
            throw new WcmException("client.WcmDlgAddWizard.IllegalNullArgumentException", "Invalid null input parameters");
        }
        this.m_directoryItem = directoryItem;
        this.m_classItem = classItem;
        this.m_sess = directoryItem.getSession();
        if (this.m_sess == null && directoryItem.getWcmObject() != null) {
            this.m_sess = directoryItem.getWcmObject().getSession();
        }
        this.initLayout(directoryItem, props);
        this.addWindowListener((WindowListener)new VWWindowAdapter((IVWFrameInterface)this));
    }

    public String getDocClassId() {
        return this.m_middlePanel.getDocClassId();
    }

    public String getDocFileName() {
        return this.m_middlePanel.getDocFileName();
    }

    public void resetValues() throws WcmException {
        this.m_middlePanel.resetValue();
    }

    public int showDialog(Container parent) throws WcmException {
        this.resetValues();
        this.show();
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        return this.m_status;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_backButton) {
            this.performBackButton();
        } else if (source == this.m_nextButton) {
            this.performNextButton();
        } else if (source == this.m_finishButton) {
            this.performFinishButton();
        } else if (source == this.m_cancelButton) {
            this.performCancelButton();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    private void initLayout(WcmDlgItemImpl directoryItem, Properties props) {
        String fontName = WcmResourceString.s_addFolderBannerFont;
        Integer fontSize = null;
        try {
            this.setVisible(false);
            Dimension dim = WcmStringUtil.stringToDimension(WcmResourceString.s_addWizardDim);
            if (dim == null) {
                dim = new Dimension(660, 410);
            }
            this.setPreferredSize(dim);
            this.m_parentPanel = this.getContentPane();
            this.m_parentPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            this.m_topPanel = new JPanel();
            this.m_topPanel.setLayout(new BoxLayout(this.m_topPanel, 2));
            this.m_topPanel.setBackground(Color.white);
            this.m_topPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            dim = WcmStringUtil.stringToDimension(WcmResourceString.s_introductionPaneDim);
            if (dim == null) {
                dim = new Dimension(410, 56);
            }
            this.m_topPanel.setMinimumSize(dim);
            this.m_introBody = new JTextPane();
            this.m_introBody.disable();
            try {
                fontSize = new Integer(WcmResourceString.s_addFolderBannerFontSize);
            }
            catch (Exception e) {
                fontSize = new Integer(12);
            }
            if (fontName != null && fontName.length() != 0 && fontSize != null) {
                this.m_introBody.setFont(new Font(fontName, 0, fontSize));
            } else {
                this.m_introBody.setFont(new Font("Arial", 0, 12));
            }
            this.m_introBody.setBackground(Color.white);
            this.m_boldBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_boldBlackText, Color.black);
            StyleConstants.setBold(this.m_boldBlackText, true);
            this.m_plainBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_plainBlackText, Color.black);
            StyleConstants.setBold(this.m_plainBlackText, false);
            this.m_doc = this.m_introBody.getDocument();
            this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.w_propertiesInstrHeader.toString(WcmResourceString.s_folder), this.m_boldBlackText);
            this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.w_propertiesInstrBody.toString(WcmResourceString.s_folder), this.m_plainBlackText);
            this.m_topPanel.add(Box.createRigidArea(HSTRUT5));
            this.m_topPanel.add(this.m_introBody);
            JLabel image = new JLabel(WcmImageLoader.createImageIcon("action/button/AddFolder32.gif"));
            this.m_topPanel.add(image);
            this.m_topPanel.add(Box.createRigidArea(HSTRUT15));
            this.m_parentPanel.add((Component)this.m_topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 1, new Insets(5, 10, 5, 10), 0, 0));
            this.m_middlePanel = new WcmDlgAddWizardMiddlePanel((Dialog)((Object)this), directoryItem, this.m_classItem, props);
            this.m_parentPanel.add((Component)this.m_middlePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 10, 5, 10), 0, 0));
            this.m_bottomPanel = new JPanel();
            this.m_bottomPanel.setLayout(new GridBagLayout());
            this.m_bottomPanel.add((Component)new JLabel(WcmImageLoader.createImageIcon("misc/Border.gif")), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 22, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_backButton = new JButton(WcmResourceString.s_backButtonText);
            this.m_backButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_backNMonic));
            this.m_backButton.addActionListener(this);
            this.m_nextButton = new JButton(WcmResourceString.s_nextButtonText);
            this.m_nextButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_nextNMonic));
            this.m_nextButton.addActionListener(this);
            ComponentOrientation o = this.m_parent.getComponentOrientation();
            this.m_bottomPanel.add((Component)this.m_backButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, o.isLeftToRight() ? 270 : 300, 5, 0), 0, 0));
            this.m_bottomPanel.add((Component)this.m_nextButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 5, 20), 0, 0));
            this.m_finishButton = new JButton(WcmResourceString.s_finish);
            this.m_finishButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.s_finishNMonic));
            this.m_finishButton.addActionListener(this);
            this.m_bottomPanel.add((Component)this.m_finishButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 20), 0, 0));
            this.m_cancelButton = new JButton(WcmResourceString.s_cancel);
            this.m_cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmResourceString.cancelMonic));
            this.m_cancelButton.addActionListener(this);
            this.m_bottomPanel.add((Component)this.m_cancelButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.m_parentPanel.add((Component)this.m_bottomPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.2, 20, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.setButtonStatus();
            this.applyComponentOrientation(o);
            this.pack();
        }
        catch (Exception ex) {
            System.out.println("initLayout exception on " + directoryItem.getLabel() + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void setButtonStatus() {
        try {
            switch (this.m_middlePanelIndex) {
                case 0: {
                    this.m_backButton.setEnabled(false);
                    this.m_nextButton.setEnabled(true);
                    this.m_finishButton.setEnabled(true);
                    this.m_cancelButton.setEnabled(true);
                    this.m_doc.remove(0, this.m_doc.getLength());
                    this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.w_propertiesInstrHeader.toString(WcmResourceString.s_folder), this.m_boldBlackText);
                    this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.w_propertiesInstrBody.toString(WcmResourceString.s_folder), this.m_plainBlackText);
                    break;
                }
                case 1: {
                    this.m_backButton.setEnabled(true);
                    this.m_nextButton.setEnabled(false);
                    this.m_finishButton.setEnabled(true);
                    this.m_cancelButton.setEnabled(true);
                    this.m_doc.remove(0, this.m_doc.getLength());
                    this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.s_securityInstrHeader, this.m_boldBlackText);
                    this.m_doc.insertString(this.m_doc.getLength(), WcmResourceString.w_securityInstrBody.toString(WcmResourceString.s_folder), this.m_plainBlackText);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("setButtonStatus exception on " + ex.getMessage());
        }
    }

    private void performBackButton() {
        this.m_middlePanel.previousPage();
        --this.m_middlePanelIndex;
        this.setButtonStatus();
    }

    private boolean performNextButton() {
        boolean result = false;
        try {
            result = this.m_middlePanel.nextPage();
            if (result) {
                ++this.m_middlePanelIndex;
                this.setButtonStatus();
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage((Component)((Object)this), ex.getLocalizedMessage(), this.getTitle());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFinishButton() {
        boolean b_resumeAddFolder = false;
        if (this.m_middlePanelIndex <= 0 && !this.performNextButton()) {
            return;
        }
        try {
            Folder fld = this.getCreateInFolder();
            this.m_classDesc = this.m_middlePanel.getDocClass();
            Properties props = this.m_middlePanel.getProperties();
            Permissions perms = this.getAddNewPermissions();
            this.m_createdFolder = fld.addSubFolder(this.m_middlePanel.getNewFolderName(), this.m_classDesc.getId(), props, perms);
            this.m_status = 0;
        }
        catch (Exception ex) {
            System.out.println("performFinishButton exception " + ex.getMessage());
            WcmErrorUtil.showErrorMessage((Component)((Object)this), WcmResourceString.s_failAction.toString(ex.getMessage()), this.getTitle());
            int ret = JOptionPane.showConfirmDialog((Component)((Object)this), WcmResourceString.s_abortAddFolder, WcmResourceString.s_confirmAbort, 0);
            if (ret == 1) {
                b_resumeAddFolder = true;
            } else {
                this.m_status = -1;
            }
        }
        finally {
            if (!b_resumeAddFolder) {
                this.setVisible(false);
                super.dispose();
            }
        }
    }

    private void performCancelButton() {
        this.setVisible(false);
        this.m_status = 1;
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Folder getCreateInFolder() throws WcmException {
        ReadableMetadataObject bsObj = this.m_directoryItem.getWcmObject();
        if (bsObj instanceof ObjectStore) {
            return ((ObjectStore)bsObj).getRootFolder();
        }
        if (bsObj instanceof Folder) {
            return (Folder)bsObj;
        }
        throw new WcmException("client.WcmDlgAddFolderWizard.invalidType", "Internal error:Invalid item type");
    }

    public Folder getCreatedFolder() {
        return this.m_createdFolder;
    }

    private Permissions getAddNewPermissions() throws WcmException {
        WcmSecurityPanel secPanel = this.m_middlePanel.getSecurityPanel();
        if (secPanel == null) {
            throw new WcmException("client.WcmDlgAddWizard.InvalidSecurityPanel", "Internal Error - Invalid Security Panel");
        }
        return secPanel.getPermissions();
    }
}

