/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.Users;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUserRenderer;
import com.filenet.wcm.toolkit.client.ui.security.SecUserRealm;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;

public class WcmUserComponent
extends JComboBox
implements WcmUIComponent,
ActionListener {
    private SearchPropertyDescription m_spDesc = null;
    private EventListenerList listenerList = new EventListenerList();
    private User curValue = null;
    private Users usersList = null;

    public WcmUserComponent(SearchPropertyDescription spDesc) {
        this.m_spDesc = spDesc;
        WcmUserRenderer pRender = new WcmUserRenderer();
        pRender.setVerticalTextPosition(1);
        pRender.setBackground(new Color(255, 255, 255));
        pRender.setOpaque(true);
        this.setRenderer(pRender);
        this.usersList = SecUserRealm.getRealmUsers(spDesc.getSession());
        PropertyUtil.sort(this.usersList);
        this.addItem(new String(" "));
        for (User aUser : this.usersList) {
            this.addItem(aUser);
        }
    }

    public void setValue(Object value) throws WcmException {
        if (value != null && value instanceof User) {
            this.setSelectedItem(value);
            this.curValue = (User)value;
        }
    }

    public Object getValue() {
        if (this.getSelectedIndex() >= 0) {
            return this.getSelectedItem();
        }
        return null;
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this) {
            this.hidePopup();
        }
        WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this, evt);
    }

    public boolean isModified() {
        return !this.getSelectedItem().equals(this.curValue);
    }

    public boolean isMultiLine() {
        return false;
    }

    public WcmException validateValue() {
        return null;
    }

    public boolean selectWithKeyChar(char keyChar) {
        StringBuffer userChar = new StringBuffer();
        userChar.append(keyChar);
        try {
            User foundObj = PropertyUtil.findUser(userChar.toString(), this.usersList);
            int index = this.usersList.indexOf((Object)foundObj);
            if (index != -1) {
                this.setSelectedIndex(++index);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        User selObj = (User)this.getSelectedItem();
        try {
            return new String(selObj.getPropertyStringValue("DisplayName"));
        }
        catch (Exception e) {
            return new String(selObj.getName());
        }
    }
}

