/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;

class WcmUpDownDeleteBtnPanel
extends JPanel {
    public static final int UP = 1;
    public static final int DOWN = -1;
    private JList list;
    private boolean addDelBtn;
    private AbstractButton btnMoveItemsUp;
    private AbstractButton btnMoveItemsDown;
    private AbstractButton btnDeleteItems;

    WcmUpDownDeleteBtnPanel(JList list, boolean addDelBtn) {
        this.list = list;
        this.addDelBtn = addDelBtn;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.enableButtons(false);
    }

    private void createComponents() {
        this.btnMoveItemsUp = WcmImageLoader.createToolBarButton("action/button/Up24.gif", WcmUIComponentResource.moveItemUp, false);
        this.btnMoveItemsUp.setFocusPainted(true);
        this.btnMoveItemsDown = WcmImageLoader.createToolBarButton("action/button/Down24.gif", WcmUIComponentResource.moveItemDown, false);
        this.btnMoveItemsDown.setFocusPainted(true);
        if (this.addDelBtn) {
            this.btnDeleteItems = WcmImageLoader.createToolBarButton("action/button/DeleteRow24.gif", WcmUIComponentResource.deleteItem, false);
            this.btnDeleteItems.setFocusPainted(true);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = -1;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 0, 3, 0);
        if (this.addDelBtn) {
            this.add((Component)this.btnDeleteItems, gbCons);
        }
        this.add((Component)this.btnMoveItemsUp, gbCons);
        this.add((Component)this.btnMoveItemsDown, gbCons);
    }

    private void setupListeners() {
        if (this.addDelBtn) {
            this.btnDeleteItems.addActionListener(new RemoveActionListener());
        }
        this.btnMoveItemsUp.addActionListener(new MoveItemsListener());
        this.btnMoveItemsDown.addActionListener(new MoveItemsListener());
    }

    private void moveItemsUp() {
        int[] indices = this.list.getSelectedIndices();
        DefaultListModel listModel = (DefaultListModel)this.list.getModel();
        try {
            if (indices.length > 0 && listModel.getSize() > 1) {
                for (int i = 0; i < indices.length; ++i) {
                    int iItem = indices[i];
                    if (iItem == 0) continue;
                    Object prevItem = listModel.getElementAt(iItem - 1);
                    listModel.setElementAt(listModel.getElementAt(iItem), iItem - 1);
                    listModel.setElementAt(prevItem, iItem);
                    this.list.setSelectedIndex(iItem - 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void moveItemsDown() {
        int[] indices = this.list.getSelectedIndices();
        DefaultListModel listModel = (DefaultListModel)this.list.getModel();
        try {
            if (indices.length > 0 && listModel.getSize() > 1) {
                for (int i = indices.length - 1; i >= 0; --i) {
                    int iItem = indices[i];
                    if (iItem == listModel.getSize() - 1) continue;
                    Object nextItem = listModel.getElementAt(iItem + 1);
                    listModel.setElementAt(listModel.getElementAt(iItem), iItem + 1);
                    listModel.setElementAt(nextItem, iItem);
                    this.list.setSelectedIndex(iItem + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void removeSelectedItems() {
        int[] indices = null;
        DefaultListModel listModel = null;
        try {
            indices = this.list.getSelectedIndices();
            if (indices.length > 0) {
                listModel = (DefaultListModel)this.list.getModel();
                int nextItemToSel = indices[indices.length - 1] + 1;
                for (int i = indices.length - 1; i >= 0; --i) {
                    listModel.removeElementAt(indices[i]);
                    --nextItemToSel;
                }
                int listSize = listModel.getSize();
                if (listSize > 0) {
                    int selIdx = nextItemToSel < listSize ? nextItemToSel : 0;
                    this.list.setSelectedIndex(selIdx);
                }
            }
            this.enableButtons(listModel.getSize() > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableButtons(boolean bEnable) {
        this.btnDeleteItems.setEnabled(bEnable);
        this.btnMoveItemsUp.setEnabled(bEnable);
        this.btnMoveItemsDown.setEnabled(bEnable);
    }

    class MoveItemsListener
    implements ActionListener {
        MoveItemsListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == WcmUpDownDeleteBtnPanel.this.btnMoveItemsUp) {
                WcmUpDownDeleteBtnPanel.this.moveItemsUp();
            } else if (evt.getSource() == WcmUpDownDeleteBtnPanel.this.btnMoveItemsDown) {
                WcmUpDownDeleteBtnPanel.this.moveItemsDown();
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            WcmUpDownDeleteBtnPanel.this.removeSelectedItems();
        }
    }
}

