/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;

public class WcmTextAreaPanel
extends JPanel
implements WcmUIComponent,
ActionListener {
    protected VerbosePropertyDescription data;
    private JTextArea textArea;
    private Object value;
    private String curValue = new String("");
    private EventListenerList listenerList = new EventListenerList();

    public WcmTextAreaPanel(VerbosePropertyDescription theData) {
        this.data = theData;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea(3, 15);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.add((Component)new JScrollPane(this.textArea), "Center");
    }

    public Object getValue() {
        return this.textArea.getText();
    }

    public void setValue(Object objValue) throws WcmException {
        if (objValue != null) {
            if (objValue instanceof String) {
                this.textArea.append(objValue.toString());
            } else if (objValue instanceof Values) {
                Values values = (Values)objValue;
                for (int i = 0; i < values.size(); ++i) {
                    this.textArea.append(values.get(i).toString());
                }
            }
            this.curValue = this.textArea.getText();
        }
    }

    public WcmException validateValue() {
        String value = this.textArea.getText();
        String strValue = value.toString();
        return WcmCtrlFactoryUtil.checkStringLength(this.data, strValue);
    }

    public boolean isMultiLine() {
        return true;
    }

    public boolean isModified() {
        String value = this.textArea.getText();
        return !value.equals(this.curValue);
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        } else {
            this.textArea.setBackground(new Color(this.getBackground().getRGB()));
            this.textArea.setEditable(false);
        }
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent evt) {
        WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this.textArea, evt);
    }
}

