/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.ae.util.bidi.BiDiOrientation;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

class WcmStringTextField
extends JTextField
implements WcmUIComponent,
ActionListener {
    protected VerbosePropertyDescription data;
    private EventListenerList listenerList = new EventListenerList();
    private String curValue = new String("");
    private boolean isFolderObj;

    public WcmStringTextField(VerbosePropertyDescription propertyDescr) {
        this.data = propertyDescr;
        this.addActionListener(this);
    }

    public WcmStringTextField(VerbosePropertyDescription propertyDescr, boolean isFldrObj) {
        this.data = propertyDescr;
        this.isFolderObj = isFldrObj;
        this.addActionListener(this);
    }

    public Object getValue() {
        String strVal;
        if (this.data.getDataType() == 5 && (strVal = this.getText()) != null && strVal.length() > 0) {
            int i;
            StringBuffer strBuf = new StringBuffer(strVal);
            int cnt = 0;
            int len = strBuf.length();
            for (i = 0; i <= len - 1 && strBuf.charAt(i) == ' '; ++i) {
                ++cnt;
            }
            if (cnt > 0 && len > 0) {
                strBuf.delete(0, cnt);
            }
            cnt = 0;
            len = strBuf.length();
            for (i = len - 1; i >= 0 && strBuf.charAt(i) == ' '; --i) {
                ++cnt;
            }
            if (cnt > 0 && len > 0) {
                strBuf.setLength(len - cnt);
            }
            if (strBuf.length() == 36) {
                strBuf.insert(0, '{');
                strBuf.append('}');
                return strBuf.toString();
            }
        }
        return this.getText().toString();
    }

    public WcmException validateValue() {
        String value = this.getValue().toString();
        if (this.data.getDataType() == 8) {
            WcmException err = null;
            if (this.isFolderObj) {
                err = WcmCtrlFactoryUtil.checkFolderName(this.data, value);
            }
            if (err == null) {
                err = WcmCtrlFactoryUtil.checkStringLength(this.data, value);
            }
            return err;
        }
        if (this.data.getDataType() == 5) {
            return WcmCtrlFactoryUtil.checkGUIDFormat(this.data, value);
        }
        return null;
    }

    public void setValue(Object objValue) throws WcmException {
        if (objValue != null) {
            if (objValue instanceof Value) {
                Value value = (Value)objValue;
                this.setText((String)value.getValue());
            } else {
                String txt = PropertyUtil.getStringValue(objValue, false);
                if (this.data.getSymbolicName().equals("PathName")) {
                    txt = BiDiOrientation.formatPath((String)txt);
                }
                this.setText(txt);
            }
            this.curValue = this.getText();
        }
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isModified() {
        String value = this.getText();
        return !value.equals(this.curValue);
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent evt) {
        WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this, evt);
    }
}

