/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogFactory;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.util.WcmDate;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class WcmSVCtrl
extends JPanel
implements WcmUIComponent {
    private JButton moreButton;
    private JTextField textField;
    private Container parentContainer;
    private VerbosePropertyDescription data;
    private WcmSVCtrl svCtrl;
    private String curValue = new String("");
    private WcmUserGroupItem curUserValue = null;
    private EventListenerList listenerList = new EventListenerList();
    private WcmSitePrefs m_sitePref = null;
    private static final String CREATOR = "Creator";
    private static final String LAST_MODIFIER = "LastModifier";
    private static final String LOCK_OWNER = "LockOwner";

    public WcmSVCtrl(Container frame, VerbosePropertyDescription theData) {
        this.data = theData;
        this.parentContainer = frame;
        this.svCtrl = this;
        this.createComponent();
        this.layoutComponent();
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WcmDialogComponent svDialog = null;
                svDialog = WcmSVCtrl.this.data.getDataType() == 3 ? WcmDialogFactory.getSVCalendarDialog(WcmSVCtrl.this.parentContainer, WcmSVCtrl.this.data, WcmSVCtrl.this.svCtrl) : (WcmSVCtrl.this.data.getName().compareToIgnoreCase(WcmSVCtrl.CREATOR) == 0 || WcmSVCtrl.this.data.getName().compareToIgnoreCase(WcmSVCtrl.LAST_MODIFIER) == 0 || WcmSVCtrl.this.data.getName().compareToIgnoreCase(WcmSVCtrl.LOCK_OWNER) == 0 ? WcmDialogFactory.getSVUserDialog(WcmSVCtrl.this.parentContainer, WcmSVCtrl.this.data, WcmSVCtrl.this.svCtrl) : WcmDialogFactory.getSVChoiceListDialog(WcmSVCtrl.this.parentContainer, WcmSVCtrl.this.data, WcmSVCtrl.this.svCtrl));
                if (svDialog != null) {
                    int status = svDialog.showDialog();
                    if (status == 0) {
                        Object value = svDialog.getData();
                        try {
                            String tmpCurValue = WcmSVCtrl.this.curValue;
                            WcmSVCtrl.this.setValue(value);
                            WcmSVCtrl.this.curValue = tmpCurValue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    WcmCtrlFactoryUtil.fireEditingStopped(WcmSVCtrl.this.listenerList, WcmSVCtrl.this.textField, evt);
                }
                if (WcmSVCtrl.this.parentContainer != null) {
                    WcmSVCtrl.this.parentContainer.requestFocus();
                }
            }
        });
        this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
    }

    public void setSitePreferences(WcmSitePrefs siteprefs) {
        this.m_sitePref = siteprefs;
    }

    public WcmSitePrefs getSitePreferences() {
        return this.m_sitePref;
    }

    public Object getValue() {
        block6: {
            block7: {
                block5: {
                    if (this.data == null || this.data.getDataType() != 3) break block5;
                    PropertyDescription propDesc = this.data.getPropertyDescription();
                    if (propDesc != null && propDesc instanceof SearchPropertyDescription) {
                        return PropertyUtil.getWcmDate(this.textField.getText());
                    }
                    break block6;
                }
                if (this.data.getName().compareToIgnoreCase(CREATOR) == 0) break block7;
                if (this.data.getName().compareToIgnoreCase(LAST_MODIFIER) == 0) break block7;
                if (this.data.getName().compareToIgnoreCase(LOCK_OWNER) != 0) break block6;
            }
            return this.curUserValue;
        }
        return WcmCtrlFactoryUtil.getObject(this.data, this.textField.getText());
    }

    public WcmException validateValue() {
        Object value;
        WcmException err = null;
        if (this.data.getDataType() == 3 && (value = this.getValue()) != null) {
            Date dateValue = null;
            dateValue = value instanceof WcmDate ? ((WcmDate)value).getDate() : (Date)value;
            err = WcmCtrlFactoryUtil.checkMinMaxDate(this.data, dateValue);
        }
        return err;
    }

    public void setValue(Object objValue) throws WcmException {
        if (objValue != null) {
            Object value = objValue;
            if (value instanceof Value) {
                value = ((Value)objValue).getValue();
            }
            if (value instanceof Date) {
                this.textField.setText(DateFormat.getDateTimeInstance().format((Date)value));
            } else if (value instanceof WcmDate) {
                WcmDate date = (WcmDate)value;
                if (date.getUseDateOnly()) {
                    this.textField.setText(DateFormat.getDateInstance().format(date.getDate()));
                } else {
                    this.textField.setText(DateFormat.getDateTimeInstance().format(date.getDate()));
                }
            } else if (value instanceof WcmUserGroupItem) {
                WcmUserGroupItem userItem;
                this.curUserValue = userItem = (WcmUserGroupItem)value;
                this.textField.setText(userItem.getName());
            } else {
                this.textField.setText(value.toString());
            }
        } else {
            this.textField.setText("");
        }
        this.curValue = this.textField.getText();
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isModified() {
        String value = this.textField.getText();
        return !value.equals(this.curValue);
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }

    protected void createComponent() {
        this.textField = new JTextField(15){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(this.parentContainer.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? 2 : 4);
        this.moreButton = new JButton("...");
        this.moreButton.setMargin(new Insets(0, 1, 0, 1));
    }

    protected void layoutComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        gbCons.weightx = 0.9;
        this.add((Component)this.textField, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        gbCons.fill = 0;
        gbCons.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.moreButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        this.textField.setEnabled(enabled);
        this.moreButton.setEnabled(enabled);
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    public JButton getMoreButton() {
        return this.moreButton;
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }
}

