/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCalendarPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmDate;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class WcmSVCalendarDialog
extends JDialog
implements WcmDialogComponent,
ActionListener {
    private WcmCalendarPanel calPanel;
    private JPanel okCancelClearAllPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearAllButton;
    private static int status = 1;
    private VerbosePropertyDescription data;
    private Container parentContainer;
    private WcmSVCtrl svCtrl;

    public WcmSVCalendarDialog(Frame parent, VerbosePropertyDescription propDescr, WcmSVCtrl textCtrl, ComponentOrientation componentOrientation) {
        super(parent, true);
        this.init(parent, propDescr, textCtrl);
    }

    public WcmSVCalendarDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmSVCtrl textCtrl) {
        super(parent, true);
        this.init(parent, propDescr, textCtrl);
    }

    public WcmSVCalendarDialog(Container parent, VerbosePropertyDescription propDescr, WcmSVCtrl textCtrl) {
        super((Frame)null, true);
        this.init(parent, propDescr, textCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmSVCtrl textCtrl) {
        this.data = propDescr;
        this.parentContainer = parent;
        this.svCtrl = textCtrl;
        Dimension dim = WcmStringUtil.stringToDimension(WcmUIComponentResource.SVCalDiaglogDim);
        if (dim == null) {
            dim = new Dimension(300, 400);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        this.setTitle(WcmUIComponentResource.DateTimeTitle);
        this.createControls();
        this.layoutControls();
        this.initData();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmSVCalendarDialog.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        PropertyDescription propDesc;
        if (this.data != null && (propDesc = this.data.getPropertyDescription()) != null && propDesc instanceof SearchPropertyDescription) {
            WcmDate wcmDate = null;
            if (this.calPanel.isTimeSet()) {
                Date date = this.calPanel.getDateTime();
                if (date != null) {
                    wcmDate = new WcmDate(date);
                    wcmDate.setUseDateOnly(false);
                }
            } else {
                Date date = this.calPanel.getDate();
                if (date != null) {
                    wcmDate = new WcmDate(this.calPanel.getDate());
                    wcmDate.setUseDateOnly(true);
                }
            }
            return wcmDate;
        }
        return this.calPanel.getDateTime();
    }

    private void initData() {
        PropertyDescription propDesc;
        Object objValue = this.svCtrl.getValue();
        if (objValue instanceof Date) {
            Date dateValue = (Date)objValue;
            if (dateValue != null) {
                this.calPanel.setDateTime(dateValue);
            }
        } else if (objValue instanceof WcmDate) {
            WcmDate dateValue = (WcmDate)objValue;
            if (dateValue != null) {
                Date date = dateValue.getDate();
                if (dateValue.getUseDateOnly()) {
                    this.calPanel.setDate(date);
                } else {
                    this.calPanel.setDateTime(date);
                }
            }
        } else if (this.data != null && (propDesc = this.data.getPropertyDescription()) != null && propDesc instanceof SearchPropertyDescription) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(new Date());
            this.calPanel.setDate(gc.getTime());
        }
    }

    private void createControls() {
        this.calPanel = new WcmCalendarPanel(this.parentContainer);
        this.okCancelClearAllPanel = this.createButtonPanel();
    }

    private void layoutControls() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 19;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.9;
        cp.add((Component)this.calPanel, gbCons);
        ++gbCons.gridy;
        gbCons.anchor = 20;
        gbCons.fill = 2;
        gbCons.weighty = 0.1;
        cp.add((Component)this.okCancelClearAllPanel, gbCons);
        this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.clearAllButton.addActionListener(new ClearAllActionListener());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
        ++gbCons.gridx;
        this.clearAllButton = new JButton(WcmUIComponentResource.CLEARALL);
        this.clearAllButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.clearAllMonic));
        p.add((Component)this.clearAllButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    class ClearAllActionListener
    implements ActionListener {
        ClearAllActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            WcmSVCalendarDialog.this.calPanel.clear();
        }
    }
}

