/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Value;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFloat64;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionInteger32;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmNumericPlainDocument;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

class WcmNumericTextField
extends JTextField
implements WcmUIComponent,
ActionListener {
    protected VerbosePropertyDescription data;
    private EventListenerList listenerList = new EventListenerList();
    private String curValue = new String("");

    public WcmNumericTextField(VerbosePropertyDescription propertyDescr) {
        this.data = propertyDescr;
        this.addActionListener(this);
    }

    public Object getValue() {
        Object objValue = this.getText();
        try {
            if (this.data.getDataType() == 6 && ((String)objValue).length() > 0) {
                objValue = ((WcmNumericPlainDocument)this.getDocument()).getIntegerValue();
            } else if (this.data.getDataType() == 4 && ((String)objValue).length() > 0) {
                objValue = ((WcmNumericPlainDocument)this.getDocument()).getDoubleValue();
            }
        }
        catch (Exception e) {
            System.out.println("WcmNumericTextField:getValue:Not a valid number: " + e.getMessage());
        }
        return objValue;
    }

    public WcmException validateValue() {
        Object value;
        WcmException err = this.validateNumericFormat();
        if (err == null && (value = this.getValue()) != null && value.toString().length() != 0) {
            if (this.data.getDataType() == 6) {
                return WcmCtrlFactoryUtil.checkIntegerRange(this.data, value.toString());
            }
            if (this.data.getDataType() == 4) {
                return WcmCtrlFactoryUtil.checkDoubleRange(this.data, value.toString());
            }
        }
        return err;
    }

    public void setValue(Object objValue) throws WcmException {
        if (objValue != null) {
            if (objValue instanceof Value) {
                Value value = (Value)objValue;
                this.setText(this.getFormat().format(value.getValue()));
            } else {
                String strValue = null;
                strValue = this.data.getDataType() == 6 && objValue instanceof Integer ? ((Integer)objValue).toString() : (this.data.getDataType() == 4 && objValue instanceof Double ? ((Double)objValue).toString() : objValue.toString());
                this.setText(strValue);
            }
            this.curValue = this.getText();
        }
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isModified() {
        String value = this.getText();
        return !value.equals(this.curValue);
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }

    public void setFormat(DecimalFormat format) {
        ((WcmNumericPlainDocument)this.getDocument()).setFormat(format);
    }

    public DecimalFormat getFormat() {
        return ((WcmNumericPlainDocument)this.getDocument()).getFormat();
    }

    public void formatChanged() {
        this.setFormat(this.getFormat());
    }

    protected Document createDefaultModel() {
        return new WcmNumericPlainDocument();
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            WcmException err = this.validateNumericFormat();
            if (err == null) {
                this.setValue(this.getValue());
                WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this, evt);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public WcmException validateNumericFormat() {
        if (this.data.getDataType() == 6) {
            try {
                ((WcmNumericPlainDocument)this.getDocument()).getIntegerValue();
            }
            catch (Exception e) {
                Integer minValue = ((VerbosePropertyDescriptionInteger32)this.data).getPropertyMinimumInteger32();
                Integer maxValue = ((VerbosePropertyDescriptionInteger32)this.data).getPropertyMaximumInteger32();
                if (maxValue != null && minValue != null) {
                    return new WcmException("client.WcmNumericTextField.ValidateIntegerValueRangeError", "Not a valid integer. The value must be an integer within the range of {0} to {1}.", minValue, (Object)maxValue);
                }
                return new WcmException("client.WcmNumericTextField.ValidateIntegerValueError", "Not a valid integer.");
            }
        }
        if (this.data.getDataType() == 4) {
            try {
                ((WcmNumericPlainDocument)this.getDocument()).getDoubleValue();
            }
            catch (Exception e) {
                Double minValue = ((VerbosePropertyDescriptionFloat64)this.data).getPropertyMinimumFloat64();
                Double maxValue = ((VerbosePropertyDescriptionFloat64)this.data).getPropertyMaximumFloat64();
                if (maxValue != null && minValue != null) {
                    return new WcmException("client.WcmNumericTextField.ValidateDoubleValueRangeError", "Not a valid number. The value must be a double within the range of {0} to {1}.", minValue, (Object)maxValue);
                }
                return new WcmException("client.WcmNumericTextField.ValidateDoubleValueError", "Not a valid number.");
            }
        }
        return null;
    }
}

