/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.util.WcmException;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class WcmNumericPlainDocument
extends PlainDocument {
    protected DecimalFormat format;
    protected ParsePosition parsePos = new ParsePosition(0);
    protected static DecimalFormat defaultFormat = new DecimalFormat();

    public WcmNumericPlainDocument() {
        this.setFormat(null);
    }

    public WcmNumericPlainDocument(DecimalFormat format) {
        this.setFormat(format);
    }

    public void setFormat(DecimalFormat format) {
        this.format = format != null ? format : (DecimalFormat)defaultFormat.clone();
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public Object getValue() throws Exception {
        Number result = null;
        result = this.getNumberValue();
        return result;
    }

    public Number getNumberValue() throws Exception {
        String fieldValue = null;
        try {
            fieldValue = this.getText(0, this.getLength());
            this.parsePos.setIndex(0);
            Number result = this.format.parse(fieldValue, this.parsePos);
            if (this.parsePos.getIndex() != this.getLength()) {
                throw new WcmException("client.WcmNumericPlainDocument.getNumberValue", "Not a valid number");
            }
            return result;
        }
        catch (BadLocationException e) {
            throw new WcmException("client.WcmNumericPlainDocument.getNumberValue", "Not a valid number");
        }
    }

    public Integer getIntegerValue() throws Exception {
        Integer intValue = null;
        String strValue = this.getText(0, this.getLength());
        if (strValue.length() != 0) {
            intValue = new Integer(strValue);
        }
        return intValue;
    }

    public Double getDoubleValue() throws Exception {
        Double doubleValue = null;
        try {
            Number result = this.getNumberValue();
            if (result != null) {
                doubleValue = new Double(result.doubleValue());
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmNumericPlainDocument.getDoubleValue", "Not a valid double");
        }
        return doubleValue;
    }

    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(offset, s, attributeSet);
    }
}

