/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmChoiceListPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class WcmNestedCLDialog
extends JDialog
implements WcmDialogComponent,
ActionListener,
ListSelectionListener {
    private WcmChoiceListPanel choiceListPanel;
    private JList list;
    private JScrollPane listScrollPane;
    private JPanel okCancelPanel;
    private DefaultListModel listModel;
    private JButton addButton;
    private JButton remButton;
    private JButton okButton;
    private JButton cancelButton;
    static int status = 1;
    private VerbosePropertyDescription data;
    private Container parentContainer;
    private WcmMVCtrl mvCtrl;

    public WcmNestedCLDialog(Frame parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    public WcmNestedCLDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        try {
            this.data = propDescr;
            this.parentContainer = parent;
            this.mvCtrl = mvCtrl;
            Dimension dimension = WcmStringUtil.stringToDimension(WcmUIComponentResource.MVHierCLDiaglogDim);
            if (dimension == null) {
                dimension = new Dimension(300, 400);
            }
            this.setSize(dimension);
            this.setLocationRelativeTo(parent);
            this.setTitle(WcmCtrlFactoryUtil.getChoiceTitle(this.data, true));
            this.createComponents();
            this.layoutComponents();
            this.initList();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    WcmNestedCLDialog.this.setVisible(false);
                }

                public void windowOpened(WindowEvent event) {
                    if (WcmNestedCLDialog.this.choiceListPanel != null) {
                        WcmNestedCLDialog.this.choiceListPanel.requestFocus();
                    }
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        return this.listModel.toArray();
    }

    protected void createComponents() {
        this.choiceListPanel = new WcmChoiceListPanel(this.data);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.list);
        this.okCancelPanel = this.createButtonPanel();
    }

    protected void layoutComponents() {
        GridBagConstraints gbCons = null;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 1, 1, 1);
        JLabel selLabel = new JLabel(WcmUIComponentResource.SELECTED_CHOICES);
        cp.add((Component)selLabel, gbCons);
        ++gbCons.gridy;
        gbCons.weightx = 0.8;
        gbCons.fill = 1;
        gbCons.weighty = 0.5;
        gbCons.insets = new Insets(1, 1, 1, 1);
        cp.add((Component)this.listScrollPane, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        gbCons.fill = 0;
        this.remButton = new JButton("-");
        this.remButton.setFont(new Font("Dialog", 1, 14));
        this.remButton.setMargin(new Insets(1, 8, 1, 8));
        this.remButton.addActionListener(new RemoveActionListener());
        cp.add((Component)this.remButton, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 1, 1, 1);
        gbCons.fill = 2;
        JLabel availLabel = new JLabel(WcmUIComponentResource.AVAILABLE_CHOICE);
        cp.add((Component)availLabel, gbCons);
        ++gbCons.gridy;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.5;
        gbCons.insets = new Insets(1, 1, 1, 1);
        gbCons.fill = 1;
        cp.add((Component)this.choiceListPanel, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        gbCons.fill = 0;
        this.addButton = new JButton("+");
        this.addButton.setFont(new Font("Dialog", 1, 14));
        this.addButton.setMargin(new Insets(1, 8, 1, 8));
        this.addButton.addActionListener(new AddActionListener());
        cp.add((Component)this.addButton, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.1;
        gbCons.fill = 0;
        gbCons.anchor = 10;
        cp.add((Component)this.okCancelPanel, gbCons);
        this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    private void addToList(Object value) {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (index == -1 || index + 1 == size) {
            this.listModel.addElement(value);
            this.list.setSelectedIndex(size);
        } else {
            this.listModel.insertElementAt(value, index + 1);
            this.list.setSelectedIndex(index + 1);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    private void initList() {
        Object[] values = WcmCtrlFactoryUtil.getSelectedItems(this.mvCtrl);
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                this.listModel.addElement(values[i]);
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = WcmNestedCLDialog.this.list.getSelectedIndex();
            WcmNestedCLDialog.this.listModel.remove(index);
            int size = WcmNestedCLDialog.this.listModel.getSize();
            if (size == 0) {
                WcmNestedCLDialog.this.remButton.setEnabled(false);
            } else {
                if (index == WcmNestedCLDialog.this.listModel.getSize()) {
                    --index;
                }
                WcmNestedCLDialog.this.list.setSelectedIndex(index);
            }
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object objValue = WcmNestedCLDialog.this.choiceListPanel.getValue();
            if (objValue != null) {
                WcmNestedCLDialog.this.addToList(objValue);
            }
        }
    }
}

