/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmComboBox;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmNumericTextField;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmStringTextField;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class WcmMVDialog
extends JDialog
implements WcmDialogComponent,
ListSelectionListener,
ActionListener {
    private JLabel compLabel;
    private WcmStringTextField textField;
    private WcmNumericTextField numericField;
    private WcmComboBox comboBox;
    private JLabel listLabel;
    private JList list;
    private DefaultListModel listModel;
    private JButton addButton;
    private JButton removeButton;
    private JPanel okCancelPanel;
    private JButton okButton;
    private JButton cancelButton;
    private static int status = 1;
    private JScrollPane listScrollPane;
    private VerbosePropertyDescription data;
    private Container parentContainer;
    private WcmMVCtrl mvCtrl;
    private WcmMVDialog mvDiagHandle;

    public WcmMVDialog(Frame parent, VerbosePropertyDescription propDescr, WcmMVCtrl textAreaCtrl) {
        super(parent, true);
        this.init(parent, propDescr, textAreaCtrl);
    }

    public WcmMVDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmMVCtrl textAreaCtrl) {
        super(parent, true);
        this.init(parent, propDescr, textAreaCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmMVCtrl textAreaCtrl) {
        this.data = propDescr;
        this.parentContainer = parent;
        this.mvCtrl = textAreaCtrl;
        this.mvDiagHandle = this;
        Dimension dim = WcmStringUtil.stringToDimension(WcmUIComponentResource.MVDiaglogDim);
        if (dim == null) {
            dim = new Dimension(300, 200);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        this.setTitle(WcmUIComponentResource.MVDialogTitle);
        this.createControls();
        this.layoutControls();
        this.populateList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmMVDialog.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        return this.listModel.toArray();
    }

    private void createControls() {
        if (this.data.getDataType() == 2) {
            this.compLabel = new JLabel(WcmUIComponentResource.SELECT_A_VALUE);
            this.comboBox = new WcmComboBox(this.data, WcmUIComponentResource.boolStrings);
        } else {
            this.compLabel = new JLabel(WcmUIComponentResource.ENTER_VALUE);
            if (this.data.getDataType() == 6 || this.data.getDataType() == 4) {
                this.numericField = new WcmNumericTextField(this.data);
                this.numericField.addActionListener(new AddActionListener());
            } else {
                this.textField = new WcmStringTextField(this.data);
                this.textField.addActionListener(new AddActionListener());
            }
        }
        this.addButton = new JButton(WcmUIComponentResource.ADD);
        this.addButton.setMargin(new Insets(1, 1, 1, 1));
        this.addButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.addMonic));
        this.addButton.addActionListener(new AddActionListener());
        this.listLabel = new JLabel(WcmUIComponentResource.SELECTED_VALUE);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.list);
        this.removeButton = new JButton(WcmUIComponentResource.REMOVE);
        this.removeButton.setMargin(new Insets(1, 1, 1, 1));
        this.removeButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.removeMonic));
        this.removeButton.addActionListener(new RemoveActionListener());
        this.okCancelPanel = this.createButtonPanel();
    }

    private void layoutControls() {
        GridBagConstraints gbCons = null;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        cp.add((Component)this.compLabel, gbCons);
        ++gbCons.gridy;
        gbCons.weightx = 0.8;
        if (this.data.getDataType() == 2 && this.comboBox != null) {
            this.comboBox.setRequestFocusEnabled(true);
            cp.add((Component)this.comboBox, gbCons);
        } else if (this.textField != null) {
            this.textField.setRequestFocusEnabled(true);
            cp.add((Component)this.textField, gbCons);
        } else {
            this.numericField.setRequestFocusEnabled(true);
            cp.add((Component)this.numericField, gbCons);
        }
        ++gbCons.gridx;
        gbCons.weightx = 0.2;
        cp.add((Component)this.addButton, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.weightx = 0.0;
        cp.add((Component)this.listLabel, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 0.8;
        gbCons.weighty = 1.0;
        cp.add((Component)this.listScrollPane, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.2;
        gbCons.weighty = 0.0;
        cp.add((Component)this.removeButton, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 0;
        cp.add((Component)this.okCancelPanel, gbCons);
        this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    private void addToList(Object value) {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (index == -1 || index + 1 == size) {
            this.listModel.addElement(value);
            this.list.setSelectedIndex(size);
        } else {
            this.listModel.insertElementAt(value, index + 1);
            this.list.setSelectedIndex(index + 1);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        }
    }

    private void populateList() {
        block3: {
            Object value;
            block2: {
                value = this.mvCtrl.getValue();
                if (!(value instanceof Object[])) break block2;
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    this.listModel.addElement(values[i]);
                }
                break block3;
            }
            if (!(value instanceof Values)) break block3;
            Values values = (Values)value;
            for (int i = 0; i < values.size(); ++i) {
                Value aValue = (Value)values.get(i);
                this.listModel.addElement(aValue.getValue());
            }
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object objValue = null;
            if (WcmMVDialog.this.comboBox != null) {
                objValue = WcmMVDialog.this.comboBox.getValue();
                WcmMVDialog.this.comboBox.grabFocus();
            } else {
                if (WcmMVDialog.this.textField != null) {
                    objValue = WcmMVDialog.this.textField.getValue();
                } else if (WcmMVDialog.this.numericField != null) {
                    objValue = WcmMVDialog.this.numericField.getValue();
                }
                if (objValue != null) {
                    char[] tmpBuf = objValue.toString().toCharArray();
                    int blankChar = 0;
                    for (int i = 0; i < tmpBuf.length; ++i) {
                        if (tmpBuf[i] != ' ') continue;
                        ++blankChar;
                    }
                    if (blankChar == tmpBuf.length) {
                        objValue = null;
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
            if (objValue != null) {
                WcmException ex;
                if (WcmMVDialog.this.numericField != null) {
                    ex = WcmMVDialog.this.numericField.validateValue();
                    if (ex != null) {
                        JOptionPane.showMessageDialog(WcmMVDialog.this.mvDiagHandle, ex.getLocalizedMessage(), "ErrorMessage", 0);
                        WcmMVDialog.this.numericField.setText("");
                        WcmMVDialog.this.numericField.grabFocus();
                        return;
                    }
                } else if (WcmMVDialog.this.textField != null && (ex = WcmMVDialog.this.textField.validateValue()) != null) {
                    JOptionPane.showMessageDialog(WcmMVDialog.this.mvDiagHandle, ex.getLocalizedMessage(), "ErrorMessage", 0);
                    WcmMVDialog.this.textField.setText("");
                    WcmMVDialog.this.textField.grabFocus();
                    return;
                }
                WcmMVDialog.this.addToList(objValue);
            }
            if (WcmMVDialog.this.textField != null) {
                WcmMVDialog.this.textField.setText("");
                WcmMVDialog.this.textField.grabFocus();
            } else if (WcmMVDialog.this.numericField != null) {
                WcmMVDialog.this.numericField.setText("");
                WcmMVDialog.this.numericField.grabFocus();
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = WcmMVDialog.this.list.getSelectedIndex();
            if (index == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            WcmMVDialog.this.listModel.remove(index);
            int size = WcmMVDialog.this.listModel.getSize();
            if (size == 0) {
                WcmMVDialog.this.removeButton.setEnabled(false);
            } else {
                if (index == WcmMVDialog.this.listModel.getSize()) {
                    --index;
                }
                WcmMVDialog.this.list.setSelectedIndex(index);
            }
        }
    }
}

