/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogFactory;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmListPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class WcmMVCtrl
extends JPanel
implements WcmUIComponent {
    private WcmListPanel list;
    private JButton moreButton;
    private WcmMVCtrl mvCtrl;
    private Container parentContainer;
    private VerbosePropertyDescription data;
    private Object curValue;
    private EventListenerList listenerList = new EventListenerList();

    public WcmMVCtrl(Container frame, VerbosePropertyDescription theData) {
        this.data = theData;
        this.parentContainer = frame;
        this.mvCtrl = this;
        this.list = new WcmListPanel(theData);
        this.moreButton = new JButton("...");
        this.moreButton.setMargin(new Insets(0, 1, 0, 1));
        this.layoutComponents();
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WcmMVCtrl.this.createDialog(evt);
                if (WcmMVCtrl.this.parentContainer != null) {
                    WcmMVCtrl.this.parentContainer.requestFocus();
                }
            }
        });
    }

    public Object getValue() {
        return this.list.getValue();
    }

    public WcmException validateValue() {
        return this.list.validateValue();
    }

    public void setValue(Object objValue) throws WcmException {
        this.list.setValue(objValue);
    }

    public boolean isMultiLine() {
        return this.list.isMultiLine();
    }

    public boolean isModified() {
        return this.list.isModified();
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = null;
        gbCons = new GridBagConstraints();
        gbCons.anchor = 18;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = -1;
        gbCons.gridheight = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        this.add((Component)this.list, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridwidth = 0;
        gbCons.fill = 0;
        gbCons.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.moreButton, gbCons);
    }

    private void createDialog(ActionEvent evt) {
        WcmDialogComponent mvDialog = null;
        mvDialog = this.data.getDataType() == 3 ? WcmDialogFactory.getMVCalendarDialog(this.parentContainer, this.data, this.mvCtrl) : (this.data.getHasCVL() ? (this.data.getIsHierarchicalCVL() ? WcmDialogFactory.getNestedCLDialog(this.parentContainer, this.data, this.mvCtrl) : WcmDialogFactory.getAddRemoveDialog(this.parentContainer, this.data, this.mvCtrl)) : (this.data.getHasMarkingSet() ? WcmDialogFactory.getAddRemoveDialog(this.parentContainer, this.data, this.mvCtrl) : WcmDialogFactory.getMVDialog(this.parentContainer, this.data, this.mvCtrl)));
        if (mvDialog != null) {
            int status = mvDialog.showDialog();
            if (status == 0) {
                try {
                    this.list.setValue(mvDialog.getData(), true);
                }
                catch (WcmException ex) {
                    // empty catch block
                }
            }
            WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this.list, evt);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        this.list.setEnabled(enabled);
        this.moreButton.setEnabled(enabled);
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    public JButton getMoreButton() {
        return this.moreButton;
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }
}

