/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmButtonStateListener;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCalendarPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMouseActionListener;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMouseAdapter;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUpDownDeleteBtnPanel;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WcmMVCalendarDialog
extends JDialog
implements WcmDialogComponent,
ActionListener,
WcmMouseActionListener {
    private WcmCalendarPanel calPanel;
    private JList selectedList;
    private JLabel listLabel;
    private WcmUpDownDeleteBtnPanel upDownDelBtnPanel;
    private AbstractButton addButton;
    private JButton clearAllButton;
    private JButton okButton;
    private JButton cancelButton;
    static int status = 1;
    private VerbosePropertyDescription data;
    private Container parentContainer;
    private WcmMVCtrl mvCtrl;

    public WcmMVCalendarDialog(Frame parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    public WcmMVCalendarDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    public WcmMVCalendarDialog(Container parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super((Frame)null, true);
        this.init(parent, propDescr, mvCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        this.data = propDescr;
        this.parentContainer = parent;
        this.mvCtrl = mvCtrl;
        Dimension dimension = WcmStringUtil.stringToDimension(WcmUIComponentResource.MVCalDiaglogDim);
        if (dimension == null) {
            dimension = new Dimension(400, 340);
        }
        this.setSize(dimension);
        this.setLocationRelativeTo(parent);
        this.setTitle(WcmUIComponentResource.DateTimeTitle);
        this.setVisible(false);
        this.createControls();
        this.layoutControls();
        this.setupListeners();
        this.initList();
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        DefaultListModel listModel = (DefaultListModel)this.selectedList.getModel();
        return listModel.toArray();
    }

    public void initList() {
        try {
            DefaultListModel listModel = (DefaultListModel)this.selectedList.getModel();
            Object value = this.mvCtrl.getValue();
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    listModel.addElement(values[i]);
                }
            } else if (value instanceof Values) {
                Values values = (Values)value;
                for (int i = 0; i < values.size(); ++i) {
                    Value aValue = (Value)values.get(i);
                    if (aValue instanceof Date) {
                        listModel.addElement(DateFormat.getDateTimeInstance().format(aValue));
                        continue;
                    }
                    Object objValue = aValue.getValue();
                    if (objValue instanceof Date) {
                        listModel.addElement(DateFormat.getDateTimeInstance().format(objValue));
                        continue;
                    }
                    listModel.addElement(aValue.getValue());
                }
            }
            this.selectedList.setModel(listModel);
            if (listModel.size() > 0) {
                this.upDownDelBtnPanel.enableButtons(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToList(Object value) {
        DefaultListModel listModel = (DefaultListModel)this.selectedList.getModel();
        int index = this.selectedList.getSelectedIndex();
        int size = listModel.getSize();
        if (index == -1 || index + 1 == size) {
            listModel.addElement(value);
            this.selectedList.setSelectedIndex(size);
        } else {
            listModel.insertElementAt(value, index + 1);
            this.selectedList.setSelectedIndex(index + 1);
        }
    }

    protected void removeSelectedItems() {
        int[] indices = null;
        Object[] items = null;
        DefaultListModel listModel = null;
        try {
            indices = this.selectedList.getSelectedIndices();
            if (indices.length > 0) {
                items = new Object[indices.length];
                listModel = (DefaultListModel)this.selectedList.getModel();
                for (int i = indices.length - 1; i >= 0; --i) {
                    listModel.removeElementAt(indices[i]);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void clearSelectedList() {
        DefaultListModel listModel = null;
        try {
            listModel = (DefaultListModel)this.selectedList.getModel();
            listModel.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createControls() {
        this.calPanel = new WcmCalendarPanel(this.parentContainer);
        this.listLabel = new JLabel(WcmUIComponentResource.SELECTED_DATETIME);
        this.selectedList = new JList(new DefaultListModel());
        this.upDownDelBtnPanel = new WcmUpDownDeleteBtnPanel(this.selectedList, true);
    }

    protected void layoutControls() {
        GridBagConstraints gbCons = null;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        try {
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            cp.add((Component)this.calPanel, gbCons);
            gbCons.fill = 3;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            cp.add((Component)this.createAddButtonPanel(), gbCons);
            gbCons.fill = 1;
            ++gbCons.gridx;
            cp.add((Component)this.createSelectedItemsPanel(), gbCons);
            gbCons.fill = 3;
            ++gbCons.gridx;
            cp.add((Component)this.upDownDelBtnPanel, gbCons);
            ++gbCons.gridy;
            gbCons.gridx = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.1;
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridwidth = 0;
            cp.add((Component)this.createButtonPanel(), gbCons);
            this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupListeners() {
        this.addButton.addActionListener(new AddActionListener());
        this.selectedList.addMouseListener(new WcmMouseAdapter(this));
        this.calPanel.getDateEditor().addButtonStateListener(new WcmButtonStateListener(){

            public void buttonStateChanged(boolean bEnable) {
                WcmMVCalendarDialog.this.addButton.setEnabled(bEnable);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmMVCalendarDialog.this.setVisible(false);
            }
        });
    }

    protected JPanel createAddButtonPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            this.addButton = WcmImageLoader.createToolBarButton("action/button/InsertRow24.gif", WcmUIComponentResource.addItem, false);
            this.addButton.setMargin(new Insets(1, 1, 1, 1));
            this.addButton.setFocusPainted(true);
            panel.add((Component)this.addButton, gbCons);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return panel;
    }

    protected JPanel createSelectedItemsPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 20;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            panel.add((Component)this.listLabel, gbCons);
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            panel.add((Component)new JScrollPane(this.selectedList), gbCons);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.clearAllButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
        ++gbCons.gridx;
        this.clearAllButton = new JButton(WcmUIComponentResource.CLEARALL);
        this.clearAllButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.clearAllMonic));
        p.add((Component)this.clearAllButton, gbCons);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        } else if (e.getSource() == this.clearAllButton) {
            DefaultListModel listModel = (DefaultListModel)this.selectedList.getModel();
            int opt = 0;
            if (listModel.getSize() > 0 && (opt = JOptionPane.showConfirmDialog(this.parentContainer, WcmUIComponentResource.AskCancelClearAll, WcmUIComponentResource.DateTimeTitle, 0)) == 0) {
                this.clearSelectedList();
            }
            if (opt == 0) {
                this.calPanel.clear();
                this.addButton.setEnabled(false);
                this.upDownDelBtnPanel.enableButtons(false);
            }
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        Object object = event.getSource();
        if (object == this.selectedList) {
            this.removeSelectedItems();
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Date date = WcmMVCalendarDialog.this.calPanel.getDateTime();
            if (date != null) {
                WcmMVCalendarDialog.this.addToList(DateFormat.getDateTimeInstance().format(date));
                WcmMVCalendarDialog.this.upDownDelBtnPanel.enableButtons(true);
            }
        }
    }
}

