/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WcmListPanel
extends JPanel
implements WcmUIComponent {
    protected VerbosePropertyDescription data;
    private JList list;
    private DefaultListModel curValue = new DefaultListModel();

    public WcmListPanel(VerbosePropertyDescription theData) {
        this.data = theData;
        this.setLayout(new BorderLayout());
        this.list = new JList(new DefaultListModel()){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.list.setPrototypeCellValue("Index 1234567890");
        this.list.setVisibleRowCount(4);
        this.add((Component)new JScrollPane(this.list), "Center");
    }

    public Object getValue() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        Values values = ObjectFactory.getValues();
        Object obj = null;
        for (int i = 0; i < model.getSize(); ++i) {
            Value value = ObjectFactory.getValue();
            obj = WcmCtrlFactoryUtil.getObject(this.data, model.getElementAt(i));
            if (obj == null) continue;
            PropertyUtil.setValueObjectValue(value, obj);
            values.add((Object)value);
        }
        return values;
    }

    public void setValue(Object objValue, boolean saveCurValue) throws WcmException {
        if (saveCurValue) {
            DefaultListModel tmpCurValue = new DefaultListModel();
            this.cloneModel(this.curValue, tmpCurValue);
            this.setValue(objValue);
            this.curValue = tmpCurValue;
        } else {
            this.setValue(objValue);
        }
    }

    public void setValue(Object objValue) throws WcmException {
        if (objValue != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            if (objValue instanceof Date) {
                model.addElement(WcmCtrlFactoryUtil.getListElement(objValue));
            } else {
                int i;
                Object values;
                model.removeAllElements();
                if (objValue instanceof Object[]) {
                    values = (Object[])objValue;
                    for (i = 0; i < ((Object[])values).length; ++i) {
                        model.addElement(WcmCtrlFactoryUtil.getListElement(values[i]));
                    }
                } else if (objValue instanceof List) {
                    values = (List)objValue;
                    for (i = 0; i < values.size(); ++i) {
                        model.addElement(WcmCtrlFactoryUtil.getListElement(values.get(i)));
                    }
                } else {
                    model.addElement(WcmCtrlFactoryUtil.getListElement(objValue));
                }
            }
            if (this.data.getDataType() == 5) {
                StringBuffer strBuf = null;
                for (int j = 0; j < model.getSize(); ++j) {
                    strBuf = new StringBuffer(model.getElementAt(j).toString());
                    if (strBuf.charAt(0) != '{') {
                        strBuf.insert(0, '{');
                    }
                    if (strBuf.charAt(strBuf.length() - 1) != '}') {
                        strBuf.append('}');
                    }
                    model.set(j, strBuf.toString());
                }
            }
            this.cloneModel(model, this.curValue);
        }
    }

    public WcmException validateValue() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        WcmException err = null;
        if (model.size() > 0) {
            if (this.data.getDataType() == 8 || this.data.getDataType() == 5) {
                err = this.validateString(model);
            } else if (this.data.getDataType() == 4) {
                err = this.validateDouble(model);
            } else if (this.data.getDataType() == 6) {
                err = this.validateInteger(model);
            } else if (this.data.getDataType() == 2) {
                err = this.validateBoolean(model);
            } else if (this.data.getDataType() == 3) {
                err = this.validateMinMaxDate(model);
            }
        }
        return err;
    }

    public boolean isMultiLine() {
        return true;
    }

    public boolean isModified() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        if (model.getSize() != this.curValue.getSize()) {
            return true;
        }
        for (int i = model.getSize() - 1; i >= 0; --i) {
            if (this.curValue.contains(model.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    private WcmException validateString(DefaultListModel model) {
        for (int i = 0; i < model.size(); ++i) {
            String strValue = model.getElementAt(i).toString();
            WcmException errStr = WcmCtrlFactoryUtil.checkStringLength(this.data, strValue);
            if (errStr == null) continue;
            return errStr;
        }
        return null;
    }

    private WcmException validateBoolean(DefaultListModel model) {
        for (int i = 0; i < model.size(); ++i) {
            if (WcmString.compareIgnoreCase("true", model.getElementAt(i).toString()) == 0 || WcmString.compareIgnoreCase("false", model.getElementAt(i).toString()) == 0) continue;
            return new WcmException("client.WcmCtrlFactoryUtil.ValidateBooleanError", "Value of string {0} is not a valid Boolean value", (Object)model.getElementAt(i).toString());
        }
        return null;
    }

    private WcmException validateDouble(DefaultListModel model) {
        WcmException errStr = null;
        try {
            for (int i = 0; i < model.size(); ++i) {
                String value = model.getElementAt(i).toString();
                if (value.length() == 0) continue;
                new Double(value);
                errStr = WcmCtrlFactoryUtil.checkDoubleRange(this.data, value);
            }
        }
        catch (Exception e) {
            return new WcmException("client.WcmListPanel.ValidateDoubleError", "Expecting a double value.");
        }
        return errStr;
    }

    private WcmException validateMinMaxDate(DefaultListModel model) {
        WcmException errStr = null;
        for (int i = 0; i < model.size(); ++i) {
            Object obj = WcmCtrlFactoryUtil.getObject(this.data, model.getElementAt(i));
            if (obj instanceof Date) {
                errStr = WcmCtrlFactoryUtil.checkMinMaxDate(this.data, (Date)obj);
            }
            if (errStr == null) continue;
            return errStr;
        }
        return null;
    }

    private WcmException validateInteger(DefaultListModel model) {
        WcmException errStr = null;
        try {
            for (int i = 0; i < model.size(); ++i) {
                String value = model.getElementAt(i).toString();
                if (value.length() == 0) continue;
                new Integer(value);
                errStr = WcmCtrlFactoryUtil.checkIntegerRange(this.data, value);
            }
        }
        catch (Exception e) {
            return new WcmException("client.WcmListPanel.ValidateIntegerError", "Expecting an integer value");
        }
        return errStr;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        } else {
            super.setEnabled(false);
            this.list.setBackground(new Color(this.getBackground().getRGB()));
        }
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
    }

    public void cloneModel(DefaultListModel srcModel, DefaultListModel destModel) {
        destModel.removeAllElements();
        for (int i = 0; i < srcModel.size(); ++i) {
            destModel.addElement(srcModel.getElementAt(i));
        }
    }
}

